/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.AssociationIdListCopier;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartAssociationsOnceRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, StartAssociationsOnceRequest> {
    private static final SdkField<List<String>> ASSOCIATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(StartAssociationsOnceRequest.getter(StartAssociationsOnceRequest::associationIds)).setter(StartAssociationsOnceRequest.setter(Builder::associationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_IDS_FIELD));
    private final List<String> associationIds;

    private StartAssociationsOnceRequest(BuilderImpl builder) {
        super(builder);
        this.associationIds = builder.associationIds;
    }

    public List<String> associationIds() {
        return this.associationIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAssociationsOnceRequest)) {
            return false;
        }
        StartAssociationsOnceRequest other = (StartAssociationsOnceRequest)((Object)obj);
        return Objects.equals(this.associationIds(), other.associationIds());
    }

    public String toString() {
        return ToString.builder((String)"StartAssociationsOnceRequest").add("AssociationIds", this.associationIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationIds": {
                return Optional.ofNullable(clazz.cast(this.associationIds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartAssociationsOnceRequest, T> g) {
        return obj -> g.apply((StartAssociationsOnceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private List<String> associationIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartAssociationsOnceRequest model) {
            super(model);
            this.associationIds(model.associationIds);
        }

        public final Collection<String> getAssociationIds() {
            return this.associationIds;
        }

        @Override
        public final Builder associationIds(Collection<String> associationIds) {
            this.associationIds = AssociationIdListCopier.copy(associationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationIds(String ... associationIds) {
            this.associationIds(Arrays.asList(associationIds));
            return this;
        }

        public final void setAssociationIds(Collection<String> associationIds) {
            this.associationIds = AssociationIdListCopier.copy(associationIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAssociationsOnceRequest build() {
            return new StartAssociationsOnceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartAssociationsOnceRequest> {
        public Builder associationIds(Collection<String> var1);

        public Builder associationIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

