/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The combination of AWS Regions and accounts targeted by the current Automation execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetLocation implements SdkPojo, Serializable, ToCopyableBuilder<TargetLocation.Builder, TargetLocation> {
    private static final SdkField<List<String>> ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(TargetLocation::accounts))
            .setter(setter(Builder::accounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(TargetLocation::regions))
            .setter(setter(Builder::regions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Regions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TARGET_LOCATION_MAX_CONCURRENCY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TargetLocation::targetLocationMaxConcurrency))
            .setter(setter(Builder::targetLocationMaxConcurrency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLocationMaxConcurrency")
                    .build()).build();

    private static final SdkField<String> TARGET_LOCATION_MAX_ERRORS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TargetLocation::targetLocationMaxErrors)).setter(setter(Builder::targetLocationMaxErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLocationMaxErrors").build())
            .build();

    private static final SdkField<String> EXECUTION_ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TargetLocation::executionRoleName)).setter(setter(Builder::executionRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNTS_FIELD, REGIONS_FIELD,
            TARGET_LOCATION_MAX_CONCURRENCY_FIELD, TARGET_LOCATION_MAX_ERRORS_FIELD, EXECUTION_ROLE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> accounts;

    private final List<String> regions;

    private final String targetLocationMaxConcurrency;

    private final String targetLocationMaxErrors;

    private final String executionRoleName;

    private TargetLocation(BuilderImpl builder) {
        this.accounts = builder.accounts;
        this.regions = builder.regions;
        this.targetLocationMaxConcurrency = builder.targetLocationMaxConcurrency;
        this.targetLocationMaxErrors = builder.targetLocationMaxErrors;
        this.executionRoleName = builder.executionRoleName;
    }

    /**
     * <p>
     * The AWS accounts targeted by the current Automation execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The AWS accounts targeted by the current Automation execution.
     */
    public List<String> accounts() {
        return accounts;
    }

    /**
     * <p>
     * The AWS Regions targeted by the current Automation execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The AWS Regions targeted by the current Automation execution.
     */
    public List<String> regions() {
        return regions;
    }

    /**
     * <p>
     * The maxium number of AWS accounts and AWS regions allowed to run the Automation concurrently
     * </p>
     * 
     * @return The maxium number of AWS accounts and AWS regions allowed to run the Automation concurrently
     */
    public String targetLocationMaxConcurrency() {
        return targetLocationMaxConcurrency;
    }

    /**
     * <p>
     * The maxium number of errors allowed before the system stops queueing additional Automation executions for the
     * currently running Automation.
     * </p>
     * 
     * @return The maxium number of errors allowed before the system stops queueing additional Automation executions for
     *         the currently running Automation.
     */
    public String targetLocationMaxErrors() {
        return targetLocationMaxErrors;
    }

    /**
     * <p>
     * The Automation execution role used by the currently running Automation.
     * </p>
     * 
     * @return The Automation execution role used by the currently running Automation.
     */
    public String executionRoleName() {
        return executionRoleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accounts());
        hashCode = 31 * hashCode + Objects.hashCode(regions());
        hashCode = 31 * hashCode + Objects.hashCode(targetLocationMaxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(targetLocationMaxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetLocation)) {
            return false;
        }
        TargetLocation other = (TargetLocation) obj;
        return Objects.equals(accounts(), other.accounts()) && Objects.equals(regions(), other.regions())
                && Objects.equals(targetLocationMaxConcurrency(), other.targetLocationMaxConcurrency())
                && Objects.equals(targetLocationMaxErrors(), other.targetLocationMaxErrors())
                && Objects.equals(executionRoleName(), other.executionRoleName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TargetLocation").add("Accounts", accounts()).add("Regions", regions())
                .add("TargetLocationMaxConcurrency", targetLocationMaxConcurrency())
                .add("TargetLocationMaxErrors", targetLocationMaxErrors()).add("ExecutionRoleName", executionRoleName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Accounts":
            return Optional.ofNullable(clazz.cast(accounts()));
        case "Regions":
            return Optional.ofNullable(clazz.cast(regions()));
        case "TargetLocationMaxConcurrency":
            return Optional.ofNullable(clazz.cast(targetLocationMaxConcurrency()));
        case "TargetLocationMaxErrors":
            return Optional.ofNullable(clazz.cast(targetLocationMaxErrors()));
        case "ExecutionRoleName":
            return Optional.ofNullable(clazz.cast(executionRoleName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetLocation, T> g) {
        return obj -> g.apply((TargetLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetLocation> {
        /**
         * <p>
         * The AWS accounts targeted by the current Automation execution.
         * </p>
         * 
         * @param accounts
         *        The AWS accounts targeted by the current Automation execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(Collection<String> accounts);

        /**
         * <p>
         * The AWS accounts targeted by the current Automation execution.
         * </p>
         * 
         * @param accounts
         *        The AWS accounts targeted by the current Automation execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(String... accounts);

        /**
         * <p>
         * The AWS Regions targeted by the current Automation execution.
         * </p>
         * 
         * @param regions
         *        The AWS Regions targeted by the current Automation execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Collection<String> regions);

        /**
         * <p>
         * The AWS Regions targeted by the current Automation execution.
         * </p>
         * 
         * @param regions
         *        The AWS Regions targeted by the current Automation execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(String... regions);

        /**
         * <p>
         * The maxium number of AWS accounts and AWS regions allowed to run the Automation concurrently
         * </p>
         * 
         * @param targetLocationMaxConcurrency
         *        The maxium number of AWS accounts and AWS regions allowed to run the Automation concurrently
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLocationMaxConcurrency(String targetLocationMaxConcurrency);

        /**
         * <p>
         * The maxium number of errors allowed before the system stops queueing additional Automation executions for the
         * currently running Automation.
         * </p>
         * 
         * @param targetLocationMaxErrors
         *        The maxium number of errors allowed before the system stops queueing additional Automation executions
         *        for the currently running Automation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLocationMaxErrors(String targetLocationMaxErrors);

        /**
         * <p>
         * The Automation execution role used by the currently running Automation.
         * </p>
         * 
         * @param executionRoleName
         *        The Automation execution role used by the currently running Automation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleName(String executionRoleName);
    }

    static final class BuilderImpl implements Builder {
        private List<String> accounts = DefaultSdkAutoConstructList.getInstance();

        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private String targetLocationMaxConcurrency;

        private String targetLocationMaxErrors;

        private String executionRoleName;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetLocation model) {
            accounts(model.accounts);
            regions(model.regions);
            targetLocationMaxConcurrency(model.targetLocationMaxConcurrency);
            targetLocationMaxErrors(model.targetLocationMaxErrors);
            executionRoleName(model.executionRoleName);
        }

        public final Collection<String> getAccounts() {
            return accounts;
        }

        @Override
        public final Builder accounts(Collection<String> accounts) {
            this.accounts = AccountsCopier.copy(accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(String... accounts) {
            accounts(Arrays.asList(accounts));
            return this;
        }

        public final void setAccounts(Collection<String> accounts) {
            this.accounts = AccountsCopier.copy(accounts);
        }

        public final Collection<String> getRegions() {
            return regions;
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionsCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String... regions) {
            regions(Arrays.asList(regions));
            return this;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionsCopier.copy(regions);
        }

        public final String getTargetLocationMaxConcurrency() {
            return targetLocationMaxConcurrency;
        }

        @Override
        public final Builder targetLocationMaxConcurrency(String targetLocationMaxConcurrency) {
            this.targetLocationMaxConcurrency = targetLocationMaxConcurrency;
            return this;
        }

        public final void setTargetLocationMaxConcurrency(String targetLocationMaxConcurrency) {
            this.targetLocationMaxConcurrency = targetLocationMaxConcurrency;
        }

        public final String getTargetLocationMaxErrors() {
            return targetLocationMaxErrors;
        }

        @Override
        public final Builder targetLocationMaxErrors(String targetLocationMaxErrors) {
            this.targetLocationMaxErrors = targetLocationMaxErrors;
            return this;
        }

        public final void setTargetLocationMaxErrors(String targetLocationMaxErrors) {
            this.targetLocationMaxErrors = targetLocationMaxErrors;
        }

        public final String getExecutionRoleName() {
            return executionRoleName;
        }

        @Override
        public final Builder executionRoleName(String executionRoleName) {
            this.executionRoleName = executionRoleName;
            return this;
        }

        public final void setExecutionRoleName(String executionRoleName) {
            this.executionRoleName = executionRoleName;
        }

        @Override
        public TargetLocation build() {
            return new TargetLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
