/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A specified parameter argument isn't valid. Verify the available arguments and try again.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpsItemInvalidParameterException extends SsmException implements
        ToCopyableBuilder<OpsItemInvalidParameterException.Builder, OpsItemInvalidParameterException> {
    private static final SdkField<List<String>> PARAMETER_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(OpsItemInvalidParameterException::parameterNames))
            .setter(setter(Builder::parameterNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_NAMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> parameterNames;

    private OpsItemInvalidParameterException(BuilderImpl builder) {
        super(builder);
        this.parameterNames = builder.parameterNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the ParameterNames property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the ParameterNames property for this object.
     */
    public List<String> parameterNames() {
        return parameterNames;
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpsItemInvalidParameterException, T> g) {
        return obj -> g.apply((OpsItemInvalidParameterException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpsItemInvalidParameterException>, SsmException.Builder {
        /**
         * Sets the value of the ParameterNames property for this object.
         *
         * @param parameterNames
         *        The new value for the ParameterNames property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterNames(Collection<String> parameterNames);

        /**
         * Sets the value of the ParameterNames property for this object.
         *
         * @param parameterNames
         *        The new value for the ParameterNames property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterNames(String... parameterNames);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends SsmException.BuilderImpl implements Builder {
        private List<String> parameterNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OpsItemInvalidParameterException model) {
            super(model);
            parameterNames(model.parameterNames);
        }

        public final Collection<String> getParameterNames() {
            return parameterNames;
        }

        @Override
        public final Builder parameterNames(Collection<String> parameterNames) {
            this.parameterNames = OpsItemParameterNamesListCopier.copy(parameterNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterNames(String... parameterNames) {
            parameterNames(Arrays.asList(parameterNames));
            return this;
        }

        public final void setParameterNames(Collection<String> parameterNames) {
            this.parameterNames = OpsItemParameterNamesListCopier.copy(parameterNames);
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public OpsItemInvalidParameterException build() {
            return new OpsItemInvalidParameterException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
