/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOpsItemResponse extends SsmResponse implements
        ToCopyableBuilder<GetOpsItemResponse.Builder, GetOpsItemResponse> {
    private static final SdkField<OpsItem> OPS_ITEM_FIELD = SdkField.<OpsItem> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetOpsItemResponse::opsItem)).setter(setter(Builder::opsItem)).constructor(OpsItem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItem").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPS_ITEM_FIELD));

    private final OpsItem opsItem;

    private GetOpsItemResponse(BuilderImpl builder) {
        super(builder);
        this.opsItem = builder.opsItem;
    }

    /**
     * <p>
     * The OpsItem.
     * </p>
     * 
     * @return The OpsItem.
     */
    public OpsItem opsItem() {
        return opsItem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(opsItem());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOpsItemResponse)) {
            return false;
        }
        GetOpsItemResponse other = (GetOpsItemResponse) obj;
        return Objects.equals(opsItem(), other.opsItem());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetOpsItemResponse").add("OpsItem", opsItem()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OpsItem":
            return Optional.ofNullable(clazz.cast(opsItem()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetOpsItemResponse, T> g) {
        return obj -> g.apply((GetOpsItemResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetOpsItemResponse> {
        /**
         * <p>
         * The OpsItem.
         * </p>
         * 
         * @param opsItem
         *        The OpsItem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opsItem(OpsItem opsItem);

        /**
         * <p>
         * The OpsItem.
         * </p>
         * This is a convenience that creates an instance of the {@link OpsItem.Builder} avoiding the need to create one
         * manually via {@link OpsItem#builder()}.
         *
         * When the {@link Consumer} completes, {@link OpsItem.Builder#build()} is called immediately and its result is
         * passed to {@link #opsItem(OpsItem)}.
         * 
         * @param opsItem
         *        a consumer that will call methods on {@link OpsItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #opsItem(OpsItem)
         */
        default Builder opsItem(Consumer<OpsItem.Builder> opsItem) {
            return opsItem(OpsItem.builder().applyMutation(opsItem).build());
        }
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private OpsItem opsItem;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOpsItemResponse model) {
            super(model);
            opsItem(model.opsItem);
        }

        public final OpsItem.Builder getOpsItem() {
            return opsItem != null ? opsItem.toBuilder() : null;
        }

        @Override
        public final Builder opsItem(OpsItem opsItem) {
            this.opsItem = opsItem;
            return this;
        }

        public final void setOpsItem(OpsItem.BuilderImpl opsItem) {
            this.opsItem = opsItem != null ? opsItem.build() : null;
        }

        @Override
        public GetOpsItemResponse build() {
            return new GetOpsItemResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
