/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMaintenanceWindowTasksResponse extends SsmResponse implements
        ToCopyableBuilder<DescribeMaintenanceWindowTasksResponse.Builder, DescribeMaintenanceWindowTasksResponse> {
    private static final SdkField<List<MaintenanceWindowTask>> TASKS_FIELD = SdkField
            .<List<MaintenanceWindowTask>> builder(MarshallingType.LIST)
            .getter(getter(DescribeMaintenanceWindowTasksResponse::tasks))
            .setter(setter(Builder::tasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tasks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MaintenanceWindowTask> builder(MarshallingType.SDK_POJO)
                                            .constructor(MaintenanceWindowTask::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeMaintenanceWindowTasksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(TASKS_FIELD, NEXT_TOKEN_FIELD));

    private final List<MaintenanceWindowTask> tasks;

    private final String nextToken;

    private DescribeMaintenanceWindowTasksResponse(BuilderImpl builder) {
        super(builder);
        this.tasks = builder.tasks;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the tasks in the maintenance window.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the tasks in the maintenance window.
     */
    public List<MaintenanceWindowTask> tasks() {
        return tasks;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tasks());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowTasksResponse)) {
            return false;
        }
        DescribeMaintenanceWindowTasksResponse other = (DescribeMaintenanceWindowTasksResponse) obj;
        return Objects.equals(tasks(), other.tasks()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeMaintenanceWindowTasksResponse").add("Tasks", tasks()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Tasks":
            return Optional.ofNullable(clazz.cast(tasks()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMaintenanceWindowTasksResponse, T> g) {
        return obj -> g.apply((DescribeMaintenanceWindowTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeMaintenanceWindowTasksResponse> {
        /**
         * <p>
         * Information about the tasks in the maintenance window.
         * </p>
         * 
         * @param tasks
         *        Information about the tasks in the maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tasks(Collection<MaintenanceWindowTask> tasks);

        /**
         * <p>
         * Information about the tasks in the maintenance window.
         * </p>
         * 
         * @param tasks
         *        Information about the tasks in the maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tasks(MaintenanceWindowTask... tasks);

        /**
         * <p>
         * Information about the tasks in the maintenance window.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MaintenanceWindowTask>.Builder} avoiding
         * the need to create one manually via {@link List<MaintenanceWindowTask>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MaintenanceWindowTask>.Builder#build()} is called
         * immediately and its result is passed to {@link #tasks(List<MaintenanceWindowTask>)}.
         * 
         * @param tasks
         *        a consumer that will call methods on {@link List<MaintenanceWindowTask>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tasks(List<MaintenanceWindowTask>)
         */
        Builder tasks(Consumer<MaintenanceWindowTask.Builder>... tasks);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<MaintenanceWindowTask> tasks = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowTasksResponse model) {
            super(model);
            tasks(model.tasks);
            nextToken(model.nextToken);
        }

        public final Collection<MaintenanceWindowTask.Builder> getTasks() {
            return tasks != null ? tasks.stream().map(MaintenanceWindowTask::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tasks(Collection<MaintenanceWindowTask> tasks) {
            this.tasks = MaintenanceWindowTaskListCopier.copy(tasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(MaintenanceWindowTask... tasks) {
            tasks(Arrays.asList(tasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Consumer<MaintenanceWindowTask.Builder>... tasks) {
            tasks(Stream.of(tasks).map(c -> MaintenanceWindowTask.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTasks(Collection<MaintenanceWindowTask.BuilderImpl> tasks) {
            this.tasks = MaintenanceWindowTaskListCopier.copyFromBuilder(tasks);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMaintenanceWindowTasksResponse build() {
            return new DescribeMaintenanceWindowTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
