/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOpsItemsRequest extends SsmRequest implements
        ToCopyableBuilder<DescribeOpsItemsRequest.Builder, DescribeOpsItemsRequest> {
    private static final SdkField<List<OpsItemFilter>> OPS_ITEM_FILTERS_FIELD = SdkField
            .<List<OpsItemFilter>> builder(MarshallingType.LIST)
            .getter(getter(DescribeOpsItemsRequest::opsItemFilters))
            .setter(setter(Builder::opsItemFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OpsItemFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(OpsItemFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeOpsItemsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeOpsItemsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPS_ITEM_FILTERS_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<OpsItemFilter> opsItemFilters;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeOpsItemsRequest(BuilderImpl builder) {
        super(builder);
        this.opsItemFilters = builder.opsItemFilters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * One or more filters to limit the reponse.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Key: CreatedTime
     * </p>
     * <p>
     * Operations: GreaterThan, LessThan
     * </p>
     * </li>
     * <li>
     * <p>
     * Key: LastModifiedBy
     * </p>
     * <p>
     * Operations: Contains, Equals
     * </p>
     * </li>
     * <li>
     * <p>
     * Key: LastModifiedTime
     * </p>
     * <p>
     * Operations: GreaterThan, LessThan
     * </p>
     * </li>
     * <li>
     * <p>
     * Key: Priority
     * </p>
     * <p>
     * Operations: Equals
     * </p>
     * </li>
     * <li>
     * <p>
     * Key: Source
     * </p>
     * <p>
     * Operations: Contains, Equals
     * </p>
     * </li>
     * <li>
     * <p>
     * Key: Status
     * </p>
     * <p>
     * Operations: Equals
     * </p>
     * </li>
     * <li>
     * <p>
     * Key: Title
     * </p>
     * <p>
     * Operations: Contains
     * </p>
     * </li>
     * <li>
     * <p>
     * Key: OperationalData
     * </p>
     * <p>
     * Operations: Equals
     * </p>
     * </li>
     * <li>
     * <p>
     * Key: OperationalDataKey
     * </p>
     * <p>
     * Operations: Equals
     * </p>
     * </li>
     * <li>
     * <p>
     * Key: OperationalDataValue
     * </p>
     * <p>
     * Operations: Equals, Contains
     * </p>
     * </li>
     * <li>
     * <p>
     * Key: OpsItemId
     * </p>
     * <p>
     * Operations: Equals
     * </p>
     * </li>
     * <li>
     * <p>
     * Key: ResourceId
     * </p>
     * <p>
     * Operations: Contains
     * </p>
     * </li>
     * <li>
     * <p>
     * Key: AutomationId
     * </p>
     * <p>
     * Operations: Equals
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters to limit the reponse.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Key: CreatedTime
     *         </p>
     *         <p>
     *         Operations: GreaterThan, LessThan
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key: LastModifiedBy
     *         </p>
     *         <p>
     *         Operations: Contains, Equals
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key: LastModifiedTime
     *         </p>
     *         <p>
     *         Operations: GreaterThan, LessThan
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key: Priority
     *         </p>
     *         <p>
     *         Operations: Equals
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key: Source
     *         </p>
     *         <p>
     *         Operations: Contains, Equals
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key: Status
     *         </p>
     *         <p>
     *         Operations: Equals
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key: Title
     *         </p>
     *         <p>
     *         Operations: Contains
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key: OperationalData
     *         </p>
     *         <p>
     *         Operations: Equals
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key: OperationalDataKey
     *         </p>
     *         <p>
     *         Operations: Equals
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key: OperationalDataValue
     *         </p>
     *         <p>
     *         Operations: Equals, Contains
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key: OpsItemId
     *         </p>
     *         <p>
     *         Operations: Equals
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key: ResourceId
     *         </p>
     *         <p>
     *         Operations: Contains
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key: AutomationId
     *         </p>
     *         <p>
     *         Operations: Equals
     *         </p>
     *         </li>
     */
    public List<OpsItemFilter> opsItemFilters() {
        return opsItemFilters;
    }

    /**
     * <p>
     * The maximum number of items to return for this call. The call also returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * 
     * @return The maximum number of items to return for this call. The call also returns a token that you can specify
     *         in a subsequent call to get the next set of results.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token to start the list. Use this token to get the next set of results.
     * </p>
     * 
     * @return A token to start the list. Use this token to get the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(opsItemFilters());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOpsItemsRequest)) {
            return false;
        }
        DescribeOpsItemsRequest other = (DescribeOpsItemsRequest) obj;
        return Objects.equals(opsItemFilters(), other.opsItemFilters()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeOpsItemsRequest").add("OpsItemFilters", opsItemFilters())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OpsItemFilters":
            return Optional.ofNullable(clazz.cast(opsItemFilters()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOpsItemsRequest, T> g) {
        return obj -> g.apply((DescribeOpsItemsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeOpsItemsRequest> {
        /**
         * <p>
         * One or more filters to limit the reponse.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Key: CreatedTime
         * </p>
         * <p>
         * Operations: GreaterThan, LessThan
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: LastModifiedBy
         * </p>
         * <p>
         * Operations: Contains, Equals
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: LastModifiedTime
         * </p>
         * <p>
         * Operations: GreaterThan, LessThan
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: Priority
         * </p>
         * <p>
         * Operations: Equals
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: Source
         * </p>
         * <p>
         * Operations: Contains, Equals
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: Status
         * </p>
         * <p>
         * Operations: Equals
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: Title
         * </p>
         * <p>
         * Operations: Contains
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: OperationalData
         * </p>
         * <p>
         * Operations: Equals
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: OperationalDataKey
         * </p>
         * <p>
         * Operations: Equals
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: OperationalDataValue
         * </p>
         * <p>
         * Operations: Equals, Contains
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: OpsItemId
         * </p>
         * <p>
         * Operations: Equals
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: ResourceId
         * </p>
         * <p>
         * Operations: Contains
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: AutomationId
         * </p>
         * <p>
         * Operations: Equals
         * </p>
         * </li>
         * </ul>
         * 
         * @param opsItemFilters
         *        One or more filters to limit the reponse.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Key: CreatedTime
         *        </p>
         *        <p>
         *        Operations: GreaterThan, LessThan
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key: LastModifiedBy
         *        </p>
         *        <p>
         *        Operations: Contains, Equals
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key: LastModifiedTime
         *        </p>
         *        <p>
         *        Operations: GreaterThan, LessThan
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key: Priority
         *        </p>
         *        <p>
         *        Operations: Equals
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key: Source
         *        </p>
         *        <p>
         *        Operations: Contains, Equals
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key: Status
         *        </p>
         *        <p>
         *        Operations: Equals
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key: Title
         *        </p>
         *        <p>
         *        Operations: Contains
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key: OperationalData
         *        </p>
         *        <p>
         *        Operations: Equals
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key: OperationalDataKey
         *        </p>
         *        <p>
         *        Operations: Equals
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key: OperationalDataValue
         *        </p>
         *        <p>
         *        Operations: Equals, Contains
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key: OpsItemId
         *        </p>
         *        <p>
         *        Operations: Equals
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key: ResourceId
         *        </p>
         *        <p>
         *        Operations: Contains
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key: AutomationId
         *        </p>
         *        <p>
         *        Operations: Equals
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opsItemFilters(Collection<OpsItemFilter> opsItemFilters);

        /**
         * <p>
         * One or more filters to limit the reponse.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Key: CreatedTime
         * </p>
         * <p>
         * Operations: GreaterThan, LessThan
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: LastModifiedBy
         * </p>
         * <p>
         * Operations: Contains, Equals
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: LastModifiedTime
         * </p>
         * <p>
         * Operations: GreaterThan, LessThan
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: Priority
         * </p>
         * <p>
         * Operations: Equals
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: Source
         * </p>
         * <p>
         * Operations: Contains, Equals
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: Status
         * </p>
         * <p>
         * Operations: Equals
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: Title
         * </p>
         * <p>
         * Operations: Contains
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: OperationalData
         * </p>
         * <p>
         * Operations: Equals
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: OperationalDataKey
         * </p>
         * <p>
         * Operations: Equals
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: OperationalDataValue
         * </p>
         * <p>
         * Operations: Equals, Contains
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: OpsItemId
         * </p>
         * <p>
         * Operations: Equals
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: ResourceId
         * </p>
         * <p>
         * Operations: Contains
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: AutomationId
         * </p>
         * <p>
         * Operations: Equals
         * </p>
         * </li>
         * </ul>
         * 
         * @param opsItemFilters
         *        One or more filters to limit the reponse.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Key: CreatedTime
         *        </p>
         *        <p>
         *        Operations: GreaterThan, LessThan
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key: LastModifiedBy
         *        </p>
         *        <p>
         *        Operations: Contains, Equals
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key: LastModifiedTime
         *        </p>
         *        <p>
         *        Operations: GreaterThan, LessThan
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key: Priority
         *        </p>
         *        <p>
         *        Operations: Equals
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key: Source
         *        </p>
         *        <p>
         *        Operations: Contains, Equals
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key: Status
         *        </p>
         *        <p>
         *        Operations: Equals
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key: Title
         *        </p>
         *        <p>
         *        Operations: Contains
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key: OperationalData
         *        </p>
         *        <p>
         *        Operations: Equals
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key: OperationalDataKey
         *        </p>
         *        <p>
         *        Operations: Equals
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key: OperationalDataValue
         *        </p>
         *        <p>
         *        Operations: Equals, Contains
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key: OpsItemId
         *        </p>
         *        <p>
         *        Operations: Equals
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key: ResourceId
         *        </p>
         *        <p>
         *        Operations: Contains
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key: AutomationId
         *        </p>
         *        <p>
         *        Operations: Equals
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opsItemFilters(OpsItemFilter... opsItemFilters);

        /**
         * <p>
         * One or more filters to limit the reponse.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Key: CreatedTime
         * </p>
         * <p>
         * Operations: GreaterThan, LessThan
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: LastModifiedBy
         * </p>
         * <p>
         * Operations: Contains, Equals
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: LastModifiedTime
         * </p>
         * <p>
         * Operations: GreaterThan, LessThan
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: Priority
         * </p>
         * <p>
         * Operations: Equals
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: Source
         * </p>
         * <p>
         * Operations: Contains, Equals
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: Status
         * </p>
         * <p>
         * Operations: Equals
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: Title
         * </p>
         * <p>
         * Operations: Contains
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: OperationalData
         * </p>
         * <p>
         * Operations: Equals
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: OperationalDataKey
         * </p>
         * <p>
         * Operations: Equals
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: OperationalDataValue
         * </p>
         * <p>
         * Operations: Equals, Contains
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: OpsItemId
         * </p>
         * <p>
         * Operations: Equals
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: ResourceId
         * </p>
         * <p>
         * Operations: Contains
         * </p>
         * </li>
         * <li>
         * <p>
         * Key: AutomationId
         * </p>
         * <p>
         * Operations: Equals
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<OpsItemFilter>.Builder} avoiding the need
         * to create one manually via {@link List<OpsItemFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OpsItemFilter>.Builder#build()} is called immediately and
         * its result is passed to {@link #opsItemFilters(List<OpsItemFilter>)}.
         * 
         * @param opsItemFilters
         *        a consumer that will call methods on {@link List<OpsItemFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #opsItemFilters(List<OpsItemFilter>)
         */
        Builder opsItemFilters(Consumer<OpsItemFilter.Builder>... opsItemFilters);

        /**
         * <p>
         * The maximum number of items to return for this call. The call also returns a token that you can specify in a
         * subsequent call to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this call. The call also returns a token that you can
         *        specify in a subsequent call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token to start the list. Use this token to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A token to start the list. Use this token to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private List<OpsItemFilter> opsItemFilters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOpsItemsRequest model) {
            super(model);
            opsItemFilters(model.opsItemFilters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<OpsItemFilter.Builder> getOpsItemFilters() {
            return opsItemFilters != null ? opsItemFilters.stream().map(OpsItemFilter::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder opsItemFilters(Collection<OpsItemFilter> opsItemFilters) {
            this.opsItemFilters = OpsItemFiltersCopier.copy(opsItemFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opsItemFilters(OpsItemFilter... opsItemFilters) {
            opsItemFilters(Arrays.asList(opsItemFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opsItemFilters(Consumer<OpsItemFilter.Builder>... opsItemFilters) {
            opsItemFilters(Stream.of(opsItemFilters).map(c -> OpsItemFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOpsItemFilters(Collection<OpsItemFilter.BuilderImpl> opsItemFilters) {
            this.opsItemFilters = OpsItemFiltersCopier.copyFromBuilder(opsItemFilters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeOpsItemsRequest build() {
            return new DescribeOpsItemsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
