/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.ParameterHistory;
import software.amazon.awssdk.services.ssm.model.ParameterHistoryListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetParameterHistoryResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, GetParameterHistoryResponse> {
    private static final SdkField<List<ParameterHistory>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetParameterHistoryResponse.getter(GetParameterHistoryResponse::parameters)).setter(GetParameterHistoryResponse.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParameterHistory::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetParameterHistoryResponse.getter(GetParameterHistoryResponse::nextToken)).setter(GetParameterHistoryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ParameterHistory> parameters;
    private final String nextToken;

    private GetParameterHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.parameters = builder.parameters;
        this.nextToken = builder.nextToken;
    }

    public List<ParameterHistory> parameters() {
        return this.parameters;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParameterHistoryResponse)) {
            return false;
        }
        GetParameterHistoryResponse other = (GetParameterHistoryResponse)((Object)obj);
        return Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetParameterHistoryResponse").add("Parameters", this.parameters()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetParameterHistoryResponse, T> g) {
        return obj -> g.apply((GetParameterHistoryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<ParameterHistory> parameters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParameterHistoryResponse model) {
            super(model);
            this.parameters(model.parameters);
            this.nextToken(model.nextToken);
        }

        public final Collection<ParameterHistory.Builder> getParameters() {
            return this.parameters != null ? (Collection)this.parameters.stream().map(ParameterHistory::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<ParameterHistory> parameters) {
            this.parameters = ParameterHistoryListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(ParameterHistory ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<ParameterHistory.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (ParameterHistory)((ParameterHistory.Builder)ParameterHistory.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameters(Collection<ParameterHistory.BuilderImpl> parameters) {
            this.parameters = ParameterHistoryListCopier.copyFromBuilder(parameters);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetParameterHistoryResponse build() {
            return new GetParameterHistoryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetParameterHistoryResponse> {
        public Builder parameters(Collection<ParameterHistory> var1);

        public Builder parameters(ParameterHistory ... var1);

        public Builder parameters(Consumer<ParameterHistory.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

