/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The query result body of the GetServiceSetting API action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServiceSettingResponse extends SsmResponse implements
        ToCopyableBuilder<GetServiceSettingResponse.Builder, GetServiceSettingResponse> {
    private static final SdkField<ServiceSetting> SERVICE_SETTING_FIELD = SdkField
            .<ServiceSetting> builder(MarshallingType.SDK_POJO).getter(getter(GetServiceSettingResponse::serviceSetting))
            .setter(setter(Builder::serviceSetting)).constructor(ServiceSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSetting").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_SETTING_FIELD));

    private final ServiceSetting serviceSetting;

    private GetServiceSettingResponse(BuilderImpl builder) {
        super(builder);
        this.serviceSetting = builder.serviceSetting;
    }

    /**
     * <p>
     * The query result of the current service setting.
     * </p>
     * 
     * @return The query result of the current service setting.
     */
    public ServiceSetting serviceSetting() {
        return serviceSetting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceSetting());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceSettingResponse)) {
            return false;
        }
        GetServiceSettingResponse other = (GetServiceSettingResponse) obj;
        return Objects.equals(serviceSetting(), other.serviceSetting());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetServiceSettingResponse").add("ServiceSetting", serviceSetting()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceSetting":
            return Optional.ofNullable(clazz.cast(serviceSetting()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetServiceSettingResponse, T> g) {
        return obj -> g.apply((GetServiceSettingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetServiceSettingResponse> {
        /**
         * <p>
         * The query result of the current service setting.
         * </p>
         * 
         * @param serviceSetting
         *        The query result of the current service setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceSetting(ServiceSetting serviceSetting);

        /**
         * <p>
         * The query result of the current service setting.
         * </p>
         * This is a convenience that creates an instance of the {@link ServiceSetting.Builder} avoiding the need to
         * create one manually via {@link ServiceSetting#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServiceSetting.Builder#build()} is called immediately and its
         * result is passed to {@link #serviceSetting(ServiceSetting)}.
         * 
         * @param serviceSetting
         *        a consumer that will call methods on {@link ServiceSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceSetting(ServiceSetting)
         */
        default Builder serviceSetting(Consumer<ServiceSetting.Builder> serviceSetting) {
            return serviceSetting(ServiceSetting.builder().applyMutation(serviceSetting).build());
        }
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private ServiceSetting serviceSetting;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceSettingResponse model) {
            super(model);
            serviceSetting(model.serviceSetting);
        }

        public final ServiceSetting.Builder getServiceSetting() {
            return serviceSetting != null ? serviceSetting.toBuilder() : null;
        }

        @Override
        public final Builder serviceSetting(ServiceSetting serviceSetting) {
            this.serviceSetting = serviceSetting;
            return this;
        }

        public final void setServiceSetting(ServiceSetting.BuilderImpl serviceSetting) {
            this.serviceSetting = serviceSetting != null ? serviceSetting.build() : null;
        }

        @Override
        public GetServiceSettingResponse build() {
            return new GetServiceSettingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
