/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for an AUTOMATION task type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MaintenanceWindowAutomationParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<MaintenanceWindowAutomationParameters.Builder, MaintenanceWindowAutomationParameters> {
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MaintenanceWindowAutomationParameters::documentVersion)).setter(setter(Builder::documentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()).build();

    private static final SdkField<Map<String, List<String>>> PARAMETERS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .getter(getter(MaintenanceWindowAutomationParameters::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_VERSION_FIELD,
            PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String documentVersion;

    private final Map<String, List<String>> parameters;

    private MaintenanceWindowAutomationParameters(BuilderImpl builder) {
        this.documentVersion = builder.documentVersion;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The version of an Automation document to use during task execution.
     * </p>
     * 
     * @return The version of an Automation document to use during task execution.
     */
    public String documentVersion() {
        return documentVersion;
    }

    /**
     * <p>
     * The parameters for the AUTOMATION task.
     * </p>
     * <p>
     * For information about specifying and updating task parameters, see <a>RegisterTaskWithMaintenanceWindow</a> and
     * <a>UpdateMaintenanceWindowTask</a>.
     * </p>
     * <note>
     * <p>
     * <code>LoggingInfo</code> has been deprecated. To specify an S3 bucket to contain logs, instead use the
     * <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the
     * <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options
     * for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.
     * </p>
     * <p>
     * <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead
     * use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information
     * about how Systems Manager handles these options for the supported maintenance window task types, see
     * <a>MaintenanceWindowTaskInvocationParameters</a>.
     * </p>
     * <p>
     * For AUTOMATION task types, Systems Manager ignores any values specified for these parameters.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The parameters for the AUTOMATION task.</p>
     *         <p>
     *         For information about specifying and updating task parameters, see
     *         <a>RegisterTaskWithMaintenanceWindow</a> and <a>UpdateMaintenanceWindowTask</a>.
     *         </p>
     *         <note>
     *         <p>
     *         <code>LoggingInfo</code> has been deprecated. To specify an S3 bucket to contain logs, instead use the
     *         <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the
     *         <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these
     *         options for the supported maintenance window task types, see
     *         <a>MaintenanceWindowTaskInvocationParameters</a>.
     *         </p>
     *         <p>
     *         <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs,
     *         instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure.
     *         For information about how Systems Manager handles these options for the supported maintenance window task
     *         types, see <a>MaintenanceWindowTaskInvocationParameters</a>.
     *         </p>
     *         <p>
     *         For AUTOMATION task types, Systems Manager ignores any values specified for these parameters.
     *         </p>
     */
    public Map<String, List<String>> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowAutomationParameters)) {
            return false;
        }
        MaintenanceWindowAutomationParameters other = (MaintenanceWindowAutomationParameters) obj;
        return Objects.equals(documentVersion(), other.documentVersion()) && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MaintenanceWindowAutomationParameters").add("DocumentVersion", documentVersion())
                .add("Parameters", parameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentVersion":
            return Optional.ofNullable(clazz.cast(documentVersion()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceWindowAutomationParameters, T> g) {
        return obj -> g.apply((MaintenanceWindowAutomationParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MaintenanceWindowAutomationParameters> {
        /**
         * <p>
         * The version of an Automation document to use during task execution.
         * </p>
         * 
         * @param documentVersion
         *        The version of an Automation document to use during task execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);

        /**
         * <p>
         * The parameters for the AUTOMATION task.
         * </p>
         * <p>
         * For information about specifying and updating task parameters, see <a>RegisterTaskWithMaintenanceWindow</a>
         * and <a>UpdateMaintenanceWindowTask</a>.
         * </p>
         * <note>
         * <p>
         * <code>LoggingInfo</code> has been deprecated. To specify an S3 bucket to contain logs, instead use the
         * <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the
         * <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these
         * options for the supported maintenance window task types, see
         * <a>MaintenanceWindowTaskInvocationParameters</a>.
         * </p>
         * <p>
         * <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs,
         * instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For
         * information about how Systems Manager handles these options for the supported maintenance window task types,
         * see <a>MaintenanceWindowTaskInvocationParameters</a>.
         * </p>
         * <p>
         * For AUTOMATION task types, Systems Manager ignores any values specified for these parameters.
         * </p>
         * </note>
         * 
         * @param parameters
         *        The parameters for the AUTOMATION task.</p>
         *        <p>
         *        For information about specifying and updating task parameters, see
         *        <a>RegisterTaskWithMaintenanceWindow</a> and <a>UpdateMaintenanceWindowTask</a>.
         *        </p>
         *        <note>
         *        <p>
         *        <code>LoggingInfo</code> has been deprecated. To specify an S3 bucket to contain logs, instead use the
         *        <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the
         *        <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles
         *        these options for the supported maintenance window task types, see
         *        <a>MaintenanceWindowTaskInvocationParameters</a>.
         *        </p>
         *        <p>
         *        <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs,
         *        instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure.
         *        For information about how Systems Manager handles these options for the supported maintenance window
         *        task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.
         *        </p>
         *        <p>
         *        For AUTOMATION task types, Systems Manager ignores any values specified for these parameters.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, ? extends Collection<String>> parameters);
    }

    static final class BuilderImpl implements Builder {
        private String documentVersion;

        private Map<String, List<String>> parameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowAutomationParameters model) {
            documentVersion(model.documentVersion);
            parameters(model.parameters);
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
        }

        @Override
        public MaintenanceWindowAutomationParameters build() {
            return new MaintenanceWindowAutomationParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
