/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstanceAssociationsStatusResponse extends SsmResponse implements
        ToCopyableBuilder<DescribeInstanceAssociationsStatusResponse.Builder, DescribeInstanceAssociationsStatusResponse> {
    private static final SdkField<List<InstanceAssociationStatusInfo>> INSTANCE_ASSOCIATION_STATUS_INFOS_FIELD = SdkField
            .<List<InstanceAssociationStatusInfo>> builder(MarshallingType.LIST)
            .getter(getter(DescribeInstanceAssociationsStatusResponse::instanceAssociationStatusInfos))
            .setter(setter(Builder::instanceAssociationStatusInfos))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceAssociationStatusInfos")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceAssociationStatusInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceAssociationStatusInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeInstanceAssociationsStatusResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INSTANCE_ASSOCIATION_STATUS_INFOS_FIELD, NEXT_TOKEN_FIELD));

    private final List<InstanceAssociationStatusInfo> instanceAssociationStatusInfos;

    private final String nextToken;

    private DescribeInstanceAssociationsStatusResponse(BuilderImpl builder) {
        super(builder);
        this.instanceAssociationStatusInfos = builder.instanceAssociationStatusInfos;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Status information about the association.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Status information about the association.
     */
    public List<InstanceAssociationStatusInfo> instanceAssociationStatusInfos() {
        return instanceAssociationStatusInfos;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceAssociationStatusInfos());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceAssociationsStatusResponse)) {
            return false;
        }
        DescribeInstanceAssociationsStatusResponse other = (DescribeInstanceAssociationsStatusResponse) obj;
        return Objects.equals(instanceAssociationStatusInfos(), other.instanceAssociationStatusInfos())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeInstanceAssociationsStatusResponse")
                .add("InstanceAssociationStatusInfos", instanceAssociationStatusInfos()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceAssociationStatusInfos":
            return Optional.ofNullable(clazz.cast(instanceAssociationStatusInfos()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceAssociationsStatusResponse, T> g) {
        return obj -> g.apply((DescribeInstanceAssociationsStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeInstanceAssociationsStatusResponse> {
        /**
         * <p>
         * Status information about the association.
         * </p>
         * 
         * @param instanceAssociationStatusInfos
         *        Status information about the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceAssociationStatusInfos(Collection<InstanceAssociationStatusInfo> instanceAssociationStatusInfos);

        /**
         * <p>
         * Status information about the association.
         * </p>
         * 
         * @param instanceAssociationStatusInfos
         *        Status information about the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceAssociationStatusInfos(InstanceAssociationStatusInfo... instanceAssociationStatusInfos);

        /**
         * <p>
         * Status information about the association.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceAssociationStatusInfo>.Builder}
         * avoiding the need to create one manually via {@link List<InstanceAssociationStatusInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceAssociationStatusInfo>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #instanceAssociationStatusInfos(List<InstanceAssociationStatusInfo>)}.
         * 
         * @param instanceAssociationStatusInfos
         *        a consumer that will call methods on {@link List<InstanceAssociationStatusInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceAssociationStatusInfos(List<InstanceAssociationStatusInfo>)
         */
        Builder instanceAssociationStatusInfos(Consumer<InstanceAssociationStatusInfo.Builder>... instanceAssociationStatusInfos);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<InstanceAssociationStatusInfo> instanceAssociationStatusInfos = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceAssociationsStatusResponse model) {
            super(model);
            instanceAssociationStatusInfos(model.instanceAssociationStatusInfos);
            nextToken(model.nextToken);
        }

        public final Collection<InstanceAssociationStatusInfo.Builder> getInstanceAssociationStatusInfos() {
            return instanceAssociationStatusInfos != null ? instanceAssociationStatusInfos.stream()
                    .map(InstanceAssociationStatusInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceAssociationStatusInfos(
                Collection<InstanceAssociationStatusInfo> instanceAssociationStatusInfos) {
            this.instanceAssociationStatusInfos = InstanceAssociationStatusInfosCopier.copy(instanceAssociationStatusInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceAssociationStatusInfos(InstanceAssociationStatusInfo... instanceAssociationStatusInfos) {
            instanceAssociationStatusInfos(Arrays.asList(instanceAssociationStatusInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceAssociationStatusInfos(
                Consumer<InstanceAssociationStatusInfo.Builder>... instanceAssociationStatusInfos) {
            instanceAssociationStatusInfos(Stream.of(instanceAssociationStatusInfos)
                    .map(c -> InstanceAssociationStatusInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceAssociationStatusInfos(
                Collection<InstanceAssociationStatusInfo.BuilderImpl> instanceAssociationStatusInfos) {
            this.instanceAssociationStatusInfos = InstanceAssociationStatusInfosCopier
                    .copyFromBuilder(instanceAssociationStatusInfos);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInstanceAssociationsStatusResponse build() {
            return new DescribeInstanceAssociationsStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
