/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the call execution that includes an execution ID, the type of execution (for example,
 * <code>Command</code>), and the date/time of the execution using a datetime object that is saved in the following
 * format: yyyy-MM-dd'T'HH:mm:ss'Z'.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComplianceExecutionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ComplianceExecutionSummary.Builder, ComplianceExecutionSummary> {
    private static final SdkField<Instant> EXECUTION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ComplianceExecutionSummary::executionTime)).setter(setter(Builder::executionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTime").build()).build();

    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ComplianceExecutionSummary::executionId)).setter(setter(Builder::executionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionId").build()).build();

    private static final SdkField<String> EXECUTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ComplianceExecutionSummary::executionType)).setter(setter(Builder::executionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_TIME_FIELD,
            EXECUTION_ID_FIELD, EXECUTION_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant executionTime;

    private final String executionId;

    private final String executionType;

    private ComplianceExecutionSummary(BuilderImpl builder) {
        this.executionTime = builder.executionTime;
        this.executionId = builder.executionId;
        this.executionType = builder.executionType;
    }

    /**
     * <p>
     * The time the execution ran as a datetime object that is saved in the following format: yyyy-MM-dd'T'HH:mm:ss'Z'.
     * </p>
     * 
     * @return The time the execution ran as a datetime object that is saved in the following format:
     *         yyyy-MM-dd'T'HH:mm:ss'Z'.
     */
    public Instant executionTime() {
        return executionTime;
    }

    /**
     * <p>
     * An ID created by the system when <code>PutComplianceItems</code> was called. For example, <code>CommandID</code>
     * is a valid execution ID. You can use this ID in subsequent calls.
     * </p>
     * 
     * @return An ID created by the system when <code>PutComplianceItems</code> was called. For example,
     *         <code>CommandID</code> is a valid execution ID. You can use this ID in subsequent calls.
     */
    public String executionId() {
        return executionId;
    }

    /**
     * <p>
     * The type of execution. For example, <code>Command</code> is a valid execution type.
     * </p>
     * 
     * @return The type of execution. For example, <code>Command</code> is a valid execution type.
     */
    public String executionType() {
        return executionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executionTime());
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        hashCode = 31 * hashCode + Objects.hashCode(executionType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceExecutionSummary)) {
            return false;
        }
        ComplianceExecutionSummary other = (ComplianceExecutionSummary) obj;
        return Objects.equals(executionTime(), other.executionTime()) && Objects.equals(executionId(), other.executionId())
                && Objects.equals(executionType(), other.executionType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ComplianceExecutionSummary").add("ExecutionTime", executionTime())
                .add("ExecutionId", executionId()).add("ExecutionType", executionType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExecutionTime":
            return Optional.ofNullable(clazz.cast(executionTime()));
        case "ExecutionId":
            return Optional.ofNullable(clazz.cast(executionId()));
        case "ExecutionType":
            return Optional.ofNullable(clazz.cast(executionType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComplianceExecutionSummary, T> g) {
        return obj -> g.apply((ComplianceExecutionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComplianceExecutionSummary> {
        /**
         * <p>
         * The time the execution ran as a datetime object that is saved in the following format:
         * yyyy-MM-dd'T'HH:mm:ss'Z'.
         * </p>
         * 
         * @param executionTime
         *        The time the execution ran as a datetime object that is saved in the following format:
         *        yyyy-MM-dd'T'HH:mm:ss'Z'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionTime(Instant executionTime);

        /**
         * <p>
         * An ID created by the system when <code>PutComplianceItems</code> was called. For example,
         * <code>CommandID</code> is a valid execution ID. You can use this ID in subsequent calls.
         * </p>
         * 
         * @param executionId
         *        An ID created by the system when <code>PutComplianceItems</code> was called. For example,
         *        <code>CommandID</code> is a valid execution ID. You can use this ID in subsequent calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        /**
         * <p>
         * The type of execution. For example, <code>Command</code> is a valid execution type.
         * </p>
         * 
         * @param executionType
         *        The type of execution. For example, <code>Command</code> is a valid execution type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionType(String executionType);
    }

    static final class BuilderImpl implements Builder {
        private Instant executionTime;

        private String executionId;

        private String executionType;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceExecutionSummary model) {
            executionTime(model.executionTime);
            executionId(model.executionId);
            executionType(model.executionType);
        }

        public final Instant getExecutionTime() {
            return executionTime;
        }

        @Override
        public final Builder executionTime(Instant executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        public final void setExecutionTime(Instant executionTime) {
            this.executionTime = executionTime;
        }

        public final String getExecutionId() {
            return executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        public final String getExecutionType() {
            return executionType;
        }

        @Override
        public final Builder executionType(String executionType) {
            this.executionType = executionType;
            return this;
        }

        public final void setExecutionType(String executionType) {
            this.executionType = executionType;
        }

        @Override
        public ComplianceExecutionSummary build() {
            return new ComplianceExecutionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
