/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOpsItemsResponse extends SsmResponse implements
        ToCopyableBuilder<DescribeOpsItemsResponse.Builder, DescribeOpsItemsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeOpsItemsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<OpsItemSummary>> OPS_ITEM_SUMMARIES_FIELD = SdkField
            .<List<OpsItemSummary>> builder(MarshallingType.LIST)
            .getter(getter(DescribeOpsItemsResponse::opsItemSummaries))
            .setter(setter(Builder::opsItemSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OpsItemSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(OpsItemSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            OPS_ITEM_SUMMARIES_FIELD));

    private final String nextToken;

    private final List<OpsItemSummary> opsItemSummaries;

    private DescribeOpsItemsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.opsItemSummaries = builder.opsItemSummaries;
    }

    /**
     * <p>
     * The token for the next set of items to return. Use this token to get the next set of results.
     * </p>
     * 
     * @return The token for the next set of items to return. Use this token to get the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A list of OpsItems.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of OpsItems.
     */
    public List<OpsItemSummary> opsItemSummaries() {
        return opsItemSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(opsItemSummaries());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOpsItemsResponse)) {
            return false;
        }
        DescribeOpsItemsResponse other = (DescribeOpsItemsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(opsItemSummaries(), other.opsItemSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeOpsItemsResponse").add("NextToken", nextToken())
                .add("OpsItemSummaries", opsItemSummaries()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "OpsItemSummaries":
            return Optional.ofNullable(clazz.cast(opsItemSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOpsItemsResponse, T> g) {
        return obj -> g.apply((DescribeOpsItemsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeOpsItemsResponse> {
        /**
         * <p>
         * The token for the next set of items to return. Use this token to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. Use this token to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of OpsItems.
         * </p>
         * 
         * @param opsItemSummaries
         *        A list of OpsItems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opsItemSummaries(Collection<OpsItemSummary> opsItemSummaries);

        /**
         * <p>
         * A list of OpsItems.
         * </p>
         * 
         * @param opsItemSummaries
         *        A list of OpsItems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opsItemSummaries(OpsItemSummary... opsItemSummaries);

        /**
         * <p>
         * A list of OpsItems.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OpsItemSummary>.Builder} avoiding the need
         * to create one manually via {@link List<OpsItemSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OpsItemSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #opsItemSummaries(List<OpsItemSummary>)}.
         * 
         * @param opsItemSummaries
         *        a consumer that will call methods on {@link List<OpsItemSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #opsItemSummaries(List<OpsItemSummary>)
         */
        Builder opsItemSummaries(Consumer<OpsItemSummary.Builder>... opsItemSummaries);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<OpsItemSummary> opsItemSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOpsItemsResponse model) {
            super(model);
            nextToken(model.nextToken);
            opsItemSummaries(model.opsItemSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<OpsItemSummary.Builder> getOpsItemSummaries() {
            return opsItemSummaries != null ? opsItemSummaries.stream().map(OpsItemSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder opsItemSummaries(Collection<OpsItemSummary> opsItemSummaries) {
            this.opsItemSummaries = OpsItemSummariesCopier.copy(opsItemSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opsItemSummaries(OpsItemSummary... opsItemSummaries) {
            opsItemSummaries(Arrays.asList(opsItemSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opsItemSummaries(Consumer<OpsItemSummary.Builder>... opsItemSummaries) {
            opsItemSummaries(Stream.of(opsItemSummaries).map(c -> OpsItemSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOpsItemSummaries(Collection<OpsItemSummary.BuilderImpl> opsItemSummaries) {
            this.opsItemSummaries = OpsItemSummariesCopier.copyFromBuilder(opsItemSummaries);
        }

        @Override
        public DescribeOpsItemsResponse build() {
            return new DescribeOpsItemsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
