/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * One or more policies assigned to a parameter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParameterInlinePolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<ParameterInlinePolicy.Builder, ParameterInlinePolicy> {
    private static final SdkField<String> POLICY_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ParameterInlinePolicy::policyText)).setter(setter(Builder::policyText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyText").build()).build();

    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ParameterInlinePolicy::policyType)).setter(setter(Builder::policyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()).build();

    private static final SdkField<String> POLICY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ParameterInlinePolicy::policyStatus)).setter(setter(Builder::policyStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_TEXT_FIELD,
            POLICY_TYPE_FIELD, POLICY_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String policyText;

    private final String policyType;

    private final String policyStatus;

    private ParameterInlinePolicy(BuilderImpl builder) {
        this.policyText = builder.policyText;
        this.policyType = builder.policyType;
        this.policyStatus = builder.policyStatus;
    }

    /**
     * <p>
     * The JSON text of the policy.
     * </p>
     * 
     * @return The JSON text of the policy.
     */
    public String policyText() {
        return policyText;
    }

    /**
     * <p>
     * The type of policy. Parameter Store supports the following policy types: Expiration, ExpirationNotification, and
     * NoChangeNotification.
     * </p>
     * 
     * @return The type of policy. Parameter Store supports the following policy types: Expiration,
     *         ExpirationNotification, and NoChangeNotification.
     */
    public String policyType() {
        return policyType;
    }

    /**
     * <p>
     * The status of the policy. Policies report the following statuses: Pending (the policy has not been enforced or
     * applied yet), Finished (the policy was applied), Failed (the policy was not applied), or InProgress (the policy
     * is being applied now).
     * </p>
     * 
     * @return The status of the policy. Policies report the following statuses: Pending (the policy has not been
     *         enforced or applied yet), Finished (the policy was applied), Failed (the policy was not applied), or
     *         InProgress (the policy is being applied now).
     */
    public String policyStatus() {
        return policyStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyText());
        hashCode = 31 * hashCode + Objects.hashCode(policyType());
        hashCode = 31 * hashCode + Objects.hashCode(policyStatus());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterInlinePolicy)) {
            return false;
        }
        ParameterInlinePolicy other = (ParameterInlinePolicy) obj;
        return Objects.equals(policyText(), other.policyText()) && Objects.equals(policyType(), other.policyType())
                && Objects.equals(policyStatus(), other.policyStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ParameterInlinePolicy").add("PolicyText", policyText()).add("PolicyType", policyType())
                .add("PolicyStatus", policyStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyText":
            return Optional.ofNullable(clazz.cast(policyText()));
        case "PolicyType":
            return Optional.ofNullable(clazz.cast(policyType()));
        case "PolicyStatus":
            return Optional.ofNullable(clazz.cast(policyStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParameterInlinePolicy, T> g) {
        return obj -> g.apply((ParameterInlinePolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParameterInlinePolicy> {
        /**
         * <p>
         * The JSON text of the policy.
         * </p>
         * 
         * @param policyText
         *        The JSON text of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyText(String policyText);

        /**
         * <p>
         * The type of policy. Parameter Store supports the following policy types: Expiration, ExpirationNotification,
         * and NoChangeNotification.
         * </p>
         * 
         * @param policyType
         *        The type of policy. Parameter Store supports the following policy types: Expiration,
         *        ExpirationNotification, and NoChangeNotification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyType(String policyType);

        /**
         * <p>
         * The status of the policy. Policies report the following statuses: Pending (the policy has not been enforced
         * or applied yet), Finished (the policy was applied), Failed (the policy was not applied), or InProgress (the
         * policy is being applied now).
         * </p>
         * 
         * @param policyStatus
         *        The status of the policy. Policies report the following statuses: Pending (the policy has not been
         *        enforced or applied yet), Finished (the policy was applied), Failed (the policy was not applied), or
         *        InProgress (the policy is being applied now).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyStatus(String policyStatus);
    }

    static final class BuilderImpl implements Builder {
        private String policyText;

        private String policyType;

        private String policyStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterInlinePolicy model) {
            policyText(model.policyText);
            policyType(model.policyType);
            policyStatus(model.policyStatus);
        }

        public final String getPolicyText() {
            return policyText;
        }

        @Override
        public final Builder policyText(String policyText) {
            this.policyText = policyText;
            return this;
        }

        public final void setPolicyText(String policyText) {
            this.policyText = policyText;
        }

        public final String getPolicyType() {
            return policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        public final String getPolicyStatus() {
            return policyStatus;
        }

        @Override
        public final Builder policyStatus(String policyStatus) {
            this.policyStatus = policyStatus;
            return this;
        }

        public final void setPolicyStatus(String policyStatus) {
            this.policyStatus = policyStatus;
        }

        @Override
        public ParameterInlinePolicy build() {
            return new ParameterInlinePolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
