/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAssociationResponse extends SsmResponse implements
        ToCopyableBuilder<CreateAssociationResponse.Builder, CreateAssociationResponse> {
    private static final SdkField<AssociationDescription> ASSOCIATION_DESCRIPTION_FIELD = SdkField
            .<AssociationDescription> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateAssociationResponse::associationDescription)).setter(setter(Builder::associationDescription))
            .constructor(AssociationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ASSOCIATION_DESCRIPTION_FIELD));

    private final AssociationDescription associationDescription;

    private CreateAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.associationDescription = builder.associationDescription;
    }

    /**
     * <p>
     * Information about the association.
     * </p>
     * 
     * @return Information about the association.
     */
    public AssociationDescription associationDescription() {
        return associationDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(associationDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssociationResponse)) {
            return false;
        }
        CreateAssociationResponse other = (CreateAssociationResponse) obj;
        return Objects.equals(associationDescription(), other.associationDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateAssociationResponse").add("AssociationDescription", associationDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationDescription":
            return Optional.ofNullable(clazz.cast(associationDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAssociationResponse, T> g) {
        return obj -> g.apply((CreateAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateAssociationResponse> {
        /**
         * <p>
         * Information about the association.
         * </p>
         * 
         * @param associationDescription
         *        Information about the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationDescription(AssociationDescription associationDescription);

        /**
         * <p>
         * Information about the association.
         * </p>
         * This is a convenience that creates an instance of the {@link AssociationDescription.Builder} avoiding the
         * need to create one manually via {@link AssociationDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link AssociationDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #associationDescription(AssociationDescription)}.
         * 
         * @param associationDescription
         *        a consumer that will call methods on {@link AssociationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associationDescription(AssociationDescription)
         */
        default Builder associationDescription(Consumer<AssociationDescription.Builder> associationDescription) {
            return associationDescription(AssociationDescription.builder().applyMutation(associationDescription).build());
        }
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private AssociationDescription associationDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssociationResponse model) {
            super(model);
            associationDescription(model.associationDescription);
        }

        public final AssociationDescription.Builder getAssociationDescription() {
            return associationDescription != null ? associationDescription.toBuilder() : null;
        }

        @Override
        public final Builder associationDescription(AssociationDescription associationDescription) {
            this.associationDescription = associationDescription;
            return this;
        }

        public final void setAssociationDescription(AssociationDescription.BuilderImpl associationDescription) {
            this.associationDescription = associationDescription != null ? associationDescription.build() : null;
        }

        @Override
        public CreateAssociationResponse build() {
            return new CreateAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
