/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a filter used in DescribeInstancePatchStatesForPatchGroup used to scope down the information returned by the
 * API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstancePatchStateFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<InstancePatchStateFilter.Builder, InstancePatchStateFilter> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InstancePatchStateFilter::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(InstancePatchStateFilter::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InstancePatchStateFilter::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUES_FIELD,
            TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String key;

    private final List<String> values;

    private final String type;

    private InstancePatchStateFilter(BuilderImpl builder) {
        this.key = builder.key;
        this.values = builder.values;
        this.type = builder.type;
    }

    /**
     * <p>
     * The key for the filter. Supported values are FailedCount, InstalledCount, InstalledOtherCount, MissingCount and
     * NotApplicableCount.
     * </p>
     * 
     * @return The key for the filter. Supported values are FailedCount, InstalledCount, InstalledOtherCount,
     *         MissingCount and NotApplicableCount.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * The value for the filter, must be an integer greater than or equal to 0.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value for the filter, must be an integer greater than or equal to 0.
     */
    public List<String> values() {
        return values;
    }

    /**
     * <p>
     * The type of comparison that should be performed for the value: Equal, NotEqual, LessThan or GreaterThan.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InstancePatchStateOperatorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of comparison that should be performed for the value: Equal, NotEqual, LessThan or GreaterThan.
     * @see InstancePatchStateOperatorType
     */
    public InstancePatchStateOperatorType type() {
        return InstancePatchStateOperatorType.fromValue(type);
    }

    /**
     * <p>
     * The type of comparison that should be performed for the value: Equal, NotEqual, LessThan or GreaterThan.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InstancePatchStateOperatorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of comparison that should be performed for the value: Equal, NotEqual, LessThan or GreaterThan.
     * @see InstancePatchStateOperatorType
     */
    public String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(values());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstancePatchStateFilter)) {
            return false;
        }
        InstancePatchStateFilter other = (InstancePatchStateFilter) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(values(), other.values())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InstancePatchStateFilter").add("Key", key()).add("Values", values()).add("Type", typeAsString())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstancePatchStateFilter, T> g) {
        return obj -> g.apply((InstancePatchStateFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstancePatchStateFilter> {
        /**
         * <p>
         * The key for the filter. Supported values are FailedCount, InstalledCount, InstalledOtherCount, MissingCount
         * and NotApplicableCount.
         * </p>
         * 
         * @param key
         *        The key for the filter. Supported values are FailedCount, InstalledCount, InstalledOtherCount,
         *        MissingCount and NotApplicableCount.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The value for the filter, must be an integer greater than or equal to 0.
         * </p>
         * 
         * @param values
         *        The value for the filter, must be an integer greater than or equal to 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The value for the filter, must be an integer greater than or equal to 0.
         * </p>
         * 
         * @param values
         *        The value for the filter, must be an integer greater than or equal to 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);

        /**
         * <p>
         * The type of comparison that should be performed for the value: Equal, NotEqual, LessThan or GreaterThan.
         * </p>
         * 
         * @param type
         *        The type of comparison that should be performed for the value: Equal, NotEqual, LessThan or
         *        GreaterThan.
         * @see InstancePatchStateOperatorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstancePatchStateOperatorType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of comparison that should be performed for the value: Equal, NotEqual, LessThan or GreaterThan.
         * </p>
         * 
         * @param type
         *        The type of comparison that should be performed for the value: Equal, NotEqual, LessThan or
         *        GreaterThan.
         * @see InstancePatchStateOperatorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstancePatchStateOperatorType
         */
        Builder type(InstancePatchStateOperatorType type);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(InstancePatchStateFilter model) {
            key(model.key);
            values(model.values);
            type(model.type);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Collection<String> getValues() {
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = InstancePatchStateFilterValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = InstancePatchStateFilterValuesCopier.copy(values);
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InstancePatchStateOperatorType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public InstancePatchStateFilter build() {
            return new InstancePatchStateFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
