/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPatchBaselineForPatchGroupRequest extends SsmRequest implements
        ToCopyableBuilder<GetPatchBaselineForPatchGroupRequest.Builder, GetPatchBaselineForPatchGroupRequest> {
    private static final SdkField<String> PATCH_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetPatchBaselineForPatchGroupRequest::patchGroup)).setter(setter(Builder::patchGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchGroup").build()).build();

    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetPatchBaselineForPatchGroupRequest::operatingSystemAsString))
            .setter(setter(Builder::operatingSystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATCH_GROUP_FIELD,
            OPERATING_SYSTEM_FIELD));

    private final String patchGroup;

    private final String operatingSystem;

    private GetPatchBaselineForPatchGroupRequest(BuilderImpl builder) {
        super(builder);
        this.patchGroup = builder.patchGroup;
        this.operatingSystem = builder.operatingSystem;
    }

    /**
     * <p>
     * The name of the patch group whose patch baseline should be retrieved.
     * </p>
     * 
     * @return The name of the patch group whose patch baseline should be retrieved.
     */
    public String patchGroup() {
        return patchGroup;
    }

    /**
     * <p>
     * Returns he operating system rule specified for patch groups using the patch baseline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operatingSystem}
     * will return {@link OperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatingSystemAsString}.
     * </p>
     * 
     * @return Returns he operating system rule specified for patch groups using the patch baseline.
     * @see OperatingSystem
     */
    public OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(operatingSystem);
    }

    /**
     * <p>
     * Returns he operating system rule specified for patch groups using the patch baseline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operatingSystem}
     * will return {@link OperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatingSystemAsString}.
     * </p>
     * 
     * @return Returns he operating system rule specified for patch groups using the patch baseline.
     * @see OperatingSystem
     */
    public String operatingSystemAsString() {
        return operatingSystem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(patchGroup());
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystemAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPatchBaselineForPatchGroupRequest)) {
            return false;
        }
        GetPatchBaselineForPatchGroupRequest other = (GetPatchBaselineForPatchGroupRequest) obj;
        return Objects.equals(patchGroup(), other.patchGroup())
                && Objects.equals(operatingSystemAsString(), other.operatingSystemAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetPatchBaselineForPatchGroupRequest").add("PatchGroup", patchGroup())
                .add("OperatingSystem", operatingSystemAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PatchGroup":
            return Optional.ofNullable(clazz.cast(patchGroup()));
        case "OperatingSystem":
            return Optional.ofNullable(clazz.cast(operatingSystemAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPatchBaselineForPatchGroupRequest, T> g) {
        return obj -> g.apply((GetPatchBaselineForPatchGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetPatchBaselineForPatchGroupRequest> {
        /**
         * <p>
         * The name of the patch group whose patch baseline should be retrieved.
         * </p>
         * 
         * @param patchGroup
         *        The name of the patch group whose patch baseline should be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchGroup(String patchGroup);

        /**
         * <p>
         * Returns he operating system rule specified for patch groups using the patch baseline.
         * </p>
         * 
         * @param operatingSystem
         *        Returns he operating system rule specified for patch groups using the patch baseline.
         * @see OperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperatingSystem
         */
        Builder operatingSystem(String operatingSystem);

        /**
         * <p>
         * Returns he operating system rule specified for patch groups using the patch baseline.
         * </p>
         * 
         * @param operatingSystem
         *        Returns he operating system rule specified for patch groups using the patch baseline.
         * @see OperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperatingSystem
         */
        Builder operatingSystem(OperatingSystem operatingSystem);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String patchGroup;

        private String operatingSystem;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPatchBaselineForPatchGroupRequest model) {
            super(model);
            patchGroup(model.patchGroup);
            operatingSystem(model.operatingSystem);
        }

        public final String getPatchGroup() {
            return patchGroup;
        }

        @Override
        public final Builder patchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
            return this;
        }

        public final void setPatchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
        }

        public final String getOperatingSystemAsString() {
            return operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem.toString());
            return this;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPatchBaselineForPatchGroupRequest build() {
            return new GetPatchBaselineForPatchGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
