/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.ParameterInlinePolicy;
import software.amazon.awssdk.services.ssm.model.ParameterPolicyListCopier;
import software.amazon.awssdk.services.ssm.model.ParameterTier;
import software.amazon.awssdk.services.ssm.model.ParameterType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParameterMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParameterMetadata> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ParameterMetadata.getter(ParameterMetadata::name)).setter(ParameterMetadata.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ParameterMetadata.getter(ParameterMetadata::typeAsString)).setter(ParameterMetadata.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ParameterMetadata.getter(ParameterMetadata::keyId)).setter(ParameterMetadata.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ParameterMetadata.getter(ParameterMetadata::lastModifiedDate)).setter(ParameterMetadata.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ParameterMetadata.getter(ParameterMetadata::lastModifiedUser)).setter(ParameterMetadata.setter(Builder::lastModifiedUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedUser").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ParameterMetadata.getter(ParameterMetadata::description)).setter(ParameterMetadata.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ALLOWED_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ParameterMetadata.getter(ParameterMetadata::allowedPattern)).setter(ParameterMetadata.setter(Builder::allowedPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedPattern").build()}).build();
    private static final SdkField<Long> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(ParameterMetadata.getter(ParameterMetadata::version)).setter(ParameterMetadata.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ParameterMetadata.getter(ParameterMetadata::tierAsString)).setter(ParameterMetadata.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()}).build();
    private static final SdkField<List<ParameterInlinePolicy>> POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ParameterMetadata.getter(ParameterMetadata::policies)).setter(ParameterMetadata.setter(Builder::policies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParameterInlinePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD, KEY_ID_FIELD, LAST_MODIFIED_DATE_FIELD, LAST_MODIFIED_USER_FIELD, DESCRIPTION_FIELD, ALLOWED_PATTERN_FIELD, VERSION_FIELD, TIER_FIELD, POLICIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String type;
    private final String keyId;
    private final Instant lastModifiedDate;
    private final String lastModifiedUser;
    private final String description;
    private final String allowedPattern;
    private final Long version;
    private final String tier;
    private final List<ParameterInlinePolicy> policies;

    private ParameterMetadata(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.keyId = builder.keyId;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.lastModifiedUser = builder.lastModifiedUser;
        this.description = builder.description;
        this.allowedPattern = builder.allowedPattern;
        this.version = builder.version;
        this.tier = builder.tier;
        this.policies = builder.policies;
    }

    public String name() {
        return this.name;
    }

    public ParameterType type() {
        return ParameterType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String keyId() {
        return this.keyId;
    }

    public Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String lastModifiedUser() {
        return this.lastModifiedUser;
    }

    public String description() {
        return this.description;
    }

    public String allowedPattern() {
        return this.allowedPattern;
    }

    public Long version() {
        return this.version;
    }

    public ParameterTier tier() {
        return ParameterTier.fromValue(this.tier);
    }

    public String tierAsString() {
        return this.tier;
    }

    public List<ParameterInlinePolicy> policies() {
        return this.policies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.policies());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterMetadata)) {
            return false;
        }
        ParameterMetadata other = (ParameterMetadata)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.lastModifiedUser(), other.lastModifiedUser()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.allowedPattern(), other.allowedPattern()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.tierAsString(), other.tierAsString()) && Objects.equals(this.policies(), other.policies());
    }

    public String toString() {
        return ToString.builder((String)"ParameterMetadata").add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("KeyId", (Object)this.keyId()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("LastModifiedUser", (Object)this.lastModifiedUser()).add("Description", (Object)this.description()).add("AllowedPattern", (Object)this.allowedPattern()).add("Version", (Object)this.version()).add("Tier", (Object)this.tierAsString()).add("Policies", this.policies()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "LastModifiedUser": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedUser()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AllowedPattern": {
                return Optional.ofNullable(clazz.cast(this.allowedPattern()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "Tier": {
                return Optional.ofNullable(clazz.cast(this.tierAsString()));
            }
            case "Policies": {
                return Optional.ofNullable(clazz.cast(this.policies()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParameterMetadata, T> g) {
        return obj -> g.apply((ParameterMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private String keyId;
        private Instant lastModifiedDate;
        private String lastModifiedUser;
        private String description;
        private String allowedPattern;
        private Long version;
        private String tier;
        private List<ParameterInlinePolicy> policies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterMetadata model) {
            this.name(model.name);
            this.type(model.type);
            this.keyId(model.keyId);
            this.lastModifiedDate(model.lastModifiedDate);
            this.lastModifiedUser(model.lastModifiedUser);
            this.description(model.description);
            this.allowedPattern(model.allowedPattern);
            this.version(model.version);
            this.tier(model.tier);
            this.policies(model.policies);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ParameterType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getLastModifiedUser() {
            return this.lastModifiedUser;
        }

        @Override
        public final Builder lastModifiedUser(String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        public final void setLastModifiedUser(String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getAllowedPattern() {
            return this.allowedPattern;
        }

        @Override
        public final Builder allowedPattern(String allowedPattern) {
            this.allowedPattern = allowedPattern;
            return this;
        }

        public final void setAllowedPattern(String allowedPattern) {
            this.allowedPattern = allowedPattern;
        }

        public final Long getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        public final String getTierAsString() {
            return this.tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(ParameterTier tier) {
            this.tier(tier.toString());
            return this;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        public final Collection<ParameterInlinePolicy.Builder> getPolicies() {
            return this.policies != null ? (Collection)this.policies.stream().map(ParameterInlinePolicy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policies(Collection<ParameterInlinePolicy> policies) {
            this.policies = ParameterPolicyListCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(ParameterInlinePolicy ... policies) {
            this.policies(Arrays.asList(policies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(Consumer<ParameterInlinePolicy.Builder> ... policies) {
            this.policies(Stream.of(policies).map(c -> (ParameterInlinePolicy)((ParameterInlinePolicy.Builder)ParameterInlinePolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPolicies(Collection<ParameterInlinePolicy.BuilderImpl> policies) {
            this.policies = ParameterPolicyListCopier.copyFromBuilder(policies);
        }

        public ParameterMetadata build() {
            return new ParameterMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParameterMetadata> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(ParameterType var1);

        public Builder keyId(String var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder lastModifiedUser(String var1);

        public Builder description(String var1);

        public Builder allowedPattern(String var1);

        public Builder version(Long var1);

        public Builder tier(String var1);

        public Builder tier(ParameterTier var1);

        public Builder policies(Collection<ParameterInlinePolicy> var1);

        public Builder policies(ParameterInlinePolicy ... var1);

        public Builder policies(Consumer<ParameterInlinePolicy.Builder> ... var1);
    }
}

