/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteInventoryRequest extends SsmRequest implements
        ToCopyableBuilder<DeleteInventoryRequest.Builder, DeleteInventoryRequest> {
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteInventoryRequest::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> SCHEMA_DELETE_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteInventoryRequest::schemaDeleteOptionAsString)).setter(setter(Builder::schemaDeleteOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaDeleteOption").build())
            .build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DeleteInventoryRequest::dryRun)).setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteInventoryRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_NAME_FIELD,
            SCHEMA_DELETE_OPTION_FIELD, DRY_RUN_FIELD, CLIENT_TOKEN_FIELD));

    private final String typeName;

    private final String schemaDeleteOption;

    private final Boolean dryRun;

    private final String clientToken;

    private DeleteInventoryRequest(BuilderImpl builder) {
        super(builder);
        this.typeName = builder.typeName;
        this.schemaDeleteOption = builder.schemaDeleteOption;
        this.dryRun = builder.dryRun;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the custom inventory type for which you want to delete either all previously collected data, or the
     * inventory type itself.
     * </p>
     * 
     * @return The name of the custom inventory type for which you want to delete either all previously collected data,
     *         or the inventory type itself.
     */
    public String typeName() {
        return typeName;
    }

    /**
     * <p>
     * Use the <code>SchemaDeleteOption</code> to delete a custom inventory type (schema). If you don't choose this
     * option, the system only deletes existing inventory data associated with the custom inventory type. Choose one of
     * the following options:
     * </p>
     * <p>
     * DisableSchema: If you choose this option, the system ignores all inventory data for the specified version, and
     * any earlier versions. To enable this schema again, you must call the <code>PutInventory</code> action for a
     * version greater than the disabled version.
     * </p>
     * <p>
     * DeleteSchema: This option deletes the specified custom type from the Inventory service. You can recreate the
     * schema later, if you want.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #schemaDeleteOption} will return {@link InventorySchemaDeleteOption#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #schemaDeleteOptionAsString}.
     * </p>
     * 
     * @return Use the <code>SchemaDeleteOption</code> to delete a custom inventory type (schema). If you don't choose
     *         this option, the system only deletes existing inventory data associated with the custom inventory type.
     *         Choose one of the following options:</p>
     *         <p>
     *         DisableSchema: If you choose this option, the system ignores all inventory data for the specified
     *         version, and any earlier versions. To enable this schema again, you must call the
     *         <code>PutInventory</code> action for a version greater than the disabled version.
     *         </p>
     *         <p>
     *         DeleteSchema: This option deletes the specified custom type from the Inventory service. You can recreate
     *         the schema later, if you want.
     * @see InventorySchemaDeleteOption
     */
    public InventorySchemaDeleteOption schemaDeleteOption() {
        return InventorySchemaDeleteOption.fromValue(schemaDeleteOption);
    }

    /**
     * <p>
     * Use the <code>SchemaDeleteOption</code> to delete a custom inventory type (schema). If you don't choose this
     * option, the system only deletes existing inventory data associated with the custom inventory type. Choose one of
     * the following options:
     * </p>
     * <p>
     * DisableSchema: If you choose this option, the system ignores all inventory data for the specified version, and
     * any earlier versions. To enable this schema again, you must call the <code>PutInventory</code> action for a
     * version greater than the disabled version.
     * </p>
     * <p>
     * DeleteSchema: This option deletes the specified custom type from the Inventory service. You can recreate the
     * schema later, if you want.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #schemaDeleteOption} will return {@link InventorySchemaDeleteOption#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #schemaDeleteOptionAsString}.
     * </p>
     * 
     * @return Use the <code>SchemaDeleteOption</code> to delete a custom inventory type (schema). If you don't choose
     *         this option, the system only deletes existing inventory data associated with the custom inventory type.
     *         Choose one of the following options:</p>
     *         <p>
     *         DisableSchema: If you choose this option, the system ignores all inventory data for the specified
     *         version, and any earlier versions. To enable this schema again, you must call the
     *         <code>PutInventory</code> action for a version greater than the disabled version.
     *         </p>
     *         <p>
     *         DeleteSchema: This option deletes the specified custom type from the Inventory service. You can recreate
     *         the schema later, if you want.
     * @see InventorySchemaDeleteOption
     */
    public String schemaDeleteOptionAsString() {
        return schemaDeleteOption;
    }

    /**
     * <p>
     * Use this option to view a summary of the deletion request without deleting any data or the data type. This option
     * is useful when you only want to understand what will be deleted. Once you validate that the data to be deleted is
     * what you intend to delete, you can run the same command without specifying the <code>DryRun</code> option.
     * </p>
     * 
     * @return Use this option to view a summary of the deletion request without deleting any data or the data type.
     *         This option is useful when you only want to understand what will be deleted. Once you validate that the
     *         data to be deleted is what you intend to delete, you can run the same command without specifying the
     *         <code>DryRun</code> option.
     */
    public Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * User-provided idempotency token.
     * </p>
     * 
     * @return User-provided idempotency token.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(schemaDeleteOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteInventoryRequest)) {
            return false;
        }
        DeleteInventoryRequest other = (DeleteInventoryRequest) obj;
        return Objects.equals(typeName(), other.typeName())
                && Objects.equals(schemaDeleteOptionAsString(), other.schemaDeleteOptionAsString())
                && Objects.equals(dryRun(), other.dryRun()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteInventoryRequest").add("TypeName", typeName())
                .add("SchemaDeleteOption", schemaDeleteOptionAsString()).add("DryRun", dryRun())
                .add("ClientToken", clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "SchemaDeleteOption":
            return Optional.ofNullable(clazz.cast(schemaDeleteOptionAsString()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteInventoryRequest, T> g) {
        return obj -> g.apply((DeleteInventoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteInventoryRequest> {
        /**
         * <p>
         * The name of the custom inventory type for which you want to delete either all previously collected data, or
         * the inventory type itself.
         * </p>
         * 
         * @param typeName
         *        The name of the custom inventory type for which you want to delete either all previously collected
         *        data, or the inventory type itself.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * Use the <code>SchemaDeleteOption</code> to delete a custom inventory type (schema). If you don't choose this
         * option, the system only deletes existing inventory data associated with the custom inventory type. Choose one
         * of the following options:
         * </p>
         * <p>
         * DisableSchema: If you choose this option, the system ignores all inventory data for the specified version,
         * and any earlier versions. To enable this schema again, you must call the <code>PutInventory</code> action for
         * a version greater than the disabled version.
         * </p>
         * <p>
         * DeleteSchema: This option deletes the specified custom type from the Inventory service. You can recreate the
         * schema later, if you want.
         * </p>
         * 
         * @param schemaDeleteOption
         *        Use the <code>SchemaDeleteOption</code> to delete a custom inventory type (schema). If you don't
         *        choose this option, the system only deletes existing inventory data associated with the custom
         *        inventory type. Choose one of the following options:</p>
         *        <p>
         *        DisableSchema: If you choose this option, the system ignores all inventory data for the specified
         *        version, and any earlier versions. To enable this schema again, you must call the
         *        <code>PutInventory</code> action for a version greater than the disabled version.
         *        </p>
         *        <p>
         *        DeleteSchema: This option deletes the specified custom type from the Inventory service. You can
         *        recreate the schema later, if you want.
         * @see InventorySchemaDeleteOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InventorySchemaDeleteOption
         */
        Builder schemaDeleteOption(String schemaDeleteOption);

        /**
         * <p>
         * Use the <code>SchemaDeleteOption</code> to delete a custom inventory type (schema). If you don't choose this
         * option, the system only deletes existing inventory data associated with the custom inventory type. Choose one
         * of the following options:
         * </p>
         * <p>
         * DisableSchema: If you choose this option, the system ignores all inventory data for the specified version,
         * and any earlier versions. To enable this schema again, you must call the <code>PutInventory</code> action for
         * a version greater than the disabled version.
         * </p>
         * <p>
         * DeleteSchema: This option deletes the specified custom type from the Inventory service. You can recreate the
         * schema later, if you want.
         * </p>
         * 
         * @param schemaDeleteOption
         *        Use the <code>SchemaDeleteOption</code> to delete a custom inventory type (schema). If you don't
         *        choose this option, the system only deletes existing inventory data associated with the custom
         *        inventory type. Choose one of the following options:</p>
         *        <p>
         *        DisableSchema: If you choose this option, the system ignores all inventory data for the specified
         *        version, and any earlier versions. To enable this schema again, you must call the
         *        <code>PutInventory</code> action for a version greater than the disabled version.
         *        </p>
         *        <p>
         *        DeleteSchema: This option deletes the specified custom type from the Inventory service. You can
         *        recreate the schema later, if you want.
         * @see InventorySchemaDeleteOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InventorySchemaDeleteOption
         */
        Builder schemaDeleteOption(InventorySchemaDeleteOption schemaDeleteOption);

        /**
         * <p>
         * Use this option to view a summary of the deletion request without deleting any data or the data type. This
         * option is useful when you only want to understand what will be deleted. Once you validate that the data to be
         * deleted is what you intend to delete, you can run the same command without specifying the <code>DryRun</code>
         * option.
         * </p>
         * 
         * @param dryRun
         *        Use this option to view a summary of the deletion request without deleting any data or the data type.
         *        This option is useful when you only want to understand what will be deleted. Once you validate that
         *        the data to be deleted is what you intend to delete, you can run the same command without specifying
         *        the <code>DryRun</code> option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * User-provided idempotency token.
         * </p>
         * 
         * @param clientToken
         *        User-provided idempotency token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String typeName;

        private String schemaDeleteOption;

        private Boolean dryRun;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteInventoryRequest model) {
            super(model);
            typeName(model.typeName);
            schemaDeleteOption(model.schemaDeleteOption);
            dryRun(model.dryRun);
            clientToken(model.clientToken);
        }

        public final String getTypeName() {
            return typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getSchemaDeleteOptionAsString() {
            return schemaDeleteOption;
        }

        @Override
        public final Builder schemaDeleteOption(String schemaDeleteOption) {
            this.schemaDeleteOption = schemaDeleteOption;
            return this;
        }

        @Override
        public final Builder schemaDeleteOption(InventorySchemaDeleteOption schemaDeleteOption) {
            this.schemaDeleteOption(schemaDeleteOption.toString());
            return this;
        }

        public final void setSchemaDeleteOption(String schemaDeleteOption) {
            this.schemaDeleteOption = schemaDeleteOption;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteInventoryRequest build() {
            return new DeleteInventoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
