/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a Session Manager connection to an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Session implements SdkPojo, Serializable, ToCopyableBuilder<Session.Builder, Session> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Session::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Session::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Session::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Session::startDate)).setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()).build();

    private static final SdkField<Instant> END_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Session::endDate)).setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").build()).build();

    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Session::documentName)).setter(setter(Builder::documentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentName").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Session::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<String> DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Session::details)).setter(setter(Builder::details))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build()).build();

    private static final SdkField<SessionManagerOutputUrl> OUTPUT_URL_FIELD = SdkField
            .<SessionManagerOutputUrl> builder(MarshallingType.SDK_POJO).getter(getter(Session::outputUrl))
            .setter(setter(Builder::outputUrl)).constructor(SessionManagerOutputUrl::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD,
            TARGET_FIELD, STATUS_FIELD, START_DATE_FIELD, END_DATE_FIELD, DOCUMENT_NAME_FIELD, OWNER_FIELD, DETAILS_FIELD,
            OUTPUT_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sessionId;

    private final String target;

    private final String status;

    private final Instant startDate;

    private final Instant endDate;

    private final String documentName;

    private final String owner;

    private final String details;

    private final SessionManagerOutputUrl outputUrl;

    private Session(BuilderImpl builder) {
        this.sessionId = builder.sessionId;
        this.target = builder.target;
        this.status = builder.status;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.documentName = builder.documentName;
        this.owner = builder.owner;
        this.details = builder.details;
        this.outputUrl = builder.outputUrl;
    }

    /**
     * <p>
     * The ID of the session.
     * </p>
     * 
     * @return The ID of the session.
     */
    public String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The instance that the Session Manager session connected to.
     * </p>
     * 
     * @return The instance that the Session Manager session connected to.
     */
    public String target() {
        return target;
    }

    /**
     * <p>
     * The status of the session. For example, "Connected" or "Terminated".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the session. For example, "Connected" or "Terminated".
     * @see SessionStatus
     */
    public SessionStatus status() {
        return SessionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the session. For example, "Connected" or "Terminated".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the session. For example, "Connected" or "Terminated".
     * @see SessionStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time, in ISO-8601 Extended format, when the session began.
     * </p>
     * 
     * @return The date and time, in ISO-8601 Extended format, when the session began.
     */
    public Instant startDate() {
        return startDate;
    }

    /**
     * <p>
     * The date and time, in ISO-8601 Extended format, when the session was terminated.
     * </p>
     * 
     * @return The date and time, in ISO-8601 Extended format, when the session was terminated.
     */
    public Instant endDate() {
        return endDate;
    }

    /**
     * <p>
     * The name of the Session Manager SSM document used to define the parameters and plugin settings for the session.
     * For example, <code>SSM-SessionManagerRunShell</code>.
     * </p>
     * 
     * @return The name of the Session Manager SSM document used to define the parameters and plugin settings for the
     *         session. For example, <code>SSM-SessionManagerRunShell</code>.
     */
    public String documentName() {
        return documentName;
    }

    /**
     * <p>
     * The ID of the AWS user account that started the session.
     * </p>
     * 
     * @return The ID of the AWS user account that started the session.
     */
    public String owner() {
        return owner;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public String details() {
        return details;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public SessionManagerOutputUrl outputUrl() {
        return outputUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        hashCode = 31 * hashCode + Objects.hashCode(documentName());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        hashCode = 31 * hashCode + Objects.hashCode(outputUrl());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Session)) {
            return false;
        }
        Session other = (Session) obj;
        return Objects.equals(sessionId(), other.sessionId()) && Objects.equals(target(), other.target())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(startDate(), other.startDate())
                && Objects.equals(endDate(), other.endDate()) && Objects.equals(documentName(), other.documentName())
                && Objects.equals(owner(), other.owner()) && Objects.equals(details(), other.details())
                && Objects.equals(outputUrl(), other.outputUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Session").add("SessionId", sessionId()).add("Target", target()).add("Status", statusAsString())
                .add("StartDate", startDate()).add("EndDate", endDate()).add("DocumentName", documentName())
                .add("Owner", owner()).add("Details", details()).add("OutputUrl", outputUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StartDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "EndDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        case "DocumentName":
            return Optional.ofNullable(clazz.cast(documentName()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "Details":
            return Optional.ofNullable(clazz.cast(details()));
        case "OutputUrl":
            return Optional.ofNullable(clazz.cast(outputUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Session, T> g) {
        return obj -> g.apply((Session) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Session> {
        /**
         * <p>
         * The ID of the session.
         * </p>
         * 
         * @param sessionId
         *        The ID of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The instance that the Session Manager session connected to.
         * </p>
         * 
         * @param target
         *        The instance that the Session Manager session connected to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);

        /**
         * <p>
         * The status of the session. For example, "Connected" or "Terminated".
         * </p>
         * 
         * @param status
         *        The status of the session. For example, "Connected" or "Terminated".
         * @see SessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the session. For example, "Connected" or "Terminated".
         * </p>
         * 
         * @param status
         *        The status of the session. For example, "Connected" or "Terminated".
         * @see SessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionStatus
         */
        Builder status(SessionStatus status);

        /**
         * <p>
         * The date and time, in ISO-8601 Extended format, when the session began.
         * </p>
         * 
         * @param startDate
         *        The date and time, in ISO-8601 Extended format, when the session began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <p>
         * The date and time, in ISO-8601 Extended format, when the session was terminated.
         * </p>
         * 
         * @param endDate
         *        The date and time, in ISO-8601 Extended format, when the session was terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(Instant endDate);

        /**
         * <p>
         * The name of the Session Manager SSM document used to define the parameters and plugin settings for the
         * session. For example, <code>SSM-SessionManagerRunShell</code>.
         * </p>
         * 
         * @param documentName
         *        The name of the Session Manager SSM document used to define the parameters and plugin settings for the
         *        session. For example, <code>SSM-SessionManagerRunShell</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentName(String documentName);

        /**
         * <p>
         * The ID of the AWS user account that started the session.
         * </p>
         * 
         * @param owner
         *        The ID of the AWS user account that started the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param details
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(String details);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param outputUrl
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputUrl(SessionManagerOutputUrl outputUrl);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * This is a convenience that creates an instance of the {@link SessionManagerOutputUrl.Builder} avoiding the
         * need to create one manually via {@link SessionManagerOutputUrl#builder()}.
         *
         * When the {@link Consumer} completes, {@link SessionManagerOutputUrl.Builder#build()} is called immediately
         * and its result is passed to {@link #outputUrl(SessionManagerOutputUrl)}.
         * 
         * @param outputUrl
         *        a consumer that will call methods on {@link SessionManagerOutputUrl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputUrl(SessionManagerOutputUrl)
         */
        default Builder outputUrl(Consumer<SessionManagerOutputUrl.Builder> outputUrl) {
            return outputUrl(SessionManagerOutputUrl.builder().applyMutation(outputUrl).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String sessionId;

        private String target;

        private String status;

        private Instant startDate;

        private Instant endDate;

        private String documentName;

        private String owner;

        private String details;

        private SessionManagerOutputUrl outputUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(Session model) {
            sessionId(model.sessionId);
            target(model.target);
            status(model.status);
            startDate(model.startDate);
            endDate(model.endDate);
            documentName(model.documentName);
            owner(model.owner);
            details(model.details);
            outputUrl(model.outputUrl);
        }

        public final String getSessionId() {
            return sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public final String getTarget() {
            return target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SessionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getStartDate() {
            return startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        public final Instant getEndDate() {
            return endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        public final String getDocumentName() {
            return documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final String getOwner() {
            return owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final String getDetails() {
            return details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        public final SessionManagerOutputUrl.Builder getOutputUrl() {
            return outputUrl != null ? outputUrl.toBuilder() : null;
        }

        @Override
        public final Builder outputUrl(SessionManagerOutputUrl outputUrl) {
            this.outputUrl = outputUrl;
            return this;
        }

        public final void setOutputUrl(SessionManagerOutputUrl.BuilderImpl outputUrl) {
            this.outputUrl = outputUrl != null ? outputUrl.build() : null;
        }

        @Override
        public Session build() {
            return new Session(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
