/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.InstanceAggregatedAssociationOverview;
import software.amazon.awssdk.services.ssm.model.PingStatus;
import software.amazon.awssdk.services.ssm.model.PlatformType;
import software.amazon.awssdk.services.ssm.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceInformation> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceInformation.getter(InstanceInformation::instanceId)).setter(InstanceInformation.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> PING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceInformation.getter(InstanceInformation::pingStatusAsString)).setter(InstanceInformation.setter(Builder::pingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PingStatus").build()}).build();
    private static final SdkField<Instant> LAST_PING_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(InstanceInformation.getter(InstanceInformation::lastPingDateTime)).setter(InstanceInformation.setter(Builder::lastPingDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastPingDateTime").build()}).build();
    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceInformation.getter(InstanceInformation::agentVersion)).setter(InstanceInformation.setter(Builder::agentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentVersion").build()}).build();
    private static final SdkField<Boolean> IS_LATEST_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(InstanceInformation.getter(InstanceInformation::isLatestVersion)).setter(InstanceInformation.setter(Builder::isLatestVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsLatestVersion").build()}).build();
    private static final SdkField<String> PLATFORM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceInformation.getter(InstanceInformation::platformTypeAsString)).setter(InstanceInformation.setter(Builder::platformType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformType").build()}).build();
    private static final SdkField<String> PLATFORM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceInformation.getter(InstanceInformation::platformName)).setter(InstanceInformation.setter(Builder::platformName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformName").build()}).build();
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceInformation.getter(InstanceInformation::platformVersion)).setter(InstanceInformation.setter(Builder::platformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformVersion").build()}).build();
    private static final SdkField<String> ACTIVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceInformation.getter(InstanceInformation::activationId)).setter(InstanceInformation.setter(Builder::activationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationId").build()}).build();
    private static final SdkField<String> IAM_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceInformation.getter(InstanceInformation::iamRole)).setter(InstanceInformation.setter(Builder::iamRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRole").build()}).build();
    private static final SdkField<Instant> REGISTRATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(InstanceInformation.getter(InstanceInformation::registrationDate)).setter(InstanceInformation.setter(Builder::registrationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationDate").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceInformation.getter(InstanceInformation::resourceTypeAsString)).setter(InstanceInformation.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceInformation.getter(InstanceInformation::name)).setter(InstanceInformation.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceInformation.getter(InstanceInformation::ipAddress)).setter(InstanceInformation.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPAddress").build()}).build();
    private static final SdkField<String> COMPUTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceInformation.getter(InstanceInformation::computerName)).setter(InstanceInformation.setter(Builder::computerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputerName").build()}).build();
    private static final SdkField<String> ASSOCIATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceInformation.getter(InstanceInformation::associationStatus)).setter(InstanceInformation.setter(Builder::associationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationStatus").build()}).build();
    private static final SdkField<Instant> LAST_ASSOCIATION_EXECUTION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(InstanceInformation.getter(InstanceInformation::lastAssociationExecutionDate)).setter(InstanceInformation.setter(Builder::lastAssociationExecutionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAssociationExecutionDate").build()}).build();
    private static final SdkField<Instant> LAST_SUCCESSFUL_ASSOCIATION_EXECUTION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(InstanceInformation.getter(InstanceInformation::lastSuccessfulAssociationExecutionDate)).setter(InstanceInformation.setter(Builder::lastSuccessfulAssociationExecutionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfulAssociationExecutionDate").build()}).build();
    private static final SdkField<InstanceAggregatedAssociationOverview> ASSOCIATION_OVERVIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(InstanceInformation.getter(InstanceInformation::associationOverview)).setter(InstanceInformation.setter(Builder::associationOverview)).constructor(InstanceAggregatedAssociationOverview::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationOverview").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, PING_STATUS_FIELD, LAST_PING_DATE_TIME_FIELD, AGENT_VERSION_FIELD, IS_LATEST_VERSION_FIELD, PLATFORM_TYPE_FIELD, PLATFORM_NAME_FIELD, PLATFORM_VERSION_FIELD, ACTIVATION_ID_FIELD, IAM_ROLE_FIELD, REGISTRATION_DATE_FIELD, RESOURCE_TYPE_FIELD, NAME_FIELD, IP_ADDRESS_FIELD, COMPUTER_NAME_FIELD, ASSOCIATION_STATUS_FIELD, LAST_ASSOCIATION_EXECUTION_DATE_FIELD, LAST_SUCCESSFUL_ASSOCIATION_EXECUTION_DATE_FIELD, ASSOCIATION_OVERVIEW_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceId;
    private final String pingStatus;
    private final Instant lastPingDateTime;
    private final String agentVersion;
    private final Boolean isLatestVersion;
    private final String platformType;
    private final String platformName;
    private final String platformVersion;
    private final String activationId;
    private final String iamRole;
    private final Instant registrationDate;
    private final String resourceType;
    private final String name;
    private final String ipAddress;
    private final String computerName;
    private final String associationStatus;
    private final Instant lastAssociationExecutionDate;
    private final Instant lastSuccessfulAssociationExecutionDate;
    private final InstanceAggregatedAssociationOverview associationOverview;

    private InstanceInformation(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.pingStatus = builder.pingStatus;
        this.lastPingDateTime = builder.lastPingDateTime;
        this.agentVersion = builder.agentVersion;
        this.isLatestVersion = builder.isLatestVersion;
        this.platformType = builder.platformType;
        this.platformName = builder.platformName;
        this.platformVersion = builder.platformVersion;
        this.activationId = builder.activationId;
        this.iamRole = builder.iamRole;
        this.registrationDate = builder.registrationDate;
        this.resourceType = builder.resourceType;
        this.name = builder.name;
        this.ipAddress = builder.ipAddress;
        this.computerName = builder.computerName;
        this.associationStatus = builder.associationStatus;
        this.lastAssociationExecutionDate = builder.lastAssociationExecutionDate;
        this.lastSuccessfulAssociationExecutionDate = builder.lastSuccessfulAssociationExecutionDate;
        this.associationOverview = builder.associationOverview;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public PingStatus pingStatus() {
        return PingStatus.fromValue(this.pingStatus);
    }

    public String pingStatusAsString() {
        return this.pingStatus;
    }

    public Instant lastPingDateTime() {
        return this.lastPingDateTime;
    }

    public String agentVersion() {
        return this.agentVersion;
    }

    public Boolean isLatestVersion() {
        return this.isLatestVersion;
    }

    public PlatformType platformType() {
        return PlatformType.fromValue(this.platformType);
    }

    public String platformTypeAsString() {
        return this.platformType;
    }

    public String platformName() {
        return this.platformName;
    }

    public String platformVersion() {
        return this.platformVersion;
    }

    public String activationId() {
        return this.activationId;
    }

    public String iamRole() {
        return this.iamRole;
    }

    public Instant registrationDate() {
        return this.registrationDate;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public String name() {
        return this.name;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public String computerName() {
        return this.computerName;
    }

    public String associationStatus() {
        return this.associationStatus;
    }

    public Instant lastAssociationExecutionDate() {
        return this.lastAssociationExecutionDate;
    }

    public Instant lastSuccessfulAssociationExecutionDate() {
        return this.lastSuccessfulAssociationExecutionDate;
    }

    public InstanceAggregatedAssociationOverview associationOverview() {
        return this.associationOverview;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pingStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastPingDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.isLatestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformName());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.activationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.computerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAssociationExecutionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfulAssociationExecutionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationOverview());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceInformation)) {
            return false;
        }
        InstanceInformation other = (InstanceInformation)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.pingStatusAsString(), other.pingStatusAsString()) && Objects.equals(this.lastPingDateTime(), other.lastPingDateTime()) && Objects.equals(this.agentVersion(), other.agentVersion()) && Objects.equals(this.isLatestVersion(), other.isLatestVersion()) && Objects.equals(this.platformTypeAsString(), other.platformTypeAsString()) && Objects.equals(this.platformName(), other.platformName()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.activationId(), other.activationId()) && Objects.equals(this.iamRole(), other.iamRole()) && Objects.equals(this.registrationDate(), other.registrationDate()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.computerName(), other.computerName()) && Objects.equals(this.associationStatus(), other.associationStatus()) && Objects.equals(this.lastAssociationExecutionDate(), other.lastAssociationExecutionDate()) && Objects.equals(this.lastSuccessfulAssociationExecutionDate(), other.lastSuccessfulAssociationExecutionDate()) && Objects.equals(this.associationOverview(), other.associationOverview());
    }

    public String toString() {
        return ToString.builder((String)"InstanceInformation").add("InstanceId", (Object)this.instanceId()).add("PingStatus", (Object)this.pingStatusAsString()).add("LastPingDateTime", (Object)this.lastPingDateTime()).add("AgentVersion", (Object)this.agentVersion()).add("IsLatestVersion", (Object)this.isLatestVersion()).add("PlatformType", (Object)this.platformTypeAsString()).add("PlatformName", (Object)this.platformName()).add("PlatformVersion", (Object)this.platformVersion()).add("ActivationId", (Object)this.activationId()).add("IamRole", (Object)this.iamRole()).add("RegistrationDate", (Object)this.registrationDate()).add("ResourceType", (Object)this.resourceTypeAsString()).add("Name", (Object)this.name()).add("IPAddress", (Object)this.ipAddress()).add("ComputerName", (Object)this.computerName()).add("AssociationStatus", (Object)this.associationStatus()).add("LastAssociationExecutionDate", (Object)this.lastAssociationExecutionDate()).add("LastSuccessfulAssociationExecutionDate", (Object)this.lastSuccessfulAssociationExecutionDate()).add("AssociationOverview", (Object)this.associationOverview()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "PingStatus": {
                return Optional.ofNullable(clazz.cast(this.pingStatusAsString()));
            }
            case "LastPingDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastPingDateTime()));
            }
            case "AgentVersion": {
                return Optional.ofNullable(clazz.cast(this.agentVersion()));
            }
            case "IsLatestVersion": {
                return Optional.ofNullable(clazz.cast(this.isLatestVersion()));
            }
            case "PlatformType": {
                return Optional.ofNullable(clazz.cast(this.platformTypeAsString()));
            }
            case "PlatformName": {
                return Optional.ofNullable(clazz.cast(this.platformName()));
            }
            case "PlatformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "ActivationId": {
                return Optional.ofNullable(clazz.cast(this.activationId()));
            }
            case "IamRole": {
                return Optional.ofNullable(clazz.cast(this.iamRole()));
            }
            case "RegistrationDate": {
                return Optional.ofNullable(clazz.cast(this.registrationDate()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "IPAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "ComputerName": {
                return Optional.ofNullable(clazz.cast(this.computerName()));
            }
            case "AssociationStatus": {
                return Optional.ofNullable(clazz.cast(this.associationStatus()));
            }
            case "LastAssociationExecutionDate": {
                return Optional.ofNullable(clazz.cast(this.lastAssociationExecutionDate()));
            }
            case "LastSuccessfulAssociationExecutionDate": {
                return Optional.ofNullable(clazz.cast(this.lastSuccessfulAssociationExecutionDate()));
            }
            case "AssociationOverview": {
                return Optional.ofNullable(clazz.cast(this.associationOverview()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceInformation, T> g) {
        return obj -> g.apply((InstanceInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String pingStatus;
        private Instant lastPingDateTime;
        private String agentVersion;
        private Boolean isLatestVersion;
        private String platformType;
        private String platformName;
        private String platformVersion;
        private String activationId;
        private String iamRole;
        private Instant registrationDate;
        private String resourceType;
        private String name;
        private String ipAddress;
        private String computerName;
        private String associationStatus;
        private Instant lastAssociationExecutionDate;
        private Instant lastSuccessfulAssociationExecutionDate;
        private InstanceAggregatedAssociationOverview associationOverview;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceInformation model) {
            this.instanceId(model.instanceId);
            this.pingStatus(model.pingStatus);
            this.lastPingDateTime(model.lastPingDateTime);
            this.agentVersion(model.agentVersion);
            this.isLatestVersion(model.isLatestVersion);
            this.platformType(model.platformType);
            this.platformName(model.platformName);
            this.platformVersion(model.platformVersion);
            this.activationId(model.activationId);
            this.iamRole(model.iamRole);
            this.registrationDate(model.registrationDate);
            this.resourceType(model.resourceType);
            this.name(model.name);
            this.ipAddress(model.ipAddress);
            this.computerName(model.computerName);
            this.associationStatus(model.associationStatus);
            this.lastAssociationExecutionDate(model.lastAssociationExecutionDate);
            this.lastSuccessfulAssociationExecutionDate(model.lastSuccessfulAssociationExecutionDate);
            this.associationOverview(model.associationOverview);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getPingStatusAsString() {
            return this.pingStatus;
        }

        @Override
        public final Builder pingStatus(String pingStatus) {
            this.pingStatus = pingStatus;
            return this;
        }

        @Override
        public final Builder pingStatus(PingStatus pingStatus) {
            this.pingStatus(pingStatus.toString());
            return this;
        }

        public final void setPingStatus(String pingStatus) {
            this.pingStatus = pingStatus;
        }

        public final Instant getLastPingDateTime() {
            return this.lastPingDateTime;
        }

        @Override
        public final Builder lastPingDateTime(Instant lastPingDateTime) {
            this.lastPingDateTime = lastPingDateTime;
            return this;
        }

        public final void setLastPingDateTime(Instant lastPingDateTime) {
            this.lastPingDateTime = lastPingDateTime;
        }

        public final String getAgentVersion() {
            return this.agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        public final Boolean getIsLatestVersion() {
            return this.isLatestVersion;
        }

        @Override
        public final Builder isLatestVersion(Boolean isLatestVersion) {
            this.isLatestVersion = isLatestVersion;
            return this;
        }

        public final void setIsLatestVersion(Boolean isLatestVersion) {
            this.isLatestVersion = isLatestVersion;
        }

        public final String getPlatformTypeAsString() {
            return this.platformType;
        }

        @Override
        public final Builder platformType(String platformType) {
            this.platformType = platformType;
            return this;
        }

        @Override
        public final Builder platformType(PlatformType platformType) {
            this.platformType(platformType.toString());
            return this;
        }

        public final void setPlatformType(String platformType) {
            this.platformType = platformType;
        }

        public final String getPlatformName() {
            return this.platformName;
        }

        @Override
        public final Builder platformName(String platformName) {
            this.platformName = platformName;
            return this;
        }

        public final void setPlatformName(String platformName) {
            this.platformName = platformName;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final String getActivationId() {
            return this.activationId;
        }

        @Override
        public final Builder activationId(String activationId) {
            this.activationId = activationId;
            return this;
        }

        public final void setActivationId(String activationId) {
            this.activationId = activationId;
        }

        public final String getIamRole() {
            return this.iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        public final Instant getRegistrationDate() {
            return this.registrationDate;
        }

        @Override
        public final Builder registrationDate(Instant registrationDate) {
            this.registrationDate = registrationDate;
            return this;
        }

        public final void setRegistrationDate(Instant registrationDate) {
            this.registrationDate = registrationDate;
        }

        public final String getResourceTypeAsString() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getComputerName() {
            return this.computerName;
        }

        @Override
        public final Builder computerName(String computerName) {
            this.computerName = computerName;
            return this;
        }

        public final void setComputerName(String computerName) {
            this.computerName = computerName;
        }

        public final String getAssociationStatus() {
            return this.associationStatus;
        }

        @Override
        public final Builder associationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
            return this;
        }

        public final void setAssociationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
        }

        public final Instant getLastAssociationExecutionDate() {
            return this.lastAssociationExecutionDate;
        }

        @Override
        public final Builder lastAssociationExecutionDate(Instant lastAssociationExecutionDate) {
            this.lastAssociationExecutionDate = lastAssociationExecutionDate;
            return this;
        }

        public final void setLastAssociationExecutionDate(Instant lastAssociationExecutionDate) {
            this.lastAssociationExecutionDate = lastAssociationExecutionDate;
        }

        public final Instant getLastSuccessfulAssociationExecutionDate() {
            return this.lastSuccessfulAssociationExecutionDate;
        }

        @Override
        public final Builder lastSuccessfulAssociationExecutionDate(Instant lastSuccessfulAssociationExecutionDate) {
            this.lastSuccessfulAssociationExecutionDate = lastSuccessfulAssociationExecutionDate;
            return this;
        }

        public final void setLastSuccessfulAssociationExecutionDate(Instant lastSuccessfulAssociationExecutionDate) {
            this.lastSuccessfulAssociationExecutionDate = lastSuccessfulAssociationExecutionDate;
        }

        public final InstanceAggregatedAssociationOverview.Builder getAssociationOverview() {
            return this.associationOverview != null ? this.associationOverview.toBuilder() : null;
        }

        @Override
        public final Builder associationOverview(InstanceAggregatedAssociationOverview associationOverview) {
            this.associationOverview = associationOverview;
            return this;
        }

        public final void setAssociationOverview(InstanceAggregatedAssociationOverview.BuilderImpl associationOverview) {
            this.associationOverview = associationOverview != null ? associationOverview.build() : null;
        }

        public InstanceInformation build() {
            return new InstanceInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceInformation> {
        public Builder instanceId(String var1);

        public Builder pingStatus(String var1);

        public Builder pingStatus(PingStatus var1);

        public Builder lastPingDateTime(Instant var1);

        public Builder agentVersion(String var1);

        public Builder isLatestVersion(Boolean var1);

        public Builder platformType(String var1);

        public Builder platformType(PlatformType var1);

        public Builder platformName(String var1);

        public Builder platformVersion(String var1);

        public Builder activationId(String var1);

        public Builder iamRole(String var1);

        public Builder registrationDate(Instant var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder name(String var1);

        public Builder ipAddress(String var1);

        public Builder computerName(String var1);

        public Builder associationStatus(String var1);

        public Builder lastAssociationExecutionDate(Instant var1);

        public Builder lastSuccessfulAssociationExecutionDate(Instant var1);

        public Builder associationOverview(InstanceAggregatedAssociationOverview var1);

        default public Builder associationOverview(Consumer<InstanceAggregatedAssociationOverview.Builder> associationOverview) {
            return this.associationOverview((InstanceAggregatedAssociationOverview)((InstanceAggregatedAssociationOverview.Builder)InstanceAggregatedAssociationOverview.builder().applyMutation(associationOverview)).build());
        }
    }
}

