/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Includes information about the specified association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociationExecution implements SdkPojo, Serializable,
        ToCopyableBuilder<AssociationExecution.Builder, AssociationExecution> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociationExecution::associationId)).setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()).build();

    private static final SdkField<String> ASSOCIATION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociationExecution::associationVersion)).setter(setter(Builder::associationVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationVersion").build())
            .build();

    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociationExecution::executionId)).setter(setter(Builder::executionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociationExecution::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> DETAILED_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociationExecution::detailedStatus)).setter(setter(Builder::detailedStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailedStatus").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(AssociationExecution::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_EXECUTION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(AssociationExecution::lastExecutionDate)).setter(setter(Builder::lastExecutionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastExecutionDate").build()).build();

    private static final SdkField<String> RESOURCE_COUNT_BY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociationExecution::resourceCountByStatus)).setter(setter(Builder::resourceCountByStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCountByStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD,
            ASSOCIATION_VERSION_FIELD, EXECUTION_ID_FIELD, STATUS_FIELD, DETAILED_STATUS_FIELD, CREATED_TIME_FIELD,
            LAST_EXECUTION_DATE_FIELD, RESOURCE_COUNT_BY_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String associationId;

    private final String associationVersion;

    private final String executionId;

    private final String status;

    private final String detailedStatus;

    private final Instant createdTime;

    private final Instant lastExecutionDate;

    private final String resourceCountByStatus;

    private AssociationExecution(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.associationVersion = builder.associationVersion;
        this.executionId = builder.executionId;
        this.status = builder.status;
        this.detailedStatus = builder.detailedStatus;
        this.createdTime = builder.createdTime;
        this.lastExecutionDate = builder.lastExecutionDate;
        this.resourceCountByStatus = builder.resourceCountByStatus;
    }

    /**
     * <p>
     * The association ID.
     * </p>
     * 
     * @return The association ID.
     */
    public String associationId() {
        return associationId;
    }

    /**
     * <p>
     * The association version.
     * </p>
     * 
     * @return The association version.
     */
    public String associationVersion() {
        return associationVersion;
    }

    /**
     * <p>
     * The execution ID for the association.
     * </p>
     * 
     * @return The execution ID for the association.
     */
    public String executionId() {
        return executionId;
    }

    /**
     * <p>
     * The status of the association execution.
     * </p>
     * 
     * @return The status of the association execution.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * Detailed status information about the execution.
     * </p>
     * 
     * @return Detailed status information about the execution.
     */
    public String detailedStatus() {
        return detailedStatus;
    }

    /**
     * <p>
     * The time the execution started.
     * </p>
     * 
     * @return The time the execution started.
     */
    public Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The date of the last execution.
     * </p>
     * 
     * @return The date of the last execution.
     */
    public Instant lastExecutionDate() {
        return lastExecutionDate;
    }

    /**
     * <p>
     * An aggregate status of the resources in the execution based on the status type.
     * </p>
     * 
     * @return An aggregate status of the resources in the execution based on the status type.
     */
    public String resourceCountByStatus() {
        return resourceCountByStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(associationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(detailedStatus());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastExecutionDate());
        hashCode = 31 * hashCode + Objects.hashCode(resourceCountByStatus());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationExecution)) {
            return false;
        }
        AssociationExecution other = (AssociationExecution) obj;
        return Objects.equals(associationId(), other.associationId())
                && Objects.equals(associationVersion(), other.associationVersion())
                && Objects.equals(executionId(), other.executionId()) && Objects.equals(status(), other.status())
                && Objects.equals(detailedStatus(), other.detailedStatus()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastExecutionDate(), other.lastExecutionDate())
                && Objects.equals(resourceCountByStatus(), other.resourceCountByStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AssociationExecution").add("AssociationId", associationId())
                .add("AssociationVersion", associationVersion()).add("ExecutionId", executionId()).add("Status", status())
                .add("DetailedStatus", detailedStatus()).add("CreatedTime", createdTime())
                .add("LastExecutionDate", lastExecutionDate()).add("ResourceCountByStatus", resourceCountByStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "AssociationVersion":
            return Optional.ofNullable(clazz.cast(associationVersion()));
        case "ExecutionId":
            return Optional.ofNullable(clazz.cast(executionId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "DetailedStatus":
            return Optional.ofNullable(clazz.cast(detailedStatus()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastExecutionDate":
            return Optional.ofNullable(clazz.cast(lastExecutionDate()));
        case "ResourceCountByStatus":
            return Optional.ofNullable(clazz.cast(resourceCountByStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociationExecution, T> g) {
        return obj -> g.apply((AssociationExecution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssociationExecution> {
        /**
         * <p>
         * The association ID.
         * </p>
         * 
         * @param associationId
         *        The association ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The association version.
         * </p>
         * 
         * @param associationVersion
         *        The association version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationVersion(String associationVersion);

        /**
         * <p>
         * The execution ID for the association.
         * </p>
         * 
         * @param executionId
         *        The execution ID for the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        /**
         * <p>
         * The status of the association execution.
         * </p>
         * 
         * @param status
         *        The status of the association execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Detailed status information about the execution.
         * </p>
         * 
         * @param detailedStatus
         *        Detailed status information about the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detailedStatus(String detailedStatus);

        /**
         * <p>
         * The time the execution started.
         * </p>
         * 
         * @param createdTime
         *        The time the execution started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The date of the last execution.
         * </p>
         * 
         * @param lastExecutionDate
         *        The date of the last execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastExecutionDate(Instant lastExecutionDate);

        /**
         * <p>
         * An aggregate status of the resources in the execution based on the status type.
         * </p>
         * 
         * @param resourceCountByStatus
         *        An aggregate status of the resources in the execution based on the status type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCountByStatus(String resourceCountByStatus);
    }

    static final class BuilderImpl implements Builder {
        private String associationId;

        private String associationVersion;

        private String executionId;

        private String status;

        private String detailedStatus;

        private Instant createdTime;

        private Instant lastExecutionDate;

        private String resourceCountByStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationExecution model) {
            associationId(model.associationId);
            associationVersion(model.associationVersion);
            executionId(model.executionId);
            status(model.status);
            detailedStatus(model.detailedStatus);
            createdTime(model.createdTime);
            lastExecutionDate(model.lastExecutionDate);
            resourceCountByStatus(model.resourceCountByStatus);
        }

        public final String getAssociationId() {
            return associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getAssociationVersion() {
            return associationVersion;
        }

        @Override
        public final Builder associationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
            return this;
        }

        public final void setAssociationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
        }

        public final String getExecutionId() {
            return executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getDetailedStatus() {
            return detailedStatus;
        }

        @Override
        public final Builder detailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
            return this;
        }

        public final void setDetailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Instant getLastExecutionDate() {
            return lastExecutionDate;
        }

        @Override
        public final Builder lastExecutionDate(Instant lastExecutionDate) {
            this.lastExecutionDate = lastExecutionDate;
            return this;
        }

        public final void setLastExecutionDate(Instant lastExecutionDate) {
            this.lastExecutionDate = lastExecutionDate;
        }

        public final String getResourceCountByStatus() {
            return resourceCountByStatus;
        }

        @Override
        public final Builder resourceCountByStatus(String resourceCountByStatus) {
            this.resourceCountByStatus = resourceCountByStatus;
            return this;
        }

        public final void setResourceCountByStatus(String resourceCountByStatus) {
            this.resourceCountByStatus = resourceCountByStatus;
        }

        @Override
        public AssociationExecution build() {
            return new AssociationExecution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
