/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The stages that an escalation plan or engagement plan engages contacts and contact methods in.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Plan implements SdkPojo, Serializable, ToCopyableBuilder<Plan.Builder, Plan> {
    private static final SdkField<List<Stage>> STAGES_FIELD = SdkField
            .<List<Stage>> builder(MarshallingType.LIST)
            .memberName("Stages")
            .getter(getter(Plan::stages))
            .setter(setter(Builder::stages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Stage> builder(MarshallingType.SDK_POJO)
                                            .constructor(Stage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Stage> stages;

    private Plan(BuilderImpl builder) {
        this.stages = builder.stages;
    }

    /**
     * Returns true if the Stages property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasStages() {
        return stages != null && !(stages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStages()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods.
     */
    public final List<Stage> stages() {
        return stages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStages() ? stages() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Plan)) {
            return false;
        }
        Plan other = (Plan) obj;
        return hasStages() == other.hasStages() && Objects.equals(stages(), other.stages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Plan").add("Stages", hasStages() ? stages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Stages":
            return Optional.ofNullable(clazz.cast(stages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Plan, T> g) {
        return obj -> g.apply((Plan) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Plan> {
        /**
         * <p>
         * A list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods.
         * </p>
         * 
         * @param stages
         *        A list of stages that the escalation plan or engagement plan uses to engage contacts and contact
         *        methods.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stages(Collection<Stage> stages);

        /**
         * <p>
         * A list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods.
         * </p>
         * 
         * @param stages
         *        A list of stages that the escalation plan or engagement plan uses to engage contacts and contact
         *        methods.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stages(Stage... stages);

        /**
         * <p>
         * A list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Stage>.Builder} avoiding the need to create
         * one manually via {@link List<Stage>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Stage>.Builder#build()} is called immediately and its result
         * is passed to {@link #stages(List<Stage>)}.
         * 
         * @param stages
         *        a consumer that will call methods on {@link List<Stage>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stages(List<Stage>)
         */
        Builder stages(Consumer<Stage.Builder>... stages);
    }

    static final class BuilderImpl implements Builder {
        private List<Stage> stages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Plan model) {
            stages(model.stages);
        }

        public final List<Stage.Builder> getStages() {
            List<Stage.Builder> result = StagesListCopier.copyToBuilder(this.stages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder stages(Collection<Stage> stages) {
            this.stages = StagesListCopier.copy(stages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stages(Stage... stages) {
            stages(Arrays.asList(stages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stages(Consumer<Stage.Builder>... stages) {
            stages(Stream.of(stages).map(c -> Stage.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStages(Collection<Stage.BuilderImpl> stages) {
            this.stages = StagesListCopier.copyFromBuilder(stages);
        }

        @Override
        public Plan build() {
            return new Plan(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
