/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The contact or contact channel that is being engaged.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Target implements SdkPojo, Serializable, ToCopyableBuilder<Target.Builder, Target> {
    private static final SdkField<ChannelTargetInfo> CHANNEL_TARGET_INFO_FIELD = SdkField
            .<ChannelTargetInfo> builder(MarshallingType.SDK_POJO).memberName("ChannelTargetInfo")
            .getter(getter(Target::channelTargetInfo)).setter(setter(Builder::channelTargetInfo))
            .constructor(ChannelTargetInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelTargetInfo").build()).build();

    private static final SdkField<ContactTargetInfo> CONTACT_TARGET_INFO_FIELD = SdkField
            .<ContactTargetInfo> builder(MarshallingType.SDK_POJO).memberName("ContactTargetInfo")
            .getter(getter(Target::contactTargetInfo)).setter(setter(Builder::contactTargetInfo))
            .constructor(ContactTargetInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactTargetInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_TARGET_INFO_FIELD,
            CONTACT_TARGET_INFO_FIELD));

    private static final long serialVersionUID = 1L;

    private final ChannelTargetInfo channelTargetInfo;

    private final ContactTargetInfo contactTargetInfo;

    private Target(BuilderImpl builder) {
        this.channelTargetInfo = builder.channelTargetInfo;
        this.contactTargetInfo = builder.contactTargetInfo;
    }

    /**
     * <p>
     * Information about the contact channel Incident Manager is engaging.
     * </p>
     * 
     * @return Information about the contact channel Incident Manager is engaging.
     */
    public final ChannelTargetInfo channelTargetInfo() {
        return channelTargetInfo;
    }

    /**
     * <p>
     * Information about the contact that Incident Manager is engaging.
     * </p>
     * 
     * @return Information about the contact that Incident Manager is engaging.
     */
    public final ContactTargetInfo contactTargetInfo() {
        return contactTargetInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelTargetInfo());
        hashCode = 31 * hashCode + Objects.hashCode(contactTargetInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Target)) {
            return false;
        }
        Target other = (Target) obj;
        return Objects.equals(channelTargetInfo(), other.channelTargetInfo())
                && Objects.equals(contactTargetInfo(), other.contactTargetInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Target").add("ChannelTargetInfo", channelTargetInfo())
                .add("ContactTargetInfo", contactTargetInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelTargetInfo":
            return Optional.ofNullable(clazz.cast(channelTargetInfo()));
        case "ContactTargetInfo":
            return Optional.ofNullable(clazz.cast(contactTargetInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Target, T> g) {
        return obj -> g.apply((Target) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Target> {
        /**
         * <p>
         * Information about the contact channel Incident Manager is engaging.
         * </p>
         * 
         * @param channelTargetInfo
         *        Information about the contact channel Incident Manager is engaging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelTargetInfo(ChannelTargetInfo channelTargetInfo);

        /**
         * <p>
         * Information about the contact channel Incident Manager is engaging.
         * </p>
         * This is a convenience that creates an instance of the {@link ChannelTargetInfo.Builder} avoiding the need to
         * create one manually via {@link ChannelTargetInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ChannelTargetInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #channelTargetInfo(ChannelTargetInfo)}.
         * 
         * @param channelTargetInfo
         *        a consumer that will call methods on {@link ChannelTargetInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelTargetInfo(ChannelTargetInfo)
         */
        default Builder channelTargetInfo(Consumer<ChannelTargetInfo.Builder> channelTargetInfo) {
            return channelTargetInfo(ChannelTargetInfo.builder().applyMutation(channelTargetInfo).build());
        }

        /**
         * <p>
         * Information about the contact that Incident Manager is engaging.
         * </p>
         * 
         * @param contactTargetInfo
         *        Information about the contact that Incident Manager is engaging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactTargetInfo(ContactTargetInfo contactTargetInfo);

        /**
         * <p>
         * Information about the contact that Incident Manager is engaging.
         * </p>
         * This is a convenience that creates an instance of the {@link ContactTargetInfo.Builder} avoiding the need to
         * create one manually via {@link ContactTargetInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContactTargetInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #contactTargetInfo(ContactTargetInfo)}.
         * 
         * @param contactTargetInfo
         *        a consumer that will call methods on {@link ContactTargetInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contactTargetInfo(ContactTargetInfo)
         */
        default Builder contactTargetInfo(Consumer<ContactTargetInfo.Builder> contactTargetInfo) {
            return contactTargetInfo(ContactTargetInfo.builder().applyMutation(contactTargetInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ChannelTargetInfo channelTargetInfo;

        private ContactTargetInfo contactTargetInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(Target model) {
            channelTargetInfo(model.channelTargetInfo);
            contactTargetInfo(model.contactTargetInfo);
        }

        public final ChannelTargetInfo.Builder getChannelTargetInfo() {
            return channelTargetInfo != null ? channelTargetInfo.toBuilder() : null;
        }

        @Override
        public final Builder channelTargetInfo(ChannelTargetInfo channelTargetInfo) {
            this.channelTargetInfo = channelTargetInfo;
            return this;
        }

        public final void setChannelTargetInfo(ChannelTargetInfo.BuilderImpl channelTargetInfo) {
            this.channelTargetInfo = channelTargetInfo != null ? channelTargetInfo.build() : null;
        }

        public final ContactTargetInfo.Builder getContactTargetInfo() {
            return contactTargetInfo != null ? contactTargetInfo.toBuilder() : null;
        }

        @Override
        public final Builder contactTargetInfo(ContactTargetInfo contactTargetInfo) {
            this.contactTargetInfo = contactTargetInfo;
            return this;
        }

        public final void setContactTargetInfo(ContactTargetInfo.BuilderImpl contactTargetInfo) {
            this.contactTargetInfo = contactTargetInfo != null ? contactTargetInfo.build() : null;
        }

        @Override
        public Target build() {
            return new Target(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
