/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the contact channel that Incident Manager uses to engage the contact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChannelTargetInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<ChannelTargetInfo.Builder, ChannelTargetInfo> {
    private static final SdkField<String> CONTACT_CHANNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactChannelId").getter(getter(ChannelTargetInfo::contactChannelId))
            .setter(setter(Builder::contactChannelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactChannelId").build()).build();

    private static final SdkField<Integer> RETRY_INTERVAL_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RetryIntervalInMinutes").getter(getter(ChannelTargetInfo::retryIntervalInMinutes))
            .setter(setter(Builder::retryIntervalInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryIntervalInMinutes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_CHANNEL_ID_FIELD,
            RETRY_INTERVAL_IN_MINUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String contactChannelId;

    private final Integer retryIntervalInMinutes;

    private ChannelTargetInfo(BuilderImpl builder) {
        this.contactChannelId = builder.contactChannelId;
        this.retryIntervalInMinutes = builder.retryIntervalInMinutes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the contact channel.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the contact channel.
     */
    public final String contactChannelId() {
        return contactChannelId;
    }

    /**
     * <p>
     * The number of minutes to wait to retry sending engagement in the case the engagement initially fails.
     * </p>
     * 
     * @return The number of minutes to wait to retry sending engagement in the case the engagement initially fails.
     */
    public final Integer retryIntervalInMinutes() {
        return retryIntervalInMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contactChannelId());
        hashCode = 31 * hashCode + Objects.hashCode(retryIntervalInMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelTargetInfo)) {
            return false;
        }
        ChannelTargetInfo other = (ChannelTargetInfo) obj;
        return Objects.equals(contactChannelId(), other.contactChannelId())
                && Objects.equals(retryIntervalInMinutes(), other.retryIntervalInMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChannelTargetInfo").add("ContactChannelId", contactChannelId())
                .add("RetryIntervalInMinutes", retryIntervalInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactChannelId":
            return Optional.ofNullable(clazz.cast(contactChannelId()));
        case "RetryIntervalInMinutes":
            return Optional.ofNullable(clazz.cast(retryIntervalInMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChannelTargetInfo, T> g) {
        return obj -> g.apply((ChannelTargetInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChannelTargetInfo> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the contact channel.
         * </p>
         * 
         * @param contactChannelId
         *        The Amazon Resource Name (ARN) of the contact channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactChannelId(String contactChannelId);

        /**
         * <p>
         * The number of minutes to wait to retry sending engagement in the case the engagement initially fails.
         * </p>
         * 
         * @param retryIntervalInMinutes
         *        The number of minutes to wait to retry sending engagement in the case the engagement initially fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryIntervalInMinutes(Integer retryIntervalInMinutes);
    }

    static final class BuilderImpl implements Builder {
        private String contactChannelId;

        private Integer retryIntervalInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelTargetInfo model) {
            contactChannelId(model.contactChannelId);
            retryIntervalInMinutes(model.retryIntervalInMinutes);
        }

        public final String getContactChannelId() {
            return contactChannelId;
        }

        @Override
        public final Builder contactChannelId(String contactChannelId) {
            this.contactChannelId = contactChannelId;
            return this;
        }

        public final void setContactChannelId(String contactChannelId) {
            this.contactChannelId = contactChannelId;
        }

        public final Integer getRetryIntervalInMinutes() {
            return retryIntervalInMinutes;
        }

        @Override
        public final Builder retryIntervalInMinutes(Integer retryIntervalInMinutes) {
            this.retryIntervalInMinutes = retryIntervalInMinutes;
            return this;
        }

        public final void setRetryIntervalInMinutes(Integer retryIntervalInMinutes) {
            this.retryIntervalInMinutes = retryIntervalInMinutes;
        }

        @Override
        public ChannelTargetInfo build() {
            return new ChannelTargetInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
