/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListContactsRequest extends SsmContactsRequest implements
        ToCopyableBuilder<ListContactsRequest.Builder, ListContactsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListContactsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListContactsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> ALIAS_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AliasPrefix").getter(getter(ListContactsRequest::aliasPrefix)).setter(setter(Builder::aliasPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasPrefix").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ListContactsRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, ALIAS_PREFIX_FIELD, TYPE_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final String aliasPrefix;

    private final String type;

    private ListContactsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.aliasPrefix = builder.aliasPrefix;
        this.type = builder.type;
    }

    /**
     * <p>
     * The pagination token to continue to the next page of results.
     * </p>
     * 
     * @return The pagination token to continue to the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of contacts and escalation plans per page of results.
     * </p>
     * 
     * @return The maximum number of contacts and escalation plans per page of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Used to list only contacts who's aliases start with the specified prefix.
     * </p>
     * 
     * @return Used to list only contacts who's aliases start with the specified prefix.
     */
    public final String aliasPrefix() {
        return aliasPrefix;
    }

    /**
     * <p>
     * The type of contact. A contact is type <code>PERSONAL</code> and an escalation plan is type
     * <code>ESCALATION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ContactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of contact. A contact is type <code>PERSONAL</code> and an escalation plan is type
     *         <code>ESCALATION</code>.
     * @see ContactType
     */
    public final ContactType type() {
        return ContactType.fromValue(type);
    }

    /**
     * <p>
     * The type of contact. A contact is type <code>PERSONAL</code> and an escalation plan is type
     * <code>ESCALATION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ContactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of contact. A contact is type <code>PERSONAL</code> and an escalation plan is type
     *         <code>ESCALATION</code>.
     * @see ContactType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(aliasPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContactsRequest)) {
            return false;
        }
        ListContactsRequest other = (ListContactsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(aliasPrefix(), other.aliasPrefix()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListContactsRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("AliasPrefix", aliasPrefix()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "AliasPrefix":
            return Optional.ofNullable(clazz.cast(aliasPrefix()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListContactsRequest, T> g) {
        return obj -> g.apply((ListContactsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmContactsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListContactsRequest> {
        /**
         * <p>
         * The pagination token to continue to the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to continue to the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of contacts and escalation plans per page of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of contacts and escalation plans per page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Used to list only contacts who's aliases start with the specified prefix.
         * </p>
         * 
         * @param aliasPrefix
         *        Used to list only contacts who's aliases start with the specified prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasPrefix(String aliasPrefix);

        /**
         * <p>
         * The type of contact. A contact is type <code>PERSONAL</code> and an escalation plan is type
         * <code>ESCALATION</code>.
         * </p>
         * 
         * @param type
         *        The type of contact. A contact is type <code>PERSONAL</code> and an escalation plan is type
         *        <code>ESCALATION</code>.
         * @see ContactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of contact. A contact is type <code>PERSONAL</code> and an escalation plan is type
         * <code>ESCALATION</code>.
         * </p>
         * 
         * @param type
         *        The type of contact. A contact is type <code>PERSONAL</code> and an escalation plan is type
         *        <code>ESCALATION</code>.
         * @see ContactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactType
         */
        Builder type(ContactType type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmContactsRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String aliasPrefix;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContactsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            aliasPrefix(model.aliasPrefix);
            type(model.type);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getAliasPrefix() {
            return aliasPrefix;
        }

        public final void setAliasPrefix(String aliasPrefix) {
            this.aliasPrefix = aliasPrefix;
        }

        @Override
        @Transient
        public final Builder aliasPrefix(String aliasPrefix) {
            this.aliasPrefix = aliasPrefix;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(ContactType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListContactsRequest build() {
            return new ListContactsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
