/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateContactChannelRequest extends SsmContactsRequest implements
        ToCopyableBuilder<CreateContactChannelRequest.Builder, CreateContactChannelRequest> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactId").getter(getter(CreateContactChannelRequest::contactId)).setter(setter(Builder::contactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateContactChannelRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(CreateContactChannelRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<ContactChannelAddress> DELIVERY_ADDRESS_FIELD = SdkField
            .<ContactChannelAddress> builder(MarshallingType.SDK_POJO).memberName("DeliveryAddress")
            .getter(getter(CreateContactChannelRequest::deliveryAddress)).setter(setter(Builder::deliveryAddress))
            .constructor(ContactChannelAddress::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryAddress").build()).build();

    private static final SdkField<Boolean> DEFER_ACTIVATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeferActivation").getter(getter(CreateContactChannelRequest::deferActivation))
            .setter(setter(Builder::deferActivation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeferActivation").build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IdempotencyToken")
            .getter(getter(CreateContactChannelRequest::idempotencyToken))
            .setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD, NAME_FIELD,
            TYPE_FIELD, DELIVERY_ADDRESS_FIELD, DEFER_ACTIVATION_FIELD, IDEMPOTENCY_TOKEN_FIELD));

    private final String contactId;

    private final String name;

    private final String type;

    private final ContactChannelAddress deliveryAddress;

    private final Boolean deferActivation;

    private final String idempotencyToken;

    private CreateContactChannelRequest(BuilderImpl builder) {
        super(builder);
        this.contactId = builder.contactId;
        this.name = builder.name;
        this.type = builder.type;
        this.deliveryAddress = builder.deliveryAddress;
        this.deferActivation = builder.deferActivation;
        this.idempotencyToken = builder.idempotencyToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the contact you are adding the contact channel to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the contact you are adding the contact channel to.
     */
    public final String contactId() {
        return contactId;
    }

    /**
     * <p>
     * The name of the contact channel.
     * </p>
     * 
     * @return The name of the contact channel.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Incident Manager supports three types of contact channels:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SMS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VOICE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EMAIL</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Incident Manager supports three types of contact channels:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SMS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VOICE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EMAIL</code>
     *         </p>
     *         </li>
     * @see ChannelType
     */
    public final ChannelType type() {
        return ChannelType.fromValue(type);
    }

    /**
     * <p>
     * Incident Manager supports three types of contact channels:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SMS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VOICE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EMAIL</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Incident Manager supports three types of contact channels:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SMS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VOICE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EMAIL</code>
     *         </p>
     *         </li>
     * @see ChannelType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The details that Incident Manager uses when trying to engage the contact channel. The format is dependent on the
     * type of the contact channel. The following are the expected formats:
     * </p>
     * <ul>
     * <li>
     * <p>
     * SMS - '+' followed by the country code and phone number
     * </p>
     * </li>
     * <li>
     * <p>
     * VOICE - '+' followed by the country code and phone number
     * </p>
     * </li>
     * <li>
     * <p>
     * EMAIL - any standard email format
     * </p>
     * </li>
     * </ul>
     * 
     * @return The details that Incident Manager uses when trying to engage the contact channel. The format is dependent
     *         on the type of the contact channel. The following are the expected formats:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         SMS - '+' followed by the country code and phone number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         VOICE - '+' followed by the country code and phone number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMAIL - any standard email format
     *         </p>
     *         </li>
     */
    public final ContactChannelAddress deliveryAddress() {
        return deliveryAddress;
    }

    /**
     * <p>
     * If you want to activate the channel at a later time, you can choose to defer activation. Incident Manager can't
     * engage your contact channel until it has been activated.
     * </p>
     * 
     * @return If you want to activate the channel at a later time, you can choose to defer activation. Incident Manager
     *         can't engage your contact channel until it has been activated.
     */
    public final Boolean deferActivation() {
        return deferActivation;
    }

    /**
     * <p>
     * A token ensuring that the operation is called only once with the specified details.
     * </p>
     * 
     * @return A token ensuring that the operation is called only once with the specified details.
     */
    public final String idempotencyToken() {
        return idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contactId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryAddress());
        hashCode = 31 * hashCode + Objects.hashCode(deferActivation());
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContactChannelRequest)) {
            return false;
        }
        CreateContactChannelRequest other = (CreateContactChannelRequest) obj;
        return Objects.equals(contactId(), other.contactId()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(deliveryAddress(), other.deliveryAddress())
                && Objects.equals(deferActivation(), other.deferActivation())
                && Objects.equals(idempotencyToken(), other.idempotencyToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateContactChannelRequest").add("ContactId", contactId()).add("Name", name())
                .add("Type", typeAsString()).add("DeliveryAddress", deliveryAddress()).add("DeferActivation", deferActivation())
                .add("IdempotencyToken", idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactId":
            return Optional.ofNullable(clazz.cast(contactId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "DeliveryAddress":
            return Optional.ofNullable(clazz.cast(deliveryAddress()));
        case "DeferActivation":
            return Optional.ofNullable(clazz.cast(deferActivation()));
        case "IdempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateContactChannelRequest, T> g) {
        return obj -> g.apply((CreateContactChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmContactsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateContactChannelRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the contact you are adding the contact channel to.
         * </p>
         * 
         * @param contactId
         *        The Amazon Resource Name (ARN) of the contact you are adding the contact channel to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactId(String contactId);

        /**
         * <p>
         * The name of the contact channel.
         * </p>
         * 
         * @param name
         *        The name of the contact channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Incident Manager supports three types of contact channels:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SMS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VOICE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EMAIL</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        Incident Manager supports three types of contact channels:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SMS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VOICE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EMAIL</code>
         *        </p>
         *        </li>
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder type(String type);

        /**
         * <p>
         * Incident Manager supports three types of contact channels:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SMS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VOICE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EMAIL</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        Incident Manager supports three types of contact channels:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SMS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VOICE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EMAIL</code>
         *        </p>
         *        </li>
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder type(ChannelType type);

        /**
         * <p>
         * The details that Incident Manager uses when trying to engage the contact channel. The format is dependent on
         * the type of the contact channel. The following are the expected formats:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SMS - '+' followed by the country code and phone number
         * </p>
         * </li>
         * <li>
         * <p>
         * VOICE - '+' followed by the country code and phone number
         * </p>
         * </li>
         * <li>
         * <p>
         * EMAIL - any standard email format
         * </p>
         * </li>
         * </ul>
         * 
         * @param deliveryAddress
         *        The details that Incident Manager uses when trying to engage the contact channel. The format is
         *        dependent on the type of the contact channel. The following are the expected formats:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        SMS - '+' followed by the country code and phone number
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        VOICE - '+' followed by the country code and phone number
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EMAIL - any standard email format
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryAddress(ContactChannelAddress deliveryAddress);

        /**
         * <p>
         * The details that Incident Manager uses when trying to engage the contact channel. The format is dependent on
         * the type of the contact channel. The following are the expected formats:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SMS - '+' followed by the country code and phone number
         * </p>
         * </li>
         * <li>
         * <p>
         * VOICE - '+' followed by the country code and phone number
         * </p>
         * </li>
         * <li>
         * <p>
         * EMAIL - any standard email format
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link ContactChannelAddress.Builder} avoiding
         * the need to create one manually via {@link ContactChannelAddress#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContactChannelAddress.Builder#build()} is called immediately and
         * its result is passed to {@link #deliveryAddress(ContactChannelAddress)}.
         * 
         * @param deliveryAddress
         *        a consumer that will call methods on {@link ContactChannelAddress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deliveryAddress(ContactChannelAddress)
         */
        default Builder deliveryAddress(Consumer<ContactChannelAddress.Builder> deliveryAddress) {
            return deliveryAddress(ContactChannelAddress.builder().applyMutation(deliveryAddress).build());
        }

        /**
         * <p>
         * If you want to activate the channel at a later time, you can choose to defer activation. Incident Manager
         * can't engage your contact channel until it has been activated.
         * </p>
         * 
         * @param deferActivation
         *        If you want to activate the channel at a later time, you can choose to defer activation. Incident
         *        Manager can't engage your contact channel until it has been activated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deferActivation(Boolean deferActivation);

        /**
         * <p>
         * A token ensuring that the operation is called only once with the specified details.
         * </p>
         * 
         * @param idempotencyToken
         *        A token ensuring that the operation is called only once with the specified details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmContactsRequest.BuilderImpl implements Builder {
        private String contactId;

        private String name;

        private String type;

        private ContactChannelAddress deliveryAddress;

        private Boolean deferActivation;

        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContactChannelRequest model) {
            super(model);
            contactId(model.contactId);
            name(model.name);
            type(model.type);
            deliveryAddress(model.deliveryAddress);
            deferActivation(model.deferActivation);
            idempotencyToken(model.idempotencyToken);
        }

        public final String getContactId() {
            return contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChannelType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final ContactChannelAddress.Builder getDeliveryAddress() {
            return deliveryAddress != null ? deliveryAddress.toBuilder() : null;
        }

        public final void setDeliveryAddress(ContactChannelAddress.BuilderImpl deliveryAddress) {
            this.deliveryAddress = deliveryAddress != null ? deliveryAddress.build() : null;
        }

        @Override
        public final Builder deliveryAddress(ContactChannelAddress deliveryAddress) {
            this.deliveryAddress = deliveryAddress;
            return this;
        }

        public final Boolean getDeferActivation() {
            return deferActivation;
        }

        public final void setDeferActivation(Boolean deferActivation) {
            this.deferActivation = deferActivation;
        }

        @Override
        public final Builder deferActivation(Boolean deferActivation) {
            this.deferActivation = deferActivation;
            return this;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateContactChannelRequest build() {
            return new CreateContactChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
