/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListContactChannelsResponse extends SsmContactsResponse implements
        ToCopyableBuilder<ListContactChannelsResponse.Builder, ListContactChannelsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListContactChannelsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ContactChannel>> CONTACT_CHANNELS_FIELD = SdkField
            .<List<ContactChannel>> builder(MarshallingType.LIST)
            .memberName("ContactChannels")
            .getter(getter(ListContactChannelsResponse::contactChannels))
            .setter(setter(Builder::contactChannels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactChannels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContactChannel> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContactChannel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            CONTACT_CHANNELS_FIELD));

    private final String nextToken;

    private final List<ContactChannel> contactChannels;

    private ListContactChannelsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.contactChannels = builder.contactChannels;
    }

    /**
     * <p>
     * The pagination token to continue to the next page of results.
     * </p>
     * 
     * @return The pagination token to continue to the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContactChannels property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContactChannels() {
        return contactChannels != null && !(contactChannels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of contact channels related to the specified contact.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContactChannels} method.
     * </p>
     * 
     * @return A list of contact channels related to the specified contact.
     */
    public final List<ContactChannel> contactChannels() {
        return contactChannels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasContactChannels() ? contactChannels() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContactChannelsResponse)) {
            return false;
        }
        ListContactChannelsResponse other = (ListContactChannelsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasContactChannels() == other.hasContactChannels()
                && Objects.equals(contactChannels(), other.contactChannels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListContactChannelsResponse").add("NextToken", nextToken())
                .add("ContactChannels", hasContactChannels() ? contactChannels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ContactChannels":
            return Optional.ofNullable(clazz.cast(contactChannels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListContactChannelsResponse, T> g) {
        return obj -> g.apply((ListContactChannelsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmContactsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListContactChannelsResponse> {
        /**
         * <p>
         * The pagination token to continue to the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to continue to the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of contact channels related to the specified contact.
         * </p>
         * 
         * @param contactChannels
         *        A list of contact channels related to the specified contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactChannels(Collection<ContactChannel> contactChannels);

        /**
         * <p>
         * A list of contact channels related to the specified contact.
         * </p>
         * 
         * @param contactChannels
         *        A list of contact channels related to the specified contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactChannels(ContactChannel... contactChannels);

        /**
         * <p>
         * A list of contact channels related to the specified contact.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ContactChannel>.Builder} avoiding
         * the need to create one manually via {@link List<ContactChannel>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ContactChannel>.Builder#build()} is called immediately and
         * its result is passed to {@link #contactChannels(List<ContactChannel>)}.
         * 
         * @param contactChannels
         *        a consumer that will call methods on {@link List<ContactChannel>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contactChannels(List<ContactChannel>)
         */
        Builder contactChannels(Consumer<ContactChannel.Builder>... contactChannels);
    }

    static final class BuilderImpl extends SsmContactsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ContactChannel> contactChannels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListContactChannelsResponse model) {
            super(model);
            nextToken(model.nextToken);
            contactChannels(model.contactChannels);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ContactChannel.Builder> getContactChannels() {
            List<ContactChannel.Builder> result = ContactChannelListCopier.copyToBuilder(this.contactChannels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContactChannels(Collection<ContactChannel.BuilderImpl> contactChannels) {
            this.contactChannels = ContactChannelListCopier.copyFromBuilder(contactChannels);
        }

        @Override
        public final Builder contactChannels(Collection<ContactChannel> contactChannels) {
            this.contactChannels = ContactChannelListCopier.copy(contactChannels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactChannels(ContactChannel... contactChannels) {
            contactChannels(Arrays.asList(contactChannels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactChannels(Consumer<ContactChannel.Builder>... contactChannels) {
            contactChannels(Stream.of(contactChannels).map(c -> ContactChannel.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListContactChannelsResponse build() {
            return new ListContactChannelsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
