/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEngagementsRequest extends SsmContactsRequest implements
        ToCopyableBuilder<ListEngagementsRequest.Builder, ListEngagementsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEngagementsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListEngagementsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> INCIDENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IncidentId").getter(getter(ListEngagementsRequest::incidentId)).setter(setter(Builder::incidentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncidentId").build()).build();

    private static final SdkField<TimeRange> TIME_RANGE_VALUE_FIELD = SdkField.<TimeRange> builder(MarshallingType.SDK_POJO)
            .memberName("TimeRangeValue").getter(getter(ListEngagementsRequest::timeRangeValue))
            .setter(setter(Builder::timeRangeValue)).constructor(TimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRangeValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, INCIDENT_ID_FIELD, TIME_RANGE_VALUE_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final String incidentId;

    private final TimeRange timeRangeValue;

    private ListEngagementsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.incidentId = builder.incidentId;
        this.timeRangeValue = builder.timeRangeValue;
    }

    /**
     * <p>
     * The pagination token to continue to the next page of results.
     * </p>
     * 
     * @return The pagination token to continue to the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of engagements per page of results.
     * </p>
     * 
     * @return The maximum number of engagements per page of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the incident you're listing engagements for.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the incident you're listing engagements for.
     */
    public final String incidentId() {
        return incidentId;
    }

    /**
     * <p>
     * The time range to lists engagements for an incident.
     * </p>
     * 
     * @return The time range to lists engagements for an incident.
     */
    public final TimeRange timeRangeValue() {
        return timeRangeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(incidentId());
        hashCode = 31 * hashCode + Objects.hashCode(timeRangeValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEngagementsRequest)) {
            return false;
        }
        ListEngagementsRequest other = (ListEngagementsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(incidentId(), other.incidentId()) && Objects.equals(timeRangeValue(), other.timeRangeValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEngagementsRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("IncidentId", incidentId()).add("TimeRangeValue", timeRangeValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "IncidentId":
            return Optional.ofNullable(clazz.cast(incidentId()));
        case "TimeRangeValue":
            return Optional.ofNullable(clazz.cast(timeRangeValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEngagementsRequest, T> g) {
        return obj -> g.apply((ListEngagementsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmContactsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListEngagementsRequest> {
        /**
         * <p>
         * The pagination token to continue to the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to continue to the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of engagements per page of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of engagements per page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the incident you're listing engagements for.
         * </p>
         * 
         * @param incidentId
         *        The Amazon Resource Name (ARN) of the incident you're listing engagements for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incidentId(String incidentId);

        /**
         * <p>
         * The time range to lists engagements for an incident.
         * </p>
         * 
         * @param timeRangeValue
         *        The time range to lists engagements for an incident.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeRangeValue(TimeRange timeRangeValue);

        /**
         * <p>
         * The time range to lists engagements for an incident.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeRange.Builder} avoiding the need to
         * create one manually via {@link TimeRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimeRange.Builder#build()} is called immediately and its result
         * is passed to {@link #timeRangeValue(TimeRange)}.
         * 
         * @param timeRangeValue
         *        a consumer that will call methods on {@link TimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeRangeValue(TimeRange)
         */
        default Builder timeRangeValue(Consumer<TimeRange.Builder> timeRangeValue) {
            return timeRangeValue(TimeRange.builder().applyMutation(timeRangeValue).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmContactsRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String incidentId;

        private TimeRange timeRangeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEngagementsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            incidentId(model.incidentId);
            timeRangeValue(model.timeRangeValue);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getIncidentId() {
            return incidentId;
        }

        public final void setIncidentId(String incidentId) {
            this.incidentId = incidentId;
        }

        @Override
        public final Builder incidentId(String incidentId) {
            this.incidentId = incidentId;
            return this;
        }

        public final TimeRange.Builder getTimeRangeValue() {
            return timeRangeValue != null ? timeRangeValue.toBuilder() : null;
        }

        public final void setTimeRangeValue(TimeRange.BuilderImpl timeRangeValue) {
            this.timeRangeValue = timeRangeValue != null ? timeRangeValue.build() : null;
        }

        @Override
        public final Builder timeRangeValue(TimeRange timeRangeValue) {
            this.timeRangeValue = timeRangeValue;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEngagementsRequest build() {
            return new ListEngagementsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
