/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ContactType {
    PERSONAL("PERSONAL"),
    ESCALATION("ESCALATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ContactType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContactType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ContactType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContactType> knownValues() {
        return Stream.of(ContactType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

