/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPagesByEngagementResponse extends SsmContactsResponse implements
        ToCopyableBuilder<ListPagesByEngagementResponse.Builder, ListPagesByEngagementResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPagesByEngagementResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<Page>> PAGES_FIELD = SdkField
            .<List<Page>> builder(MarshallingType.LIST)
            .memberName("Pages")
            .getter(getter(ListPagesByEngagementResponse::pages))
            .setter(setter(Builder::pages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Page> builder(MarshallingType.SDK_POJO)
                                            .constructor(Page::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PAGES_FIELD));

    private final String nextToken;

    private final List<Page> pages;

    private ListPagesByEngagementResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.pages = builder.pages;
    }

    /**
     * <p>
     * The pagination token to continue to the next page of results.
     * </p>
     * 
     * @return The pagination token to continue to the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Pages property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasPages() {
        return pages != null && !(pages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of engagements to contact channels.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPages} method.
     * </p>
     * 
     * @return The list of engagements to contact channels.
     */
    public final List<Page> pages() {
        return pages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasPages() ? pages() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPagesByEngagementResponse)) {
            return false;
        }
        ListPagesByEngagementResponse other = (ListPagesByEngagementResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasPages() == other.hasPages()
                && Objects.equals(pages(), other.pages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPagesByEngagementResponse").add("NextToken", nextToken())
                .add("Pages", hasPages() ? pages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Pages":
            return Optional.ofNullable(clazz.cast(pages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPagesByEngagementResponse, T> g) {
        return obj -> g.apply((ListPagesByEngagementResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmContactsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPagesByEngagementResponse> {
        /**
         * <p>
         * The pagination token to continue to the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to continue to the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of engagements to contact channels.
         * </p>
         * 
         * @param pages
         *        The list of engagements to contact channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pages(Collection<Page> pages);

        /**
         * <p>
         * The list of engagements to contact channels.
         * </p>
         * 
         * @param pages
         *        The list of engagements to contact channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pages(Page... pages);

        /**
         * <p>
         * The list of engagements to contact channels.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Page>.Builder} avoiding the need to
         * create one manually via {@link List<Page>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Page>.Builder#build()} is called immediately and its result
         * is passed to {@link #pages(List<Page>)}.
         * 
         * @param pages
         *        a consumer that will call methods on {@link List<Page>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pages(List<Page>)
         */
        Builder pages(Consumer<Page.Builder>... pages);
    }

    static final class BuilderImpl extends SsmContactsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<Page> pages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPagesByEngagementResponse model) {
            super(model);
            nextToken(model.nextToken);
            pages(model.pages);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Page.Builder> getPages() {
            List<Page.Builder> result = PagesListCopier.copyToBuilder(this.pages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPages(Collection<Page.BuilderImpl> pages) {
            this.pages = PagesListCopier.copyFromBuilder(pages);
        }

        @Override
        public final Builder pages(Collection<Page> pages) {
            this.pages = PagesListCopier.copy(pages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pages(Page... pages) {
            pages(Arrays.asList(pages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pages(Consumer<Page.Builder>... pages) {
            pages(Stream.of(pages).map(c -> Page.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPagesByEngagementResponse build() {
            return new ListPagesByEngagementResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
