/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.ssmcontacts.model.AcceptPageRequest;
import software.amazon.awssdk.services.ssmcontacts.model.AcceptPageResponse;
import software.amazon.awssdk.services.ssmcontacts.model.ActivateContactChannelRequest;
import software.amazon.awssdk.services.ssmcontacts.model.ActivateContactChannelResponse;
import software.amazon.awssdk.services.ssmcontacts.model.CreateContactChannelRequest;
import software.amazon.awssdk.services.ssmcontacts.model.CreateContactChannelResponse;
import software.amazon.awssdk.services.ssmcontacts.model.CreateContactRequest;
import software.amazon.awssdk.services.ssmcontacts.model.CreateContactResponse;
import software.amazon.awssdk.services.ssmcontacts.model.DeactivateContactChannelRequest;
import software.amazon.awssdk.services.ssmcontacts.model.DeactivateContactChannelResponse;
import software.amazon.awssdk.services.ssmcontacts.model.DeleteContactChannelRequest;
import software.amazon.awssdk.services.ssmcontacts.model.DeleteContactChannelResponse;
import software.amazon.awssdk.services.ssmcontacts.model.DeleteContactRequest;
import software.amazon.awssdk.services.ssmcontacts.model.DeleteContactResponse;
import software.amazon.awssdk.services.ssmcontacts.model.DescribeEngagementRequest;
import software.amazon.awssdk.services.ssmcontacts.model.DescribeEngagementResponse;
import software.amazon.awssdk.services.ssmcontacts.model.DescribePageRequest;
import software.amazon.awssdk.services.ssmcontacts.model.DescribePageResponse;
import software.amazon.awssdk.services.ssmcontacts.model.GetContactChannelRequest;
import software.amazon.awssdk.services.ssmcontacts.model.GetContactChannelResponse;
import software.amazon.awssdk.services.ssmcontacts.model.GetContactPolicyRequest;
import software.amazon.awssdk.services.ssmcontacts.model.GetContactPolicyResponse;
import software.amazon.awssdk.services.ssmcontacts.model.GetContactRequest;
import software.amazon.awssdk.services.ssmcontacts.model.GetContactResponse;
import software.amazon.awssdk.services.ssmcontacts.model.ListContactChannelsRequest;
import software.amazon.awssdk.services.ssmcontacts.model.ListContactChannelsResponse;
import software.amazon.awssdk.services.ssmcontacts.model.ListContactsRequest;
import software.amazon.awssdk.services.ssmcontacts.model.ListContactsResponse;
import software.amazon.awssdk.services.ssmcontacts.model.ListEngagementsRequest;
import software.amazon.awssdk.services.ssmcontacts.model.ListEngagementsResponse;
import software.amazon.awssdk.services.ssmcontacts.model.ListPageReceiptsRequest;
import software.amazon.awssdk.services.ssmcontacts.model.ListPageReceiptsResponse;
import software.amazon.awssdk.services.ssmcontacts.model.ListPagesByContactRequest;
import software.amazon.awssdk.services.ssmcontacts.model.ListPagesByContactResponse;
import software.amazon.awssdk.services.ssmcontacts.model.ListPagesByEngagementRequest;
import software.amazon.awssdk.services.ssmcontacts.model.ListPagesByEngagementResponse;
import software.amazon.awssdk.services.ssmcontacts.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ssmcontacts.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ssmcontacts.model.PutContactPolicyRequest;
import software.amazon.awssdk.services.ssmcontacts.model.PutContactPolicyResponse;
import software.amazon.awssdk.services.ssmcontacts.model.SendActivationCodeRequest;
import software.amazon.awssdk.services.ssmcontacts.model.SendActivationCodeResponse;
import software.amazon.awssdk.services.ssmcontacts.model.StartEngagementRequest;
import software.amazon.awssdk.services.ssmcontacts.model.StartEngagementResponse;
import software.amazon.awssdk.services.ssmcontacts.model.StopEngagementRequest;
import software.amazon.awssdk.services.ssmcontacts.model.StopEngagementResponse;
import software.amazon.awssdk.services.ssmcontacts.model.TagResourceRequest;
import software.amazon.awssdk.services.ssmcontacts.model.TagResourceResponse;
import software.amazon.awssdk.services.ssmcontacts.model.UntagResourceRequest;
import software.amazon.awssdk.services.ssmcontacts.model.UntagResourceResponse;
import software.amazon.awssdk.services.ssmcontacts.model.UpdateContactChannelRequest;
import software.amazon.awssdk.services.ssmcontacts.model.UpdateContactChannelResponse;
import software.amazon.awssdk.services.ssmcontacts.model.UpdateContactRequest;
import software.amazon.awssdk.services.ssmcontacts.model.UpdateContactResponse;
import software.amazon.awssdk.services.ssmcontacts.paginators.ListContactChannelsPublisher;
import software.amazon.awssdk.services.ssmcontacts.paginators.ListContactsPublisher;
import software.amazon.awssdk.services.ssmcontacts.paginators.ListEngagementsPublisher;
import software.amazon.awssdk.services.ssmcontacts.paginators.ListPageReceiptsPublisher;
import software.amazon.awssdk.services.ssmcontacts.paginators.ListPagesByContactPublisher;
import software.amazon.awssdk.services.ssmcontacts.paginators.ListPagesByEngagementPublisher;

/**
 * Service client for accessing SSM Contacts asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Systems Manager Incident Manager is an incident management console designed to help users mitigate and recover from
 * incidents affecting their Amazon Web Services-hosted applications. An incident is any unplanned interruption or
 * reduction in quality of services.
 * </p>
 * <p>
 * Incident Manager increases incident resolution by notifying responders of impact, highlighting relevant
 * troubleshooting data, and providing collaboration tools to get services back up and running. To achieve the primary
 * goal of reducing the time-to-resolution of critical incidents, Incident Manager automates response plans and enables
 * responder team escalation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SsmContactsAsyncClient extends SdkClient {
    String SERVICE_NAME = "ssm-contacts";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "ssm-contacts";

    /**
     * Create a {@link SsmContactsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SsmContactsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SsmContactsAsyncClient}.
     */
    static SsmContactsAsyncClientBuilder builder() {
        return new DefaultSsmContactsAsyncClientBuilder();
    }

    /**
     * <p>
     * Used to acknowledge an engagement to a contact channel during an incident.
     * </p>
     *
     * @param acceptPageRequest
     * @return A Java Future containing the result of the AcceptPage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.AcceptPage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/AcceptPage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AcceptPageResponse> acceptPage(AcceptPageRequest acceptPageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to acknowledge an engagement to a contact channel during an incident.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptPageRequest.Builder} avoiding the need to
     * create one manually via {@link AcceptPageRequest#builder()}
     * </p>
     *
     * @param acceptPageRequest
     *        A {@link Consumer} that will call methods on {@link AcceptPageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AcceptPage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.AcceptPage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/AcceptPage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AcceptPageResponse> acceptPage(Consumer<AcceptPageRequest.Builder> acceptPageRequest) {
        return acceptPage(AcceptPageRequest.builder().applyMutation(acceptPageRequest).build());
    }

    /**
     * <p>
     * Activates a contact's contact channel. Incident Manager can't engage a contact until the contact channel has been
     * activated.
     * </p>
     *
     * @param activateContactChannelRequest
     * @return A Java Future containing the result of the ActivateContactChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.ActivateContactChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ActivateContactChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ActivateContactChannelResponse> activateContactChannel(
            ActivateContactChannelRequest activateContactChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates a contact's contact channel. Incident Manager can't engage a contact until the contact channel has been
     * activated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ActivateContactChannelRequest.Builder} avoiding the
     * need to create one manually via {@link ActivateContactChannelRequest#builder()}
     * </p>
     *
     * @param activateContactChannelRequest
     *        A {@link Consumer} that will call methods on {@link ActivateContactChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ActivateContactChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.ActivateContactChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ActivateContactChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ActivateContactChannelResponse> activateContactChannel(
            Consumer<ActivateContactChannelRequest.Builder> activateContactChannelRequest) {
        return activateContactChannel(ActivateContactChannelRequest.builder().applyMutation(activateContactChannelRequest)
                .build());
    }

    /**
     * <p>
     * Contacts are either the contacts that Incident Manager engages during an incident or the escalation plans that
     * Incident Manager uses to engage contacts in phases during an incident.
     * </p>
     *
     * @param createContactRequest
     * @return A Java Future containing the result of the CreateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>ConflictException Updating or deleting a resource causes an inconsistent state.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>DataEncryptionException The operation failed to due an encryption key error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.CreateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/CreateContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateContactResponse> createContact(CreateContactRequest createContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Contacts are either the contacts that Incident Manager engages during an incident or the escalation plans that
     * Incident Manager uses to engage contacts in phases during an incident.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContactRequest.Builder} avoiding the need to
     * create one manually via {@link CreateContactRequest#builder()}
     * </p>
     *
     * @param createContactRequest
     *        A {@link Consumer} that will call methods on {@link CreateContactRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>ConflictException Updating or deleting a resource causes an inconsistent state.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>DataEncryptionException The operation failed to due an encryption key error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.CreateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/CreateContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateContactResponse> createContact(Consumer<CreateContactRequest.Builder> createContactRequest) {
        return createContact(CreateContactRequest.builder().applyMutation(createContactRequest).build());
    }

    /**
     * <p>
     * A contact channel is the method that Incident Manager uses to engage your contact.
     * </p>
     *
     * @param createContactChannelRequest
     * @return A Java Future containing the result of the CreateContactChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>ConflictException Updating or deleting a resource causes an inconsistent state.</li>
     *         <li>DataEncryptionException The operation failed to due an encryption key error.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.CreateContactChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/CreateContactChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateContactChannelResponse> createContactChannel(
            CreateContactChannelRequest createContactChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A contact channel is the method that Incident Manager uses to engage your contact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContactChannelRequest.Builder} avoiding the
     * need to create one manually via {@link CreateContactChannelRequest#builder()}
     * </p>
     *
     * @param createContactChannelRequest
     *        A {@link Consumer} that will call methods on {@link CreateContactChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateContactChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>ConflictException Updating or deleting a resource causes an inconsistent state.</li>
     *         <li>DataEncryptionException The operation failed to due an encryption key error.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.CreateContactChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/CreateContactChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateContactChannelResponse> createContactChannel(
            Consumer<CreateContactChannelRequest.Builder> createContactChannelRequest) {
        return createContactChannel(CreateContactChannelRequest.builder().applyMutation(createContactChannelRequest).build());
    }

    /**
     * <p>
     * To no longer receive Incident Manager engagements to a contact channel, you can deactivate the channel.
     * </p>
     *
     * @param deactivateContactChannelRequest
     * @return A Java Future containing the result of the DeactivateContactChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.DeactivateContactChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DeactivateContactChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeactivateContactChannelResponse> deactivateContactChannel(
            DeactivateContactChannelRequest deactivateContactChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * To no longer receive Incident Manager engagements to a contact channel, you can deactivate the channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeactivateContactChannelRequest.Builder} avoiding
     * the need to create one manually via {@link DeactivateContactChannelRequest#builder()}
     * </p>
     *
     * @param deactivateContactChannelRequest
     *        A {@link Consumer} that will call methods on {@link DeactivateContactChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeactivateContactChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.DeactivateContactChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DeactivateContactChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeactivateContactChannelResponse> deactivateContactChannel(
            Consumer<DeactivateContactChannelRequest.Builder> deactivateContactChannelRequest) {
        return deactivateContactChannel(DeactivateContactChannelRequest.builder().applyMutation(deactivateContactChannelRequest)
                .build());
    }

    /**
     * <p>
     * To remove a contact from Incident Manager, you can delete the contact. Deleting a contact removes them from all
     * escalation plans and related response plans. Deleting an escalation plan removes it from all related response
     * plans. You will have to recreate the contact and its contact channels before you can use it again.
     * </p>
     *
     * @param deleteContactRequest
     * @return A Java Future containing the result of the DeleteContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.DeleteContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DeleteContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteContactResponse> deleteContact(DeleteContactRequest deleteContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * To remove a contact from Incident Manager, you can delete the contact. Deleting a contact removes them from all
     * escalation plans and related response plans. Deleting an escalation plan removes it from all related response
     * plans. You will have to recreate the contact and its contact channels before you can use it again.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContactRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteContactRequest#builder()}
     * </p>
     *
     * @param deleteContactRequest
     *        A {@link Consumer} that will call methods on {@link DeleteContactRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.DeleteContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DeleteContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteContactResponse> deleteContact(Consumer<DeleteContactRequest.Builder> deleteContactRequest) {
        return deleteContact(DeleteContactRequest.builder().applyMutation(deleteContactRequest).build());
    }

    /**
     * <p>
     * To no longer receive engagements on a contact channel, you can delete the channel from a contact. Deleting the
     * contact channel removes it from the contact's engagement plan. If you delete the only contact channel for a
     * contact, you won't be able to engage that contact during an incident.
     * </p>
     *
     * @param deleteContactChannelRequest
     * @return A Java Future containing the result of the DeleteContactChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.DeleteContactChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DeleteContactChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteContactChannelResponse> deleteContactChannel(
            DeleteContactChannelRequest deleteContactChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * To no longer receive engagements on a contact channel, you can delete the channel from a contact. Deleting the
     * contact channel removes it from the contact's engagement plan. If you delete the only contact channel for a
     * contact, you won't be able to engage that contact during an incident.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContactChannelRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteContactChannelRequest#builder()}
     * </p>
     *
     * @param deleteContactChannelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteContactChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteContactChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.DeleteContactChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DeleteContactChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteContactChannelResponse> deleteContactChannel(
            Consumer<DeleteContactChannelRequest.Builder> deleteContactChannelRequest) {
        return deleteContactChannel(DeleteContactChannelRequest.builder().applyMutation(deleteContactChannelRequest).build());
    }

    /**
     * <p>
     * Incident Manager uses engagements to engage contacts and escalation plans during an incident. Use this command to
     * describe the engagement that occurred during an incident.
     * </p>
     *
     * @param describeEngagementRequest
     * @return A Java Future containing the result of the DescribeEngagement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>DataEncryptionException The operation failed to due an encryption key error.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.DescribeEngagement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DescribeEngagement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEngagementResponse> describeEngagement(DescribeEngagementRequest describeEngagementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Incident Manager uses engagements to engage contacts and escalation plans during an incident. Use this command to
     * describe the engagement that occurred during an incident.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEngagementRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEngagementRequest#builder()}
     * </p>
     *
     * @param describeEngagementRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEngagementRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeEngagement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>DataEncryptionException The operation failed to due an encryption key error.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.DescribeEngagement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DescribeEngagement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEngagementResponse> describeEngagement(
            Consumer<DescribeEngagementRequest.Builder> describeEngagementRequest) {
        return describeEngagement(DescribeEngagementRequest.builder().applyMutation(describeEngagementRequest).build());
    }

    /**
     * <p>
     * Lists details of the engagement to a contact channel.
     * </p>
     *
     * @param describePageRequest
     * @return A Java Future containing the result of the DescribePage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>DataEncryptionException The operation failed to due an encryption key error.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.DescribePage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DescribePage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribePageResponse> describePage(DescribePageRequest describePageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists details of the engagement to a contact channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePageRequest.Builder} avoiding the need to
     * create one manually via {@link DescribePageRequest#builder()}
     * </p>
     *
     * @param describePageRequest
     *        A {@link Consumer} that will call methods on {@link DescribePageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribePage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>DataEncryptionException The operation failed to due an encryption key error.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.DescribePage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/DescribePage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribePageResponse> describePage(Consumer<DescribePageRequest.Builder> describePageRequest) {
        return describePage(DescribePageRequest.builder().applyMutation(describePageRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified contact or escalation plan.
     * </p>
     *
     * @param getContactRequest
     * @return A Java Future containing the result of the GetContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>DataEncryptionException The operation failed to due an encryption key error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.GetContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/GetContact" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetContactResponse> getContact(GetContactRequest getContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified contact or escalation plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContactRequest.Builder} avoiding the need to
     * create one manually via {@link GetContactRequest#builder()}
     * </p>
     *
     * @param getContactRequest
     *        A {@link Consumer} that will call methods on {@link GetContactRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>DataEncryptionException The operation failed to due an encryption key error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.GetContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/GetContact" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetContactResponse> getContact(Consumer<GetContactRequest.Builder> getContactRequest) {
        return getContact(GetContactRequest.builder().applyMutation(getContactRequest).build());
    }

    /**
     * <p>
     * List details about a specific contact channel.
     * </p>
     *
     * @param getContactChannelRequest
     * @return A Java Future containing the result of the GetContactChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>DataEncryptionException The operation failed to due an encryption key error.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.GetContactChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/GetContactChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetContactChannelResponse> getContactChannel(GetContactChannelRequest getContactChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List details about a specific contact channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContactChannelRequest.Builder} avoiding the need
     * to create one manually via {@link GetContactChannelRequest#builder()}
     * </p>
     *
     * @param getContactChannelRequest
     *        A {@link Consumer} that will call methods on {@link GetContactChannelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetContactChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>DataEncryptionException The operation failed to due an encryption key error.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.GetContactChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/GetContactChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetContactChannelResponse> getContactChannel(
            Consumer<GetContactChannelRequest.Builder> getContactChannelRequest) {
        return getContactChannel(GetContactChannelRequest.builder().applyMutation(getContactChannelRequest).build());
    }

    /**
     * <p>
     * Retrieves the resource policies attached to the specified contact or escalation plan.
     * </p>
     *
     * @param getContactPolicyRequest
     * @return A Java Future containing the result of the GetContactPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.GetContactPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/GetContactPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetContactPolicyResponse> getContactPolicy(GetContactPolicyRequest getContactPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the resource policies attached to the specified contact or escalation plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContactPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetContactPolicyRequest#builder()}
     * </p>
     *
     * @param getContactPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetContactPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetContactPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.GetContactPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/GetContactPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetContactPolicyResponse> getContactPolicy(
            Consumer<GetContactPolicyRequest.Builder> getContactPolicyRequest) {
        return getContactPolicy(GetContactPolicyRequest.builder().applyMutation(getContactPolicyRequest).build());
    }

    /**
     * <p>
     * Lists all contact channels for the specified contact.
     * </p>
     *
     * @param listContactChannelsRequest
     * @return A Java Future containing the result of the ListContactChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>DataEncryptionException The operation failed to due an encryption key error.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.ListContactChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListContactChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListContactChannelsResponse> listContactChannels(
            ListContactChannelsRequest listContactChannelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all contact channels for the specified contact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactChannelsRequest.Builder} avoiding the
     * need to create one manually via {@link ListContactChannelsRequest#builder()}
     * </p>
     *
     * @param listContactChannelsRequest
     *        A {@link Consumer} that will call methods on {@link ListContactChannelsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListContactChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>DataEncryptionException The operation failed to due an encryption key error.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.ListContactChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListContactChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListContactChannelsResponse> listContactChannels(
            Consumer<ListContactChannelsRequest.Builder> listContactChannelsRequest) {
        return listContactChannels(ListContactChannelsRequest.builder().applyMutation(listContactChannelsRequest).build());
    }

    /**
     * <p>
     * Lists all contact channels for the specified contact.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listContactChannels(software.amazon.awssdk.services.ssmcontacts.model.ListContactChannelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmcontacts.paginators.ListContactChannelsPublisher publisher = client.listContactChannelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmcontacts.paginators.ListContactChannelsPublisher publisher = client.listContactChannelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssmcontacts.model.ListContactChannelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssmcontacts.model.ListContactChannelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContactChannels(software.amazon.awssdk.services.ssmcontacts.model.ListContactChannelsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listContactChannelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>DataEncryptionException The operation failed to due an encryption key error.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.ListContactChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListContactChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContactChannelsPublisher listContactChannelsPaginator(ListContactChannelsRequest listContactChannelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all contact channels for the specified contact.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listContactChannels(software.amazon.awssdk.services.ssmcontacts.model.ListContactChannelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmcontacts.paginators.ListContactChannelsPublisher publisher = client.listContactChannelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmcontacts.paginators.ListContactChannelsPublisher publisher = client.listContactChannelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssmcontacts.model.ListContactChannelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssmcontacts.model.ListContactChannelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContactChannels(software.amazon.awssdk.services.ssmcontacts.model.ListContactChannelsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactChannelsRequest.Builder} avoiding the
     * need to create one manually via {@link ListContactChannelsRequest#builder()}
     * </p>
     *
     * @param listContactChannelsRequest
     *        A {@link Consumer} that will call methods on {@link ListContactChannelsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>DataEncryptionException The operation failed to due an encryption key error.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.ListContactChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListContactChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContactChannelsPublisher listContactChannelsPaginator(
            Consumer<ListContactChannelsRequest.Builder> listContactChannelsRequest) {
        return listContactChannelsPaginator(ListContactChannelsRequest.builder().applyMutation(listContactChannelsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all contacts and escalation plans in Incident Manager.
     * </p>
     *
     * @param listContactsRequest
     * @return A Java Future containing the result of the ListContacts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.ListContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListContacts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListContactsResponse> listContacts(ListContactsRequest listContactsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all contacts and escalation plans in Incident Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactsRequest.Builder} avoiding the need to
     * create one manually via {@link ListContactsRequest#builder()}
     * </p>
     *
     * @param listContactsRequest
     *        A {@link Consumer} that will call methods on {@link ListContactsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListContacts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.ListContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListContacts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListContactsResponse> listContacts(Consumer<ListContactsRequest.Builder> listContactsRequest) {
        return listContacts(ListContactsRequest.builder().applyMutation(listContactsRequest).build());
    }

    /**
     * <p>
     * Lists all contacts and escalation plans in Incident Manager.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listContacts(software.amazon.awssdk.services.ssmcontacts.model.ListContactsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmcontacts.paginators.ListContactsPublisher publisher = client.listContactsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmcontacts.paginators.ListContactsPublisher publisher = client.listContactsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssmcontacts.model.ListContactsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssmcontacts.model.ListContactsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContacts(software.amazon.awssdk.services.ssmcontacts.model.ListContactsRequest)} operation.</b>
     * </p>
     *
     * @param listContactsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.ListContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListContacts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContactsPublisher listContactsPaginator(ListContactsRequest listContactsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all contacts and escalation plans in Incident Manager.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listContacts(software.amazon.awssdk.services.ssmcontacts.model.ListContactsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmcontacts.paginators.ListContactsPublisher publisher = client.listContactsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmcontacts.paginators.ListContactsPublisher publisher = client.listContactsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssmcontacts.model.ListContactsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssmcontacts.model.ListContactsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContacts(software.amazon.awssdk.services.ssmcontacts.model.ListContactsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactsRequest.Builder} avoiding the need to
     * create one manually via {@link ListContactsRequest#builder()}
     * </p>
     *
     * @param listContactsRequest
     *        A {@link Consumer} that will call methods on {@link ListContactsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.ListContacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListContacts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContactsPublisher listContactsPaginator(Consumer<ListContactsRequest.Builder> listContactsRequest) {
        return listContactsPaginator(ListContactsRequest.builder().applyMutation(listContactsRequest).build());
    }

    /**
     * <p>
     * Lists all engagements that have happened in an incident.
     * </p>
     *
     * @param listEngagementsRequest
     * @return A Java Future containing the result of the ListEngagements operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.ListEngagements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListEngagements" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListEngagementsResponse> listEngagements(ListEngagementsRequest listEngagementsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all engagements that have happened in an incident.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEngagementsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEngagementsRequest#builder()}
     * </p>
     *
     * @param listEngagementsRequest
     *        A {@link Consumer} that will call methods on {@link ListEngagementsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListEngagements operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.ListEngagements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListEngagements" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListEngagementsResponse> listEngagements(
            Consumer<ListEngagementsRequest.Builder> listEngagementsRequest) {
        return listEngagements(ListEngagementsRequest.builder().applyMutation(listEngagementsRequest).build());
    }

    /**
     * <p>
     * Lists all engagements that have happened in an incident.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEngagements(software.amazon.awssdk.services.ssmcontacts.model.ListEngagementsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmcontacts.paginators.ListEngagementsPublisher publisher = client.listEngagementsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmcontacts.paginators.ListEngagementsPublisher publisher = client.listEngagementsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssmcontacts.model.ListEngagementsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssmcontacts.model.ListEngagementsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEngagements(software.amazon.awssdk.services.ssmcontacts.model.ListEngagementsRequest)} operation.</b>
     * </p>
     *
     * @param listEngagementsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.ListEngagements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListEngagements" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEngagementsPublisher listEngagementsPaginator(ListEngagementsRequest listEngagementsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all engagements that have happened in an incident.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEngagements(software.amazon.awssdk.services.ssmcontacts.model.ListEngagementsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmcontacts.paginators.ListEngagementsPublisher publisher = client.listEngagementsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmcontacts.paginators.ListEngagementsPublisher publisher = client.listEngagementsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssmcontacts.model.ListEngagementsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssmcontacts.model.ListEngagementsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEngagements(software.amazon.awssdk.services.ssmcontacts.model.ListEngagementsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEngagementsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEngagementsRequest#builder()}
     * </p>
     *
     * @param listEngagementsRequest
     *        A {@link Consumer} that will call methods on {@link ListEngagementsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.ListEngagements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListEngagements" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEngagementsPublisher listEngagementsPaginator(Consumer<ListEngagementsRequest.Builder> listEngagementsRequest) {
        return listEngagementsPaginator(ListEngagementsRequest.builder().applyMutation(listEngagementsRequest).build());
    }

    /**
     * <p>
     * Lists all of the engagements to contact channels that have been acknowledged.
     * </p>
     *
     * @param listPageReceiptsRequest
     * @return A Java Future containing the result of the ListPageReceipts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.ListPageReceipts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListPageReceipts" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPageReceiptsResponse> listPageReceipts(ListPageReceiptsRequest listPageReceiptsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the engagements to contact channels that have been acknowledged.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPageReceiptsRequest.Builder} avoiding the need
     * to create one manually via {@link ListPageReceiptsRequest#builder()}
     * </p>
     *
     * @param listPageReceiptsRequest
     *        A {@link Consumer} that will call methods on {@link ListPageReceiptsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListPageReceipts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.ListPageReceipts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListPageReceipts" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPageReceiptsResponse> listPageReceipts(
            Consumer<ListPageReceiptsRequest.Builder> listPageReceiptsRequest) {
        return listPageReceipts(ListPageReceiptsRequest.builder().applyMutation(listPageReceiptsRequest).build());
    }

    /**
     * <p>
     * Lists all of the engagements to contact channels that have been acknowledged.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPageReceipts(software.amazon.awssdk.services.ssmcontacts.model.ListPageReceiptsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmcontacts.paginators.ListPageReceiptsPublisher publisher = client.listPageReceiptsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmcontacts.paginators.ListPageReceiptsPublisher publisher = client.listPageReceiptsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssmcontacts.model.ListPageReceiptsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssmcontacts.model.ListPageReceiptsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPageReceipts(software.amazon.awssdk.services.ssmcontacts.model.ListPageReceiptsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPageReceiptsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.ListPageReceipts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListPageReceipts" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPageReceiptsPublisher listPageReceiptsPaginator(ListPageReceiptsRequest listPageReceiptsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the engagements to contact channels that have been acknowledged.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPageReceipts(software.amazon.awssdk.services.ssmcontacts.model.ListPageReceiptsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmcontacts.paginators.ListPageReceiptsPublisher publisher = client.listPageReceiptsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmcontacts.paginators.ListPageReceiptsPublisher publisher = client.listPageReceiptsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssmcontacts.model.ListPageReceiptsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssmcontacts.model.ListPageReceiptsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPageReceipts(software.amazon.awssdk.services.ssmcontacts.model.ListPageReceiptsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPageReceiptsRequest.Builder} avoiding the need
     * to create one manually via {@link ListPageReceiptsRequest#builder()}
     * </p>
     *
     * @param listPageReceiptsRequest
     *        A {@link Consumer} that will call methods on {@link ListPageReceiptsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.ListPageReceipts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListPageReceipts" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPageReceiptsPublisher listPageReceiptsPaginator(Consumer<ListPageReceiptsRequest.Builder> listPageReceiptsRequest) {
        return listPageReceiptsPaginator(ListPageReceiptsRequest.builder().applyMutation(listPageReceiptsRequest).build());
    }

    /**
     * <p>
     * Lists the engagements to a contact's contact channels.
     * </p>
     *
     * @param listPagesByContactRequest
     * @return A Java Future containing the result of the ListPagesByContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.ListPagesByContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListPagesByContact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPagesByContactResponse> listPagesByContact(ListPagesByContactRequest listPagesByContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the engagements to a contact's contact channels.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPagesByContactRequest.Builder} avoiding the
     * need to create one manually via {@link ListPagesByContactRequest#builder()}
     * </p>
     *
     * @param listPagesByContactRequest
     *        A {@link Consumer} that will call methods on {@link ListPagesByContactRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPagesByContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.ListPagesByContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListPagesByContact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPagesByContactResponse> listPagesByContact(
            Consumer<ListPagesByContactRequest.Builder> listPagesByContactRequest) {
        return listPagesByContact(ListPagesByContactRequest.builder().applyMutation(listPagesByContactRequest).build());
    }

    /**
     * <p>
     * Lists the engagements to a contact's contact channels.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPagesByContact(software.amazon.awssdk.services.ssmcontacts.model.ListPagesByContactRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmcontacts.paginators.ListPagesByContactPublisher publisher = client.listPagesByContactPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmcontacts.paginators.ListPagesByContactPublisher publisher = client.listPagesByContactPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssmcontacts.model.ListPagesByContactResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssmcontacts.model.ListPagesByContactResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPagesByContact(software.amazon.awssdk.services.ssmcontacts.model.ListPagesByContactRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPagesByContactRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.ListPagesByContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListPagesByContact"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPagesByContactPublisher listPagesByContactPaginator(ListPagesByContactRequest listPagesByContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the engagements to a contact's contact channels.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPagesByContact(software.amazon.awssdk.services.ssmcontacts.model.ListPagesByContactRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmcontacts.paginators.ListPagesByContactPublisher publisher = client.listPagesByContactPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmcontacts.paginators.ListPagesByContactPublisher publisher = client.listPagesByContactPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssmcontacts.model.ListPagesByContactResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssmcontacts.model.ListPagesByContactResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPagesByContact(software.amazon.awssdk.services.ssmcontacts.model.ListPagesByContactRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPagesByContactRequest.Builder} avoiding the
     * need to create one manually via {@link ListPagesByContactRequest#builder()}
     * </p>
     *
     * @param listPagesByContactRequest
     *        A {@link Consumer} that will call methods on {@link ListPagesByContactRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.ListPagesByContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListPagesByContact"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPagesByContactPublisher listPagesByContactPaginator(
            Consumer<ListPagesByContactRequest.Builder> listPagesByContactRequest) {
        return listPagesByContactPaginator(ListPagesByContactRequest.builder().applyMutation(listPagesByContactRequest).build());
    }

    /**
     * <p>
     * Lists the engagements to contact channels that occurred by engaging a contact.
     * </p>
     *
     * @param listPagesByEngagementRequest
     * @return A Java Future containing the result of the ListPagesByEngagement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.ListPagesByEngagement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListPagesByEngagement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPagesByEngagementResponse> listPagesByEngagement(
            ListPagesByEngagementRequest listPagesByEngagementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the engagements to contact channels that occurred by engaging a contact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPagesByEngagementRequest.Builder} avoiding the
     * need to create one manually via {@link ListPagesByEngagementRequest#builder()}
     * </p>
     *
     * @param listPagesByEngagementRequest
     *        A {@link Consumer} that will call methods on {@link ListPagesByEngagementRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPagesByEngagement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.ListPagesByEngagement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListPagesByEngagement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPagesByEngagementResponse> listPagesByEngagement(
            Consumer<ListPagesByEngagementRequest.Builder> listPagesByEngagementRequest) {
        return listPagesByEngagement(ListPagesByEngagementRequest.builder().applyMutation(listPagesByEngagementRequest).build());
    }

    /**
     * <p>
     * Lists the engagements to contact channels that occurred by engaging a contact.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPagesByEngagement(software.amazon.awssdk.services.ssmcontacts.model.ListPagesByEngagementRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmcontacts.paginators.ListPagesByEngagementPublisher publisher = client.listPagesByEngagementPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmcontacts.paginators.ListPagesByEngagementPublisher publisher = client.listPagesByEngagementPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssmcontacts.model.ListPagesByEngagementResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssmcontacts.model.ListPagesByEngagementResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPagesByEngagement(software.amazon.awssdk.services.ssmcontacts.model.ListPagesByEngagementRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPagesByEngagementRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.ListPagesByEngagement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListPagesByEngagement"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPagesByEngagementPublisher listPagesByEngagementPaginator(
            ListPagesByEngagementRequest listPagesByEngagementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the engagements to contact channels that occurred by engaging a contact.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPagesByEngagement(software.amazon.awssdk.services.ssmcontacts.model.ListPagesByEngagementRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmcontacts.paginators.ListPagesByEngagementPublisher publisher = client.listPagesByEngagementPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmcontacts.paginators.ListPagesByEngagementPublisher publisher = client.listPagesByEngagementPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssmcontacts.model.ListPagesByEngagementResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssmcontacts.model.ListPagesByEngagementResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPagesByEngagement(software.amazon.awssdk.services.ssmcontacts.model.ListPagesByEngagementRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPagesByEngagementRequest.Builder} avoiding the
     * need to create one manually via {@link ListPagesByEngagementRequest#builder()}
     * </p>
     *
     * @param listPagesByEngagementRequest
     *        A {@link Consumer} that will call methods on {@link ListPagesByEngagementRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.ListPagesByEngagement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListPagesByEngagement"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPagesByEngagementPublisher listPagesByEngagementPaginator(
            Consumer<ListPagesByEngagementRequest.Builder> listPagesByEngagementRequest) {
        return listPagesByEngagementPaginator(ListPagesByEngagementRequest.builder().applyMutation(listPagesByEngagementRequest)
                .build());
    }

    /**
     * <p>
     * Lists the tags of an escalation plan or contact.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags of an escalation plan or contact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds a resource to the specified contact or escalation plan.
     * </p>
     *
     * @param putContactPolicyRequest
     * @return A Java Future containing the result of the PutContactPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>ConflictException Updating or deleting a resource causes an inconsistent state.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.PutContactPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/PutContactPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutContactPolicyResponse> putContactPolicy(PutContactPolicyRequest putContactPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a resource to the specified contact or escalation plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutContactPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutContactPolicyRequest#builder()}
     * </p>
     *
     * @param putContactPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutContactPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutContactPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>ConflictException Updating or deleting a resource causes an inconsistent state.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.PutContactPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/PutContactPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutContactPolicyResponse> putContactPolicy(
            Consumer<PutContactPolicyRequest.Builder> putContactPolicyRequest) {
        return putContactPolicy(PutContactPolicyRequest.builder().applyMutation(putContactPolicyRequest).build());
    }

    /**
     * <p>
     * Sends an activation code to a contact channel. The contact can use this code to activate the contact channel in
     * the console or with the <code>ActivateChannel</code> operation. Incident Manager can't engage a contact channel
     * until it has been activated.
     * </p>
     *
     * @param sendActivationCodeRequest
     * @return A Java Future containing the result of the SendActivationCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>DataEncryptionException The operation failed to due an encryption key error.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.SendActivationCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/SendActivationCode"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendActivationCodeResponse> sendActivationCode(SendActivationCodeRequest sendActivationCodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends an activation code to a contact channel. The contact can use this code to activate the contact channel in
     * the console or with the <code>ActivateChannel</code> operation. Incident Manager can't engage a contact channel
     * until it has been activated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendActivationCodeRequest.Builder} avoiding the
     * need to create one manually via {@link SendActivationCodeRequest#builder()}
     * </p>
     *
     * @param sendActivationCodeRequest
     *        A {@link Consumer} that will call methods on {@link SendActivationCodeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SendActivationCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>DataEncryptionException The operation failed to due an encryption key error.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.SendActivationCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/SendActivationCode"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendActivationCodeResponse> sendActivationCode(
            Consumer<SendActivationCodeRequest.Builder> sendActivationCodeRequest) {
        return sendActivationCode(SendActivationCodeRequest.builder().applyMutation(sendActivationCodeRequest).build());
    }

    /**
     * <p>
     * Starts an engagement to a contact or escalation plan. The engagement engages each contact specified in the
     * incident.
     * </p>
     *
     * @param startEngagementRequest
     * @return A Java Future containing the result of the StartEngagement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>DataEncryptionException The operation failed to due an encryption key error.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.StartEngagement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/StartEngagement" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartEngagementResponse> startEngagement(StartEngagementRequest startEngagementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an engagement to a contact or escalation plan. The engagement engages each contact specified in the
     * incident.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartEngagementRequest.Builder} avoiding the need
     * to create one manually via {@link StartEngagementRequest#builder()}
     * </p>
     *
     * @param startEngagementRequest
     *        A {@link Consumer} that will call methods on {@link StartEngagementRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartEngagement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>DataEncryptionException The operation failed to due an encryption key error.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.StartEngagement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/StartEngagement" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartEngagementResponse> startEngagement(
            Consumer<StartEngagementRequest.Builder> startEngagementRequest) {
        return startEngagement(StartEngagementRequest.builder().applyMutation(startEngagementRequest).build());
    }

    /**
     * <p>
     * Stops an engagement before it finishes the final stage of the escalation plan or engagement plan. Further
     * contacts aren't engaged.
     * </p>
     *
     * @param stopEngagementRequest
     * @return A Java Future containing the result of the StopEngagement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.StopEngagement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/StopEngagement" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopEngagementResponse> stopEngagement(StopEngagementRequest stopEngagementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an engagement before it finishes the final stage of the escalation plan or engagement plan. Further
     * contacts aren't engaged.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopEngagementRequest.Builder} avoiding the need to
     * create one manually via {@link StopEngagementRequest#builder()}
     * </p>
     *
     * @param stopEngagementRequest
     *        A {@link Consumer} that will call methods on {@link StopEngagementRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StopEngagement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.StopEngagement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/StopEngagement" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopEngagementResponse> stopEngagement(Consumer<StopEngagementRequest.Builder> stopEngagementRequest) {
        return stopEngagement(StopEngagementRequest.builder().applyMutation(stopEngagementRequest).build());
    }

    /**
     * <p>
     * Tags a contact or escalation plan. You can tag only contacts and escalation plans in the first region of your
     * replication set.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags a contact or escalation plan. You can tag only contacts and escalation plans in the first region of your
     * replication set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the contact or escalation plan specified.
     * </p>
     *
     * @param updateContactRequest
     * @return A Java Future containing the result of the UpdateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>DataEncryptionException The operation failed to due an encryption key error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.UpdateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/UpdateContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateContactResponse> updateContact(UpdateContactRequest updateContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the contact or escalation plan specified.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateContactRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateContactRequest#builder()}
     * </p>
     *
     * @param updateContactRequest
     *        A {@link Consumer} that will call methods on {@link UpdateContactRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>DataEncryptionException The operation failed to due an encryption key error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.UpdateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/UpdateContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateContactResponse> updateContact(Consumer<UpdateContactRequest.Builder> updateContactRequest) {
        return updateContact(UpdateContactRequest.builder().applyMutation(updateContactRequest).build());
    }

    /**
     * <p>
     * Updates a contact's contact channel.
     * </p>
     *
     * @param updateContactChannelRequest
     * @return A Java Future containing the result of the UpdateContactChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>ConflictException Updating or deleting a resource causes an inconsistent state.</li>
     *         <li>DataEncryptionException The operation failed to due an encryption key error.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.UpdateContactChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/UpdateContactChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateContactChannelResponse> updateContactChannel(
            UpdateContactChannelRequest updateContactChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a contact's contact channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateContactChannelRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateContactChannelRequest#builder()}
     * </p>
     *
     * @param updateContactChannelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateContactChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateContactChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient access to perform this operation.</li>
     *         <li>ConflictException Updating or deleting a resource causes an inconsistent state.</li>
     *         <li>DataEncryptionException The operation failed to due an encryption key error.</li>
     *         <li>InternalServerException Unexpected error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmContactsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SsmContactsAsyncClient.UpdateContactChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/UpdateContactChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateContactChannelResponse> updateContactChannel(
            Consumer<UpdateContactChannelRequest.Builder> updateContactChannelRequest) {
        return updateContactChannel(UpdateContactChannelRequest.builder().applyMutation(updateContactChannelRequest).build());
    }
}
