/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartEngagementRequest extends SsmContactsRequest implements
        ToCopyableBuilder<StartEngagementRequest.Builder, StartEngagementRequest> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactId").getter(getter(StartEngagementRequest::contactId)).setter(setter(Builder::contactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()).build();

    private static final SdkField<String> SENDER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Sender")
            .getter(getter(StartEngagementRequest::sender)).setter(setter(Builder::sender))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sender").build()).build();

    private static final SdkField<String> SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Subject")
            .getter(getter(StartEngagementRequest::subject)).setter(setter(Builder::subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(StartEngagementRequest::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<String> PUBLIC_SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicSubject").getter(getter(StartEngagementRequest::publicSubject))
            .setter(setter(Builder::publicSubject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicSubject").build()).build();

    private static final SdkField<String> PUBLIC_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicContent").getter(getter(StartEngagementRequest::publicContent))
            .setter(setter(Builder::publicContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicContent").build()).build();

    private static final SdkField<String> INCIDENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IncidentId").getter(getter(StartEngagementRequest::incidentId)).setter(setter(Builder::incidentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncidentId").build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IdempotencyToken")
            .getter(getter(StartEngagementRequest::idempotencyToken))
            .setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD,
            SENDER_FIELD, SUBJECT_FIELD, CONTENT_FIELD, PUBLIC_SUBJECT_FIELD, PUBLIC_CONTENT_FIELD, INCIDENT_ID_FIELD,
            IDEMPOTENCY_TOKEN_FIELD));

    private final String contactId;

    private final String sender;

    private final String subject;

    private final String content;

    private final String publicSubject;

    private final String publicContent;

    private final String incidentId;

    private final String idempotencyToken;

    private StartEngagementRequest(BuilderImpl builder) {
        super(builder);
        this.contactId = builder.contactId;
        this.sender = builder.sender;
        this.subject = builder.subject;
        this.content = builder.content;
        this.publicSubject = builder.publicSubject;
        this.publicContent = builder.publicContent;
        this.incidentId = builder.incidentId;
        this.idempotencyToken = builder.idempotencyToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the contact being engaged.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the contact being engaged.
     */
    public final String contactId() {
        return contactId;
    }

    /**
     * <p>
     * The user that started the engagement.
     * </p>
     * 
     * @return The user that started the engagement.
     */
    public final String sender() {
        return sender;
    }

    /**
     * <p>
     * The secure subject of the message that was sent to the contact. Use this field for engagements to
     * <code>VOICE</code> or <code>EMAIL</code>.
     * </p>
     * 
     * @return The secure subject of the message that was sent to the contact. Use this field for engagements to
     *         <code>VOICE</code> or <code>EMAIL</code>.
     */
    public final String subject() {
        return subject;
    }

    /**
     * <p>
     * The secure content of the message that was sent to the contact. Use this field for engagements to
     * <code>VOICE</code> or <code>EMAIL</code>.
     * </p>
     * 
     * @return The secure content of the message that was sent to the contact. Use this field for engagements to
     *         <code>VOICE</code> or <code>EMAIL</code>.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * The insecure subject of the message that was sent to the contact. Use this field for engagements to
     * <code>SMS</code>.
     * </p>
     * 
     * @return The insecure subject of the message that was sent to the contact. Use this field for engagements to
     *         <code>SMS</code>.
     */
    public final String publicSubject() {
        return publicSubject;
    }

    /**
     * <p>
     * The insecure content of the message that was sent to the contact. Use this field for engagements to
     * <code>SMS</code>.
     * </p>
     * 
     * @return The insecure content of the message that was sent to the contact. Use this field for engagements to
     *         <code>SMS</code>.
     */
    public final String publicContent() {
        return publicContent;
    }

    /**
     * <p>
     * The ARN of the incident that the engagement is part of.
     * </p>
     * 
     * @return The ARN of the incident that the engagement is part of.
     */
    public final String incidentId() {
        return incidentId;
    }

    /**
     * <p>
     * A token ensuring that the operation is called only once with the specified details.
     * </p>
     * 
     * @return A token ensuring that the operation is called only once with the specified details.
     */
    public final String idempotencyToken() {
        return idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contactId());
        hashCode = 31 * hashCode + Objects.hashCode(sender());
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(publicSubject());
        hashCode = 31 * hashCode + Objects.hashCode(publicContent());
        hashCode = 31 * hashCode + Objects.hashCode(incidentId());
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartEngagementRequest)) {
            return false;
        }
        StartEngagementRequest other = (StartEngagementRequest) obj;
        return Objects.equals(contactId(), other.contactId()) && Objects.equals(sender(), other.sender())
                && Objects.equals(subject(), other.subject()) && Objects.equals(content(), other.content())
                && Objects.equals(publicSubject(), other.publicSubject())
                && Objects.equals(publicContent(), other.publicContent()) && Objects.equals(incidentId(), other.incidentId())
                && Objects.equals(idempotencyToken(), other.idempotencyToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartEngagementRequest").add("ContactId", contactId()).add("Sender", sender())
                .add("Subject", subject()).add("Content", content()).add("PublicSubject", publicSubject())
                .add("PublicContent", publicContent()).add("IncidentId", incidentId())
                .add("IdempotencyToken", idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactId":
            return Optional.ofNullable(clazz.cast(contactId()));
        case "Sender":
            return Optional.ofNullable(clazz.cast(sender()));
        case "Subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "PublicSubject":
            return Optional.ofNullable(clazz.cast(publicSubject()));
        case "PublicContent":
            return Optional.ofNullable(clazz.cast(publicContent()));
        case "IncidentId":
            return Optional.ofNullable(clazz.cast(incidentId()));
        case "IdempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartEngagementRequest, T> g) {
        return obj -> g.apply((StartEngagementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmContactsRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartEngagementRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the contact being engaged.
         * </p>
         * 
         * @param contactId
         *        The Amazon Resource Name (ARN) of the contact being engaged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactId(String contactId);

        /**
         * <p>
         * The user that started the engagement.
         * </p>
         * 
         * @param sender
         *        The user that started the engagement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sender(String sender);

        /**
         * <p>
         * The secure subject of the message that was sent to the contact. Use this field for engagements to
         * <code>VOICE</code> or <code>EMAIL</code>.
         * </p>
         * 
         * @param subject
         *        The secure subject of the message that was sent to the contact. Use this field for engagements to
         *        <code>VOICE</code> or <code>EMAIL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);

        /**
         * <p>
         * The secure content of the message that was sent to the contact. Use this field for engagements to
         * <code>VOICE</code> or <code>EMAIL</code>.
         * </p>
         * 
         * @param content
         *        The secure content of the message that was sent to the contact. Use this field for engagements to
         *        <code>VOICE</code> or <code>EMAIL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The insecure subject of the message that was sent to the contact. Use this field for engagements to
         * <code>SMS</code>.
         * </p>
         * 
         * @param publicSubject
         *        The insecure subject of the message that was sent to the contact. Use this field for engagements to
         *        <code>SMS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicSubject(String publicSubject);

        /**
         * <p>
         * The insecure content of the message that was sent to the contact. Use this field for engagements to
         * <code>SMS</code>.
         * </p>
         * 
         * @param publicContent
         *        The insecure content of the message that was sent to the contact. Use this field for engagements to
         *        <code>SMS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicContent(String publicContent);

        /**
         * <p>
         * The ARN of the incident that the engagement is part of.
         * </p>
         * 
         * @param incidentId
         *        The ARN of the incident that the engagement is part of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incidentId(String incidentId);

        /**
         * <p>
         * A token ensuring that the operation is called only once with the specified details.
         * </p>
         * 
         * @param idempotencyToken
         *        A token ensuring that the operation is called only once with the specified details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmContactsRequest.BuilderImpl implements Builder {
        private String contactId;

        private String sender;

        private String subject;

        private String content;

        private String publicSubject;

        private String publicContent;

        private String incidentId;

        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartEngagementRequest model) {
            super(model);
            contactId(model.contactId);
            sender(model.sender);
            subject(model.subject);
            content(model.content);
            publicSubject(model.publicSubject);
            publicContent(model.publicContent);
            incidentId(model.incidentId);
            idempotencyToken(model.idempotencyToken);
        }

        public final String getContactId() {
            return contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        @Transient
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getSender() {
            return sender;
        }

        public final void setSender(String sender) {
            this.sender = sender;
        }

        @Override
        @Transient
        public final Builder sender(String sender) {
            this.sender = sender;
            return this;
        }

        public final String getSubject() {
            return subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        @Transient
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        @Transient
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getPublicSubject() {
            return publicSubject;
        }

        public final void setPublicSubject(String publicSubject) {
            this.publicSubject = publicSubject;
        }

        @Override
        @Transient
        public final Builder publicSubject(String publicSubject) {
            this.publicSubject = publicSubject;
            return this;
        }

        public final String getPublicContent() {
            return publicContent;
        }

        public final void setPublicContent(String publicContent) {
            this.publicContent = publicContent;
        }

        @Override
        @Transient
        public final Builder publicContent(String publicContent) {
            this.publicContent = publicContent;
            return this;
        }

        public final String getIncidentId() {
            return incidentId;
        }

        public final void setIncidentId(String incidentId) {
            this.incidentId = incidentId;
        }

        @Override
        @Transient
        public final Builder incidentId(String incidentId) {
            this.incidentId = incidentId;
            return this;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        @Transient
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartEngagementRequest build() {
            return new StartEngagementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
