/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateContactChannelRequest extends SsmContactsRequest implements
        ToCopyableBuilder<UpdateContactChannelRequest.Builder, UpdateContactChannelRequest> {
    private static final SdkField<String> CONTACT_CHANNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactChannelId").getter(getter(UpdateContactChannelRequest::contactChannelId))
            .setter(setter(Builder::contactChannelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactChannelId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateContactChannelRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<ContactChannelAddress> DELIVERY_ADDRESS_FIELD = SdkField
            .<ContactChannelAddress> builder(MarshallingType.SDK_POJO).memberName("DeliveryAddress")
            .getter(getter(UpdateContactChannelRequest::deliveryAddress)).setter(setter(Builder::deliveryAddress))
            .constructor(ContactChannelAddress::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_CHANNEL_ID_FIELD,
            NAME_FIELD, DELIVERY_ADDRESS_FIELD));

    private final String contactChannelId;

    private final String name;

    private final ContactChannelAddress deliveryAddress;

    private UpdateContactChannelRequest(BuilderImpl builder) {
        super(builder);
        this.contactChannelId = builder.contactChannelId;
        this.name = builder.name;
        this.deliveryAddress = builder.deliveryAddress;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the contact channel you want to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the contact channel you want to update.
     */
    public final String contactChannelId() {
        return contactChannelId;
    }

    /**
     * <p>
     * The name of the contact channel.
     * </p>
     * 
     * @return The name of the contact channel.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The details that Incident Manager uses when trying to engage the contact channel.
     * </p>
     * 
     * @return The details that Incident Manager uses when trying to engage the contact channel.
     */
    public final ContactChannelAddress deliveryAddress() {
        return deliveryAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contactChannelId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContactChannelRequest)) {
            return false;
        }
        UpdateContactChannelRequest other = (UpdateContactChannelRequest) obj;
        return Objects.equals(contactChannelId(), other.contactChannelId()) && Objects.equals(name(), other.name())
                && Objects.equals(deliveryAddress(), other.deliveryAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateContactChannelRequest").add("ContactChannelId", contactChannelId()).add("Name", name())
                .add("DeliveryAddress", deliveryAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactChannelId":
            return Optional.ofNullable(clazz.cast(contactChannelId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DeliveryAddress":
            return Optional.ofNullable(clazz.cast(deliveryAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateContactChannelRequest, T> g) {
        return obj -> g.apply((UpdateContactChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmContactsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateContactChannelRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the contact channel you want to update.
         * </p>
         * 
         * @param contactChannelId
         *        The Amazon Resource Name (ARN) of the contact channel you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactChannelId(String contactChannelId);

        /**
         * <p>
         * The name of the contact channel.
         * </p>
         * 
         * @param name
         *        The name of the contact channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The details that Incident Manager uses when trying to engage the contact channel.
         * </p>
         * 
         * @param deliveryAddress
         *        The details that Incident Manager uses when trying to engage the contact channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryAddress(ContactChannelAddress deliveryAddress);

        /**
         * <p>
         * The details that Incident Manager uses when trying to engage the contact channel.
         * </p>
         * This is a convenience that creates an instance of the {@link ContactChannelAddress.Builder} avoiding the need
         * to create one manually via {@link ContactChannelAddress#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContactChannelAddress.Builder#build()} is called immediately and
         * its result is passed to {@link #deliveryAddress(ContactChannelAddress)}.
         * 
         * @param deliveryAddress
         *        a consumer that will call methods on {@link ContactChannelAddress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deliveryAddress(ContactChannelAddress)
         */
        default Builder deliveryAddress(Consumer<ContactChannelAddress.Builder> deliveryAddress) {
            return deliveryAddress(ContactChannelAddress.builder().applyMutation(deliveryAddress).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmContactsRequest.BuilderImpl implements Builder {
        private String contactChannelId;

        private String name;

        private ContactChannelAddress deliveryAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContactChannelRequest model) {
            super(model);
            contactChannelId(model.contactChannelId);
            name(model.name);
            deliveryAddress(model.deliveryAddress);
        }

        public final String getContactChannelId() {
            return contactChannelId;
        }

        public final void setContactChannelId(String contactChannelId) {
            this.contactChannelId = contactChannelId;
        }

        @Override
        @Transient
        public final Builder contactChannelId(String contactChannelId) {
            this.contactChannelId = contactChannelId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ContactChannelAddress.Builder getDeliveryAddress() {
            return deliveryAddress != null ? deliveryAddress.toBuilder() : null;
        }

        public final void setDeliveryAddress(ContactChannelAddress.BuilderImpl deliveryAddress) {
            this.deliveryAddress = deliveryAddress != null ? deliveryAddress.build() : null;
        }

        @Override
        @Transient
        public final Builder deliveryAddress(ContactChannelAddress deliveryAddress) {
            this.deliveryAddress = deliveryAddress;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContactChannelRequest build() {
            return new UpdateContactChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
