/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceptPageRequest extends SsmContactsRequest implements
        ToCopyableBuilder<AcceptPageRequest.Builder, AcceptPageRequest> {
    private static final SdkField<String> PAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PageId")
            .getter(getter(AcceptPageRequest::pageId)).setter(setter(Builder::pageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageId").build()).build();

    private static final SdkField<String> CONTACT_CHANNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactChannelId").getter(getter(AcceptPageRequest::contactChannelId))
            .setter(setter(Builder::contactChannelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactChannelId").build()).build();

    private static final SdkField<String> ACCEPT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceptType").getter(getter(AcceptPageRequest::acceptTypeAsString)).setter(setter(Builder::acceptType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptType").build()).build();

    private static final SdkField<String> NOTE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Note")
            .getter(getter(AcceptPageRequest::note)).setter(setter(Builder::note))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Note").build()).build();

    private static final SdkField<String> ACCEPT_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceptCode").getter(getter(AcceptPageRequest::acceptCode)).setter(setter(Builder::acceptCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptCode").build()).build();

    private static final SdkField<String> ACCEPT_CODE_VALIDATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceptCodeValidation").getter(getter(AcceptPageRequest::acceptCodeValidationAsString))
            .setter(setter(Builder::acceptCodeValidation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptCodeValidation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAGE_ID_FIELD,
            CONTACT_CHANNEL_ID_FIELD, ACCEPT_TYPE_FIELD, NOTE_FIELD, ACCEPT_CODE_FIELD, ACCEPT_CODE_VALIDATION_FIELD));

    private final String pageId;

    private final String contactChannelId;

    private final String acceptType;

    private final String note;

    private final String acceptCode;

    private final String acceptCodeValidation;

    private AcceptPageRequest(BuilderImpl builder) {
        super(builder);
        this.pageId = builder.pageId;
        this.contactChannelId = builder.contactChannelId;
        this.acceptType = builder.acceptType;
        this.note = builder.note;
        this.acceptCode = builder.acceptCode;
        this.acceptCodeValidation = builder.acceptCodeValidation;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the engagement to a contact channel.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the engagement to a contact channel.
     */
    public final String pageId() {
        return pageId;
    }

    /**
     * <p>
     * The ARN of the contact channel.
     * </p>
     * 
     * @return The ARN of the contact channel.
     */
    public final String contactChannelId() {
        return contactChannelId;
    }

    /**
     * <p>
     * The type indicates if the page was <code>DELIVERED</code> or <code>READ</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #acceptType} will
     * return {@link AcceptType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #acceptTypeAsString}.
     * </p>
     * 
     * @return The type indicates if the page was <code>DELIVERED</code> or <code>READ</code>.
     * @see AcceptType
     */
    public final AcceptType acceptType() {
        return AcceptType.fromValue(acceptType);
    }

    /**
     * <p>
     * The type indicates if the page was <code>DELIVERED</code> or <code>READ</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #acceptType} will
     * return {@link AcceptType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #acceptTypeAsString}.
     * </p>
     * 
     * @return The type indicates if the page was <code>DELIVERED</code> or <code>READ</code>.
     * @see AcceptType
     */
    public final String acceptTypeAsString() {
        return acceptType;
    }

    /**
     * <p>
     * Information provided by the user when the user acknowledges the page.
     * </p>
     * 
     * @return Information provided by the user when the user acknowledges the page.
     */
    public final String note() {
        return note;
    }

    /**
     * <p>
     * The accept code is a 6-digit code used to acknowledge the page.
     * </p>
     * 
     * @return The accept code is a 6-digit code used to acknowledge the page.
     */
    public final String acceptCode() {
        return acceptCode;
    }

    /**
     * <p>
     * An optional field that Incident Manager uses to <code>ENFORCE</code> <code>AcceptCode</code> validation when
     * acknowledging an page. Acknowledgement can occur by replying to a page, or when entering the AcceptCode in the
     * console. Enforcing AcceptCode validation causes Incident Manager to verify that the code entered by the user
     * matches the code sent by Incident Manager with the page.
     * </p>
     * <p>
     * Incident Manager can also <code>IGNORE</code> <code>AcceptCode</code> validation. Ignoring
     * <code>AcceptCode</code> validation causes Incident Manager to accept any value entered for the
     * <code>AcceptCode</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #acceptCodeValidation} will return {@link AcceptCodeValidation#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #acceptCodeValidationAsString}.
     * </p>
     * 
     * @return An optional field that Incident Manager uses to <code>ENFORCE</code> <code>AcceptCode</code> validation
     *         when acknowledging an page. Acknowledgement can occur by replying to a page, or when entering the
     *         AcceptCode in the console. Enforcing AcceptCode validation causes Incident Manager to verify that the
     *         code entered by the user matches the code sent by Incident Manager with the page.</p>
     *         <p>
     *         Incident Manager can also <code>IGNORE</code> <code>AcceptCode</code> validation. Ignoring
     *         <code>AcceptCode</code> validation causes Incident Manager to accept any value entered for the
     *         <code>AcceptCode</code>.
     * @see AcceptCodeValidation
     */
    public final AcceptCodeValidation acceptCodeValidation() {
        return AcceptCodeValidation.fromValue(acceptCodeValidation);
    }

    /**
     * <p>
     * An optional field that Incident Manager uses to <code>ENFORCE</code> <code>AcceptCode</code> validation when
     * acknowledging an page. Acknowledgement can occur by replying to a page, or when entering the AcceptCode in the
     * console. Enforcing AcceptCode validation causes Incident Manager to verify that the code entered by the user
     * matches the code sent by Incident Manager with the page.
     * </p>
     * <p>
     * Incident Manager can also <code>IGNORE</code> <code>AcceptCode</code> validation. Ignoring
     * <code>AcceptCode</code> validation causes Incident Manager to accept any value entered for the
     * <code>AcceptCode</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #acceptCodeValidation} will return {@link AcceptCodeValidation#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #acceptCodeValidationAsString}.
     * </p>
     * 
     * @return An optional field that Incident Manager uses to <code>ENFORCE</code> <code>AcceptCode</code> validation
     *         when acknowledging an page. Acknowledgement can occur by replying to a page, or when entering the
     *         AcceptCode in the console. Enforcing AcceptCode validation causes Incident Manager to verify that the
     *         code entered by the user matches the code sent by Incident Manager with the page.</p>
     *         <p>
     *         Incident Manager can also <code>IGNORE</code> <code>AcceptCode</code> validation. Ignoring
     *         <code>AcceptCode</code> validation causes Incident Manager to accept any value entered for the
     *         <code>AcceptCode</code>.
     * @see AcceptCodeValidation
     */
    public final String acceptCodeValidationAsString() {
        return acceptCodeValidation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pageId());
        hashCode = 31 * hashCode + Objects.hashCode(contactChannelId());
        hashCode = 31 * hashCode + Objects.hashCode(acceptTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(note());
        hashCode = 31 * hashCode + Objects.hashCode(acceptCode());
        hashCode = 31 * hashCode + Objects.hashCode(acceptCodeValidationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptPageRequest)) {
            return false;
        }
        AcceptPageRequest other = (AcceptPageRequest) obj;
        return Objects.equals(pageId(), other.pageId()) && Objects.equals(contactChannelId(), other.contactChannelId())
                && Objects.equals(acceptTypeAsString(), other.acceptTypeAsString()) && Objects.equals(note(), other.note())
                && Objects.equals(acceptCode(), other.acceptCode())
                && Objects.equals(acceptCodeValidationAsString(), other.acceptCodeValidationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcceptPageRequest").add("PageId", pageId()).add("ContactChannelId", contactChannelId())
                .add("AcceptType", acceptTypeAsString()).add("Note", note()).add("AcceptCode", acceptCode())
                .add("AcceptCodeValidation", acceptCodeValidationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PageId":
            return Optional.ofNullable(clazz.cast(pageId()));
        case "ContactChannelId":
            return Optional.ofNullable(clazz.cast(contactChannelId()));
        case "AcceptType":
            return Optional.ofNullable(clazz.cast(acceptTypeAsString()));
        case "Note":
            return Optional.ofNullable(clazz.cast(note()));
        case "AcceptCode":
            return Optional.ofNullable(clazz.cast(acceptCode()));
        case "AcceptCodeValidation":
            return Optional.ofNullable(clazz.cast(acceptCodeValidationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcceptPageRequest, T> g) {
        return obj -> g.apply((AcceptPageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmContactsRequest.Builder, SdkPojo, CopyableBuilder<Builder, AcceptPageRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the engagement to a contact channel.
         * </p>
         * 
         * @param pageId
         *        The Amazon Resource Name (ARN) of the engagement to a contact channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageId(String pageId);

        /**
         * <p>
         * The ARN of the contact channel.
         * </p>
         * 
         * @param contactChannelId
         *        The ARN of the contact channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactChannelId(String contactChannelId);

        /**
         * <p>
         * The type indicates if the page was <code>DELIVERED</code> or <code>READ</code>.
         * </p>
         * 
         * @param acceptType
         *        The type indicates if the page was <code>DELIVERED</code> or <code>READ</code>.
         * @see AcceptType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AcceptType
         */
        Builder acceptType(String acceptType);

        /**
         * <p>
         * The type indicates if the page was <code>DELIVERED</code> or <code>READ</code>.
         * </p>
         * 
         * @param acceptType
         *        The type indicates if the page was <code>DELIVERED</code> or <code>READ</code>.
         * @see AcceptType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AcceptType
         */
        Builder acceptType(AcceptType acceptType);

        /**
         * <p>
         * Information provided by the user when the user acknowledges the page.
         * </p>
         * 
         * @param note
         *        Information provided by the user when the user acknowledges the page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder note(String note);

        /**
         * <p>
         * The accept code is a 6-digit code used to acknowledge the page.
         * </p>
         * 
         * @param acceptCode
         *        The accept code is a 6-digit code used to acknowledge the page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptCode(String acceptCode);

        /**
         * <p>
         * An optional field that Incident Manager uses to <code>ENFORCE</code> <code>AcceptCode</code> validation when
         * acknowledging an page. Acknowledgement can occur by replying to a page, or when entering the AcceptCode in
         * the console. Enforcing AcceptCode validation causes Incident Manager to verify that the code entered by the
         * user matches the code sent by Incident Manager with the page.
         * </p>
         * <p>
         * Incident Manager can also <code>IGNORE</code> <code>AcceptCode</code> validation. Ignoring
         * <code>AcceptCode</code> validation causes Incident Manager to accept any value entered for the
         * <code>AcceptCode</code>.
         * </p>
         * 
         * @param acceptCodeValidation
         *        An optional field that Incident Manager uses to <code>ENFORCE</code> <code>AcceptCode</code>
         *        validation when acknowledging an page. Acknowledgement can occur by replying to a page, or when
         *        entering the AcceptCode in the console. Enforcing AcceptCode validation causes Incident Manager to
         *        verify that the code entered by the user matches the code sent by Incident Manager with the page.</p>
         *        <p>
         *        Incident Manager can also <code>IGNORE</code> <code>AcceptCode</code> validation. Ignoring
         *        <code>AcceptCode</code> validation causes Incident Manager to accept any value entered for the
         *        <code>AcceptCode</code>.
         * @see AcceptCodeValidation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AcceptCodeValidation
         */
        Builder acceptCodeValidation(String acceptCodeValidation);

        /**
         * <p>
         * An optional field that Incident Manager uses to <code>ENFORCE</code> <code>AcceptCode</code> validation when
         * acknowledging an page. Acknowledgement can occur by replying to a page, or when entering the AcceptCode in
         * the console. Enforcing AcceptCode validation causes Incident Manager to verify that the code entered by the
         * user matches the code sent by Incident Manager with the page.
         * </p>
         * <p>
         * Incident Manager can also <code>IGNORE</code> <code>AcceptCode</code> validation. Ignoring
         * <code>AcceptCode</code> validation causes Incident Manager to accept any value entered for the
         * <code>AcceptCode</code>.
         * </p>
         * 
         * @param acceptCodeValidation
         *        An optional field that Incident Manager uses to <code>ENFORCE</code> <code>AcceptCode</code>
         *        validation when acknowledging an page. Acknowledgement can occur by replying to a page, or when
         *        entering the AcceptCode in the console. Enforcing AcceptCode validation causes Incident Manager to
         *        verify that the code entered by the user matches the code sent by Incident Manager with the page.</p>
         *        <p>
         *        Incident Manager can also <code>IGNORE</code> <code>AcceptCode</code> validation. Ignoring
         *        <code>AcceptCode</code> validation causes Incident Manager to accept any value entered for the
         *        <code>AcceptCode</code>.
         * @see AcceptCodeValidation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AcceptCodeValidation
         */
        Builder acceptCodeValidation(AcceptCodeValidation acceptCodeValidation);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmContactsRequest.BuilderImpl implements Builder {
        private String pageId;

        private String contactChannelId;

        private String acceptType;

        private String note;

        private String acceptCode;

        private String acceptCodeValidation;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptPageRequest model) {
            super(model);
            pageId(model.pageId);
            contactChannelId(model.contactChannelId);
            acceptType(model.acceptType);
            note(model.note);
            acceptCode(model.acceptCode);
            acceptCodeValidation(model.acceptCodeValidation);
        }

        public final String getPageId() {
            return pageId;
        }

        public final void setPageId(String pageId) {
            this.pageId = pageId;
        }

        @Override
        @Transient
        public final Builder pageId(String pageId) {
            this.pageId = pageId;
            return this;
        }

        public final String getContactChannelId() {
            return contactChannelId;
        }

        public final void setContactChannelId(String contactChannelId) {
            this.contactChannelId = contactChannelId;
        }

        @Override
        @Transient
        public final Builder contactChannelId(String contactChannelId) {
            this.contactChannelId = contactChannelId;
            return this;
        }

        public final String getAcceptType() {
            return acceptType;
        }

        public final void setAcceptType(String acceptType) {
            this.acceptType = acceptType;
        }

        @Override
        @Transient
        public final Builder acceptType(String acceptType) {
            this.acceptType = acceptType;
            return this;
        }

        @Override
        @Transient
        public final Builder acceptType(AcceptType acceptType) {
            this.acceptType(acceptType == null ? null : acceptType.toString());
            return this;
        }

        public final String getNote() {
            return note;
        }

        public final void setNote(String note) {
            this.note = note;
        }

        @Override
        @Transient
        public final Builder note(String note) {
            this.note = note;
            return this;
        }

        public final String getAcceptCode() {
            return acceptCode;
        }

        public final void setAcceptCode(String acceptCode) {
            this.acceptCode = acceptCode;
        }

        @Override
        @Transient
        public final Builder acceptCode(String acceptCode) {
            this.acceptCode = acceptCode;
            return this;
        }

        public final String getAcceptCodeValidation() {
            return acceptCodeValidation;
        }

        public final void setAcceptCodeValidation(String acceptCodeValidation) {
            this.acceptCodeValidation = acceptCodeValidation;
        }

        @Override
        @Transient
        public final Builder acceptCodeValidation(String acceptCodeValidation) {
            this.acceptCodeValidation = acceptCodeValidation;
            return this;
        }

        @Override
        @Transient
        public final Builder acceptCodeValidation(AcceptCodeValidation acceptCodeValidation) {
            this.acceptCodeValidation(acceptCodeValidation == null ? null : acceptCodeValidation.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcceptPageRequest build() {
            return new AcceptPageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
