/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Records events during an engagement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Receipt implements SdkPojo, Serializable, ToCopyableBuilder<Receipt.Builder, Receipt> {
    private static final SdkField<String> CONTACT_CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactChannelArn").getter(getter(Receipt::contactChannelArn))
            .setter(setter(Builder::contactChannelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactChannelArn").build()).build();

    private static final SdkField<String> RECEIPT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReceiptType").getter(getter(Receipt::receiptTypeAsString)).setter(setter(Builder::receiptType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceiptType").build()).build();

    private static final SdkField<String> RECEIPT_INFO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReceiptInfo").getter(getter(Receipt::receiptInfo)).setter(setter(Builder::receiptInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceiptInfo").build()).build();

    private static final SdkField<Instant> RECEIPT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ReceiptTime").getter(getter(Receipt::receiptTime)).setter(setter(Builder::receiptTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceiptTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_CHANNEL_ARN_FIELD,
            RECEIPT_TYPE_FIELD, RECEIPT_INFO_FIELD, RECEIPT_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String contactChannelArn;

    private final String receiptType;

    private final String receiptInfo;

    private final Instant receiptTime;

    private Receipt(BuilderImpl builder) {
        this.contactChannelArn = builder.contactChannelArn;
        this.receiptType = builder.receiptType;
        this.receiptInfo = builder.receiptInfo;
        this.receiptTime = builder.receiptTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the contact channel Incident Manager engaged.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the contact channel Incident Manager engaged.
     */
    public final String contactChannelArn() {
        return contactChannelArn;
    }

    /**
     * <p>
     * The type follows the engagement cycle, <code>SENT</code>, <code>DELIVERED</code>, and <code>READ</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #receiptType} will
     * return {@link ReceiptType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #receiptTypeAsString}.
     * </p>
     * 
     * @return The type follows the engagement cycle, <code>SENT</code>, <code>DELIVERED</code>, and <code>READ</code>.
     * @see ReceiptType
     */
    public final ReceiptType receiptType() {
        return ReceiptType.fromValue(receiptType);
    }

    /**
     * <p>
     * The type follows the engagement cycle, <code>SENT</code>, <code>DELIVERED</code>, and <code>READ</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #receiptType} will
     * return {@link ReceiptType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #receiptTypeAsString}.
     * </p>
     * 
     * @return The type follows the engagement cycle, <code>SENT</code>, <code>DELIVERED</code>, and <code>READ</code>.
     * @see ReceiptType
     */
    public final String receiptTypeAsString() {
        return receiptType;
    }

    /**
     * <p>
     * Information provided during the page acknowledgement.
     * </p>
     * 
     * @return Information provided during the page acknowledgement.
     */
    public final String receiptInfo() {
        return receiptInfo;
    }

    /**
     * <p>
     * The time receipt was <code>SENT</code>, <code>DELIVERED</code>, or <code>READ</code>.
     * </p>
     * 
     * @return The time receipt was <code>SENT</code>, <code>DELIVERED</code>, or <code>READ</code>.
     */
    public final Instant receiptTime() {
        return receiptTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contactChannelArn());
        hashCode = 31 * hashCode + Objects.hashCode(receiptTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(receiptInfo());
        hashCode = 31 * hashCode + Objects.hashCode(receiptTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Receipt)) {
            return false;
        }
        Receipt other = (Receipt) obj;
        return Objects.equals(contactChannelArn(), other.contactChannelArn())
                && Objects.equals(receiptTypeAsString(), other.receiptTypeAsString())
                && Objects.equals(receiptInfo(), other.receiptInfo()) && Objects.equals(receiptTime(), other.receiptTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Receipt").add("ContactChannelArn", contactChannelArn())
                .add("ReceiptType", receiptTypeAsString()).add("ReceiptInfo", receiptInfo()).add("ReceiptTime", receiptTime())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactChannelArn":
            return Optional.ofNullable(clazz.cast(contactChannelArn()));
        case "ReceiptType":
            return Optional.ofNullable(clazz.cast(receiptTypeAsString()));
        case "ReceiptInfo":
            return Optional.ofNullable(clazz.cast(receiptInfo()));
        case "ReceiptTime":
            return Optional.ofNullable(clazz.cast(receiptTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Receipt, T> g) {
        return obj -> g.apply((Receipt) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Receipt> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the contact channel Incident Manager engaged.
         * </p>
         * 
         * @param contactChannelArn
         *        The Amazon Resource Name (ARN) of the contact channel Incident Manager engaged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactChannelArn(String contactChannelArn);

        /**
         * <p>
         * The type follows the engagement cycle, <code>SENT</code>, <code>DELIVERED</code>, and <code>READ</code>.
         * </p>
         * 
         * @param receiptType
         *        The type follows the engagement cycle, <code>SENT</code>, <code>DELIVERED</code>, and
         *        <code>READ</code>.
         * @see ReceiptType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReceiptType
         */
        Builder receiptType(String receiptType);

        /**
         * <p>
         * The type follows the engagement cycle, <code>SENT</code>, <code>DELIVERED</code>, and <code>READ</code>.
         * </p>
         * 
         * @param receiptType
         *        The type follows the engagement cycle, <code>SENT</code>, <code>DELIVERED</code>, and
         *        <code>READ</code>.
         * @see ReceiptType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReceiptType
         */
        Builder receiptType(ReceiptType receiptType);

        /**
         * <p>
         * Information provided during the page acknowledgement.
         * </p>
         * 
         * @param receiptInfo
         *        Information provided during the page acknowledgement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receiptInfo(String receiptInfo);

        /**
         * <p>
         * The time receipt was <code>SENT</code>, <code>DELIVERED</code>, or <code>READ</code>.
         * </p>
         * 
         * @param receiptTime
         *        The time receipt was <code>SENT</code>, <code>DELIVERED</code>, or <code>READ</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receiptTime(Instant receiptTime);
    }

    static final class BuilderImpl implements Builder {
        private String contactChannelArn;

        private String receiptType;

        private String receiptInfo;

        private Instant receiptTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Receipt model) {
            contactChannelArn(model.contactChannelArn);
            receiptType(model.receiptType);
            receiptInfo(model.receiptInfo);
            receiptTime(model.receiptTime);
        }

        public final String getContactChannelArn() {
            return contactChannelArn;
        }

        public final void setContactChannelArn(String contactChannelArn) {
            this.contactChannelArn = contactChannelArn;
        }

        @Override
        @Transient
        public final Builder contactChannelArn(String contactChannelArn) {
            this.contactChannelArn = contactChannelArn;
            return this;
        }

        public final String getReceiptType() {
            return receiptType;
        }

        public final void setReceiptType(String receiptType) {
            this.receiptType = receiptType;
        }

        @Override
        @Transient
        public final Builder receiptType(String receiptType) {
            this.receiptType = receiptType;
            return this;
        }

        @Override
        @Transient
        public final Builder receiptType(ReceiptType receiptType) {
            this.receiptType(receiptType == null ? null : receiptType.toString());
            return this;
        }

        public final String getReceiptInfo() {
            return receiptInfo;
        }

        public final void setReceiptInfo(String receiptInfo) {
            this.receiptInfo = receiptInfo;
        }

        @Override
        @Transient
        public final Builder receiptInfo(String receiptInfo) {
            this.receiptInfo = receiptInfo;
            return this;
        }

        public final Instant getReceiptTime() {
            return receiptTime;
        }

        public final void setReceiptTime(Instant receiptTime) {
            this.receiptTime = receiptTime;
        }

        @Override
        @Transient
        public final Builder receiptTime(Instant receiptTime) {
            this.receiptTime = receiptTime;
            return this;
        }

        @Override
        public Receipt build() {
            return new Receipt(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
