/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmcontacts.model.ChannelType;
import software.amazon.awssdk.services.ssmcontacts.model.ContactChannelAddress;
import software.amazon.awssdk.services.ssmcontacts.model.SsmContactsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateContactChannelRequest
extends SsmContactsRequest
implements ToCopyableBuilder<Builder, CreateContactChannelRequest> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactId").getter(CreateContactChannelRequest.getter(CreateContactChannelRequest::contactId)).setter(CreateContactChannelRequest.setter(Builder::contactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateContactChannelRequest.getter(CreateContactChannelRequest::name)).setter(CreateContactChannelRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CreateContactChannelRequest.getter(CreateContactChannelRequest::typeAsString)).setter(CreateContactChannelRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<ContactChannelAddress> DELIVERY_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeliveryAddress").getter(CreateContactChannelRequest.getter(CreateContactChannelRequest::deliveryAddress)).setter(CreateContactChannelRequest.setter(Builder::deliveryAddress)).constructor(ContactChannelAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryAddress").build()}).build();
    private static final SdkField<Boolean> DEFER_ACTIVATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeferActivation").getter(CreateContactChannelRequest.getter(CreateContactChannelRequest::deferActivation)).setter(CreateContactChannelRequest.setter(Builder::deferActivation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeferActivation").build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdempotencyToken").getter(CreateContactChannelRequest.getter(CreateContactChannelRequest::idempotencyToken)).setter(CreateContactChannelRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD, NAME_FIELD, TYPE_FIELD, DELIVERY_ADDRESS_FIELD, DEFER_ACTIVATION_FIELD, IDEMPOTENCY_TOKEN_FIELD));
    private final String contactId;
    private final String name;
    private final String type;
    private final ContactChannelAddress deliveryAddress;
    private final Boolean deferActivation;
    private final String idempotencyToken;

    private CreateContactChannelRequest(BuilderImpl builder) {
        super(builder);
        this.contactId = builder.contactId;
        this.name = builder.name;
        this.type = builder.type;
        this.deliveryAddress = builder.deliveryAddress;
        this.deferActivation = builder.deferActivation;
        this.idempotencyToken = builder.idempotencyToken;
    }

    public final String contactId() {
        return this.contactId;
    }

    public final String name() {
        return this.name;
    }

    public final ChannelType type() {
        return ChannelType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final ContactChannelAddress deliveryAddress() {
        return this.deliveryAddress;
    }

    public final Boolean deferActivation() {
        return this.deferActivation;
    }

    public final String idempotencyToken() {
        return this.idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.deferActivation());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContactChannelRequest)) {
            return false;
        }
        CreateContactChannelRequest other = (CreateContactChannelRequest)((Object)obj);
        return Objects.equals(this.contactId(), other.contactId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.deliveryAddress(), other.deliveryAddress()) && Objects.equals(this.deferActivation(), other.deferActivation()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateContactChannelRequest").add("ContactId", (Object)this.contactId()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("DeliveryAddress", (Object)this.deliveryAddress()).add("DeferActivation", (Object)this.deferActivation()).add("IdempotencyToken", (Object)this.idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactId": {
                return Optional.ofNullable(clazz.cast(this.contactId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "DeliveryAddress": {
                return Optional.ofNullable(clazz.cast(this.deliveryAddress()));
            }
            case "DeferActivation": {
                return Optional.ofNullable(clazz.cast(this.deferActivation()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateContactChannelRequest, T> g) {
        return obj -> g.apply((CreateContactChannelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmContactsRequest.BuilderImpl
    implements Builder {
        private String contactId;
        private String name;
        private String type;
        private ContactChannelAddress deliveryAddress;
        private Boolean deferActivation;
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContactChannelRequest model) {
            super(model);
            this.contactId(model.contactId);
            this.name(model.name);
            this.type(model.type);
            this.deliveryAddress(model.deliveryAddress);
            this.deferActivation(model.deferActivation);
            this.idempotencyToken(model.idempotencyToken);
        }

        public final String getContactId() {
            return this.contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        @Transient
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(ChannelType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final ContactChannelAddress.Builder getDeliveryAddress() {
            return this.deliveryAddress != null ? this.deliveryAddress.toBuilder() : null;
        }

        public final void setDeliveryAddress(ContactChannelAddress.BuilderImpl deliveryAddress) {
            this.deliveryAddress = deliveryAddress != null ? deliveryAddress.build() : null;
        }

        @Override
        @Transient
        public final Builder deliveryAddress(ContactChannelAddress deliveryAddress) {
            this.deliveryAddress = deliveryAddress;
            return this;
        }

        public final Boolean getDeferActivation() {
            return this.deferActivation;
        }

        public final void setDeferActivation(Boolean deferActivation) {
            this.deferActivation = deferActivation;
        }

        @Override
        @Transient
        public final Builder deferActivation(Boolean deferActivation) {
            this.deferActivation = deferActivation;
            return this;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        @Transient
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateContactChannelRequest build() {
            return new CreateContactChannelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmContactsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateContactChannelRequest> {
        public Builder contactId(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(ChannelType var1);

        public Builder deliveryAddress(ContactChannelAddress var1);

        default public Builder deliveryAddress(Consumer<ContactChannelAddress.Builder> deliveryAddress) {
            return this.deliveryAddress((ContactChannelAddress)((ContactChannelAddress.Builder)ContactChannelAddress.builder().applyMutation(deliveryAddress)).build());
        }

        public Builder deferActivation(Boolean var1);

        public Builder idempotencyToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

