/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateContactResponse extends SsmContactsResponse implements
        ToCopyableBuilder<CreateContactResponse.Builder, CreateContactResponse> {
    private static final SdkField<String> CONTACT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactArn").getter(getter(CreateContactResponse::contactArn)).setter(setter(Builder::contactArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ARN_FIELD));

    private final String contactArn;

    private CreateContactResponse(BuilderImpl builder) {
        super(builder);
        this.contactArn = builder.contactArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the created contact or escalation plan.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the created contact or escalation plan.
     */
    public final String contactArn() {
        return contactArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contactArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContactResponse)) {
            return false;
        }
        CreateContactResponse other = (CreateContactResponse) obj;
        return Objects.equals(contactArn(), other.contactArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateContactResponse").add("ContactArn", contactArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactArn":
            return Optional.ofNullable(clazz.cast(contactArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateContactResponse, T> g) {
        return obj -> g.apply((CreateContactResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmContactsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateContactResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the created contact or escalation plan.
         * </p>
         * 
         * @param contactArn
         *        The Amazon Resource Name (ARN) of the created contact or escalation plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactArn(String contactArn);
    }

    static final class BuilderImpl extends SsmContactsResponse.BuilderImpl implements Builder {
        private String contactArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContactResponse model) {
            super(model);
            contactArn(model.contactArn);
        }

        public final String getContactArn() {
            return contactArn;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        @Override
        public CreateContactResponse build() {
            return new CreateContactResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
