/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about when an on-call rotation shift begins or ends.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HandOffTime implements SdkPojo, Serializable, ToCopyableBuilder<HandOffTime.Builder, HandOffTime> {
    private static final SdkField<Integer> HOUR_OF_DAY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HourOfDay").getter(getter(HandOffTime::hourOfDay)).setter(setter(Builder::hourOfDay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HourOfDay").build()).build();

    private static final SdkField<Integer> MINUTE_OF_HOUR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinuteOfHour").getter(getter(HandOffTime::minuteOfHour)).setter(setter(Builder::minuteOfHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinuteOfHour").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOUR_OF_DAY_FIELD,
            MINUTE_OF_HOUR_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer hourOfDay;

    private final Integer minuteOfHour;

    private HandOffTime(BuilderImpl builder) {
        this.hourOfDay = builder.hourOfDay;
        this.minuteOfHour = builder.minuteOfHour;
    }

    /**
     * <p>
     * The hour when an on-call rotation shift begins or ends.
     * </p>
     * 
     * @return The hour when an on-call rotation shift begins or ends.
     */
    public final Integer hourOfDay() {
        return hourOfDay;
    }

    /**
     * <p>
     * The minute when an on-call rotation shift begins or ends.
     * </p>
     * 
     * @return The minute when an on-call rotation shift begins or ends.
     */
    public final Integer minuteOfHour() {
        return minuteOfHour;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hourOfDay());
        hashCode = 31 * hashCode + Objects.hashCode(minuteOfHour());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HandOffTime)) {
            return false;
        }
        HandOffTime other = (HandOffTime) obj;
        return Objects.equals(hourOfDay(), other.hourOfDay()) && Objects.equals(minuteOfHour(), other.minuteOfHour());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HandOffTime").add("HourOfDay", hourOfDay()).add("MinuteOfHour", minuteOfHour()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HourOfDay":
            return Optional.ofNullable(clazz.cast(hourOfDay()));
        case "MinuteOfHour":
            return Optional.ofNullable(clazz.cast(minuteOfHour()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HandOffTime, T> g) {
        return obj -> g.apply((HandOffTime) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HandOffTime> {
        /**
         * <p>
         * The hour when an on-call rotation shift begins or ends.
         * </p>
         * 
         * @param hourOfDay
         *        The hour when an on-call rotation shift begins or ends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hourOfDay(Integer hourOfDay);

        /**
         * <p>
         * The minute when an on-call rotation shift begins or ends.
         * </p>
         * 
         * @param minuteOfHour
         *        The minute when an on-call rotation shift begins or ends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minuteOfHour(Integer minuteOfHour);
    }

    static final class BuilderImpl implements Builder {
        private Integer hourOfDay;

        private Integer minuteOfHour;

        private BuilderImpl() {
        }

        private BuilderImpl(HandOffTime model) {
            hourOfDay(model.hourOfDay);
            minuteOfHour(model.minuteOfHour);
        }

        public final Integer getHourOfDay() {
            return hourOfDay;
        }

        public final void setHourOfDay(Integer hourOfDay) {
            this.hourOfDay = hourOfDay;
        }

        @Override
        public final Builder hourOfDay(Integer hourOfDay) {
            this.hourOfDay = hourOfDay;
            return this;
        }

        public final Integer getMinuteOfHour() {
            return minuteOfHour;
        }

        public final void setMinuteOfHour(Integer minuteOfHour) {
            this.minuteOfHour = minuteOfHour;
        }

        @Override
        public final Builder minuteOfHour(Integer minuteOfHour) {
            this.minuteOfHour = minuteOfHour;
            return this;
        }

        @Override
        public HandOffTime build() {
            return new HandOffTime(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
