/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmcontacts.SsmContactsAsyncClient;
import software.amazon.awssdk.services.ssmcontacts.model.ListPagesByEngagementRequest;
import software.amazon.awssdk.services.ssmcontacts.model.ListPagesByEngagementResponse;
import software.amazon.awssdk.services.ssmcontacts.model.Page;

public class ListPagesByEngagementPublisher
implements SdkPublisher<ListPagesByEngagementResponse> {
    private final SsmContactsAsyncClient client;
    private final ListPagesByEngagementRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPagesByEngagementPublisher(SsmContactsAsyncClient client, ListPagesByEngagementRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPagesByEngagementPublisher(SsmContactsAsyncClient client, ListPagesByEngagementRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPagesByEngagementResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPagesByEngagementResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Page> pages() {
        Function<ListPagesByEngagementResponse, Iterator> getIterator = response -> {
            if (response != null && response.pages() != null) {
                return response.pages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPagesByEngagementResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPagesByEngagementResponseFetcher
    implements AsyncPageFetcher<ListPagesByEngagementResponse> {
        private ListPagesByEngagementResponseFetcher() {
        }

        public boolean hasNextPage(ListPagesByEngagementResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPagesByEngagementResponse> nextPage(ListPagesByEngagementResponse previousPage) {
            if (previousPage == null) {
                return ListPagesByEngagementPublisher.this.client.listPagesByEngagement(ListPagesByEngagementPublisher.this.firstRequest);
            }
            return ListPagesByEngagementPublisher.this.client.listPagesByEngagement((ListPagesByEngagementRequest)((Object)ListPagesByEngagementPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

