/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmcontacts.SsmContactsAsyncClient;
import software.amazon.awssdk.services.ssmcontacts.model.ListRotationShiftsRequest;
import software.amazon.awssdk.services.ssmcontacts.model.ListRotationShiftsResponse;
import software.amazon.awssdk.services.ssmcontacts.model.RotationShift;

public class ListRotationShiftsPublisher
implements SdkPublisher<ListRotationShiftsResponse> {
    private final SsmContactsAsyncClient client;
    private final ListRotationShiftsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRotationShiftsPublisher(SsmContactsAsyncClient client, ListRotationShiftsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRotationShiftsPublisher(SsmContactsAsyncClient client, ListRotationShiftsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRotationShiftsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRotationShiftsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RotationShift> rotationShifts() {
        Function<ListRotationShiftsResponse, Iterator> getIterator = response -> {
            if (response != null && response.rotationShifts() != null) {
                return response.rotationShifts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRotationShiftsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRotationShiftsResponseFetcher
    implements AsyncPageFetcher<ListRotationShiftsResponse> {
        private ListRotationShiftsResponseFetcher() {
        }

        public boolean hasNextPage(ListRotationShiftsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRotationShiftsResponse> nextPage(ListRotationShiftsResponse previousPage) {
            if (previousPage == null) {
                return ListRotationShiftsPublisher.this.client.listRotationShifts(ListRotationShiftsPublisher.this.firstRequest);
            }
            return ListRotationShiftsPublisher.this.client.listRotationShifts((ListRotationShiftsRequest)((Object)ListRotationShiftsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

