/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an override specified for an on-call rotation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RotationOverride implements SdkPojo, Serializable,
        ToCopyableBuilder<RotationOverride.Builder, RotationOverride> {
    private static final SdkField<String> ROTATION_OVERRIDE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RotationOverrideId").getter(getter(RotationOverride::rotationOverrideId))
            .setter(setter(Builder::rotationOverrideId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationOverrideId").build())
            .build();

    private static final SdkField<List<String>> NEW_CONTACT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NewContactIds")
            .getter(getter(RotationOverride::newContactIds))
            .setter(setter(Builder::newContactIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewContactIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(RotationOverride::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(RotationOverride::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime").getter(getter(RotationOverride::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROTATION_OVERRIDE_ID_FIELD,
            NEW_CONTACT_IDS_FIELD, START_TIME_FIELD, END_TIME_FIELD, CREATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String rotationOverrideId;

    private final List<String> newContactIds;

    private final Instant startTime;

    private final Instant endTime;

    private final Instant createTime;

    private RotationOverride(BuilderImpl builder) {
        this.rotationOverrideId = builder.rotationOverrideId;
        this.newContactIds = builder.newContactIds;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.createTime = builder.createTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the override to an on-call rotation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the override to an on-call rotation.
     */
    public final String rotationOverrideId() {
        return rotationOverrideId;
    }

    /**
     * For responses, this returns true if the service returned a value for the NewContactIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNewContactIds() {
        return newContactIds != null && !(newContactIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of the contacts assigned to the override of the on-call rotation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNewContactIds} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of the contacts assigned to the override of the on-call rotation.
     */
    public final List<String> newContactIds() {
        return newContactIds;
    }

    /**
     * <p>
     * The time a rotation override begins.
     * </p>
     * 
     * @return The time a rotation override begins.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time a rotation override ends.
     * </p>
     * 
     * @return The time a rotation override ends.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The time a rotation override was created.
     * </p>
     * 
     * @return The time a rotation override was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rotationOverrideId());
        hashCode = 31 * hashCode + Objects.hashCode(hasNewContactIds() ? newContactIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RotationOverride)) {
            return false;
        }
        RotationOverride other = (RotationOverride) obj;
        return Objects.equals(rotationOverrideId(), other.rotationOverrideId()) && hasNewContactIds() == other.hasNewContactIds()
                && Objects.equals(newContactIds(), other.newContactIds()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(createTime(), other.createTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RotationOverride").add("RotationOverrideId", rotationOverrideId())
                .add("NewContactIds", hasNewContactIds() ? newContactIds() : null).add("StartTime", startTime())
                .add("EndTime", endTime()).add("CreateTime", createTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RotationOverrideId":
            return Optional.ofNullable(clazz.cast(rotationOverrideId()));
        case "NewContactIds":
            return Optional.ofNullable(clazz.cast(newContactIds()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RotationOverride, T> g) {
        return obj -> g.apply((RotationOverride) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RotationOverride> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the override to an on-call rotation.
         * </p>
         * 
         * @param rotationOverrideId
         *        The Amazon Resource Name (ARN) of the override to an on-call rotation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationOverrideId(String rotationOverrideId);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the contacts assigned to the override of the on-call rotation.
         * </p>
         * 
         * @param newContactIds
         *        The Amazon Resource Names (ARNs) of the contacts assigned to the override of the on-call rotation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newContactIds(Collection<String> newContactIds);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the contacts assigned to the override of the on-call rotation.
         * </p>
         * 
         * @param newContactIds
         *        The Amazon Resource Names (ARNs) of the contacts assigned to the override of the on-call rotation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newContactIds(String... newContactIds);

        /**
         * <p>
         * The time a rotation override begins.
         * </p>
         * 
         * @param startTime
         *        The time a rotation override begins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time a rotation override ends.
         * </p>
         * 
         * @param endTime
         *        The time a rotation override ends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The time a rotation override was created.
         * </p>
         * 
         * @param createTime
         *        The time a rotation override was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);
    }

    static final class BuilderImpl implements Builder {
        private String rotationOverrideId;

        private List<String> newContactIds = DefaultSdkAutoConstructList.getInstance();

        private Instant startTime;

        private Instant endTime;

        private Instant createTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RotationOverride model) {
            rotationOverrideId(model.rotationOverrideId);
            newContactIds(model.newContactIds);
            startTime(model.startTime);
            endTime(model.endTime);
            createTime(model.createTime);
        }

        public final String getRotationOverrideId() {
            return rotationOverrideId;
        }

        public final void setRotationOverrideId(String rotationOverrideId) {
            this.rotationOverrideId = rotationOverrideId;
        }

        @Override
        public final Builder rotationOverrideId(String rotationOverrideId) {
            this.rotationOverrideId = rotationOverrideId;
            return this;
        }

        public final Collection<String> getNewContactIds() {
            if (newContactIds instanceof SdkAutoConstructList) {
                return null;
            }
            return newContactIds;
        }

        public final void setNewContactIds(Collection<String> newContactIds) {
            this.newContactIds = SsmContactsArnListCopier.copy(newContactIds);
        }

        @Override
        public final Builder newContactIds(Collection<String> newContactIds) {
            this.newContactIds = SsmContactsArnListCopier.copy(newContactIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder newContactIds(String... newContactIds) {
            newContactIds(Arrays.asList(newContactIds));
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        @Override
        public RotationOverride build() {
            return new RotationOverride(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
