/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmcontacts.model.ResolutionContact;
import software.amazon.awssdk.services.ssmcontacts.model.ResolutionListCopier;
import software.amazon.awssdk.services.ssmcontacts.model.SsmContactsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPageResolutionsResponse
extends SsmContactsResponse
implements ToCopyableBuilder<Builder, ListPageResolutionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPageResolutionsResponse.getter(ListPageResolutionsResponse::nextToken)).setter(ListPageResolutionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ResolutionContact>> PAGE_RESOLUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PageResolutions").getter(ListPageResolutionsResponse.getter(ListPageResolutionsResponse::pageResolutions)).setter(ListPageResolutionsResponse.setter(Builder::pageResolutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageResolutions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResolutionContact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PAGE_RESOLUTIONS_FIELD));
    private final String nextToken;
    private final List<ResolutionContact> pageResolutions;

    private ListPageResolutionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.pageResolutions = builder.pageResolutions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasPageResolutions() {
        return this.pageResolutions != null && !(this.pageResolutions instanceof SdkAutoConstructList);
    }

    public final List<ResolutionContact> pageResolutions() {
        return this.pageResolutions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPageResolutions() ? this.pageResolutions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPageResolutionsResponse)) {
            return false;
        }
        ListPageResolutionsResponse other = (ListPageResolutionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasPageResolutions() == other.hasPageResolutions() && Objects.equals(this.pageResolutions(), other.pageResolutions());
    }

    public final String toString() {
        return ToString.builder((String)"ListPageResolutionsResponse").add("NextToken", (Object)this.nextToken()).add("PageResolutions", this.hasPageResolutions() ? this.pageResolutions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "PageResolutions": {
                return Optional.ofNullable(clazz.cast(this.pageResolutions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPageResolutionsResponse, T> g) {
        return obj -> g.apply((ListPageResolutionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmContactsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ResolutionContact> pageResolutions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPageResolutionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.pageResolutions(model.pageResolutions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ResolutionContact.Builder> getPageResolutions() {
            List<ResolutionContact.Builder> result = ResolutionListCopier.copyToBuilder(this.pageResolutions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPageResolutions(Collection<ResolutionContact.BuilderImpl> pageResolutions) {
            this.pageResolutions = ResolutionListCopier.copyFromBuilder(pageResolutions);
        }

        @Override
        public final Builder pageResolutions(Collection<ResolutionContact> pageResolutions) {
            this.pageResolutions = ResolutionListCopier.copy(pageResolutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pageResolutions(ResolutionContact ... pageResolutions) {
            this.pageResolutions(Arrays.asList(pageResolutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pageResolutions(Consumer<ResolutionContact.Builder> ... pageResolutions) {
            this.pageResolutions(Stream.of(pageResolutions).map(c -> (ResolutionContact)((ResolutionContact.Builder)ResolutionContact.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPageResolutionsResponse build() {
            return new ListPageResolutionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmContactsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPageResolutionsResponse> {
        public Builder nextToken(String var1);

        public Builder pageResolutions(Collection<ResolutionContact> var1);

        public Builder pageResolutions(ResolutionContact ... var1);

        public Builder pageResolutions(Consumer<ResolutionContact.Builder> ... var1);
    }
}

