/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmcontacts.SsmContactsAsyncClient;
import software.amazon.awssdk.services.ssmcontacts.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmcontacts.model.ListPreviewRotationShiftsRequest;
import software.amazon.awssdk.services.ssmcontacts.model.ListPreviewRotationShiftsResponse;
import software.amazon.awssdk.services.ssmcontacts.model.RotationShift;

public class ListPreviewRotationShiftsPublisher
implements SdkPublisher<ListPreviewRotationShiftsResponse> {
    private final SsmContactsAsyncClient client;
    private final ListPreviewRotationShiftsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPreviewRotationShiftsPublisher(SsmContactsAsyncClient client, ListPreviewRotationShiftsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPreviewRotationShiftsPublisher(SsmContactsAsyncClient client, ListPreviewRotationShiftsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPreviewRotationShiftsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPreviewRotationShiftsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RotationShift> rotationShifts() {
        Function<ListPreviewRotationShiftsResponse, Iterator> getIterator = response -> {
            if (response != null && response.rotationShifts() != null) {
                return response.rotationShifts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPreviewRotationShiftsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPreviewRotationShiftsResponseFetcher
    implements AsyncPageFetcher<ListPreviewRotationShiftsResponse> {
        private ListPreviewRotationShiftsResponseFetcher() {
        }

        public boolean hasNextPage(ListPreviewRotationShiftsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPreviewRotationShiftsResponse> nextPage(ListPreviewRotationShiftsResponse previousPage) {
            if (previousPage == null) {
                return ListPreviewRotationShiftsPublisher.this.client.listPreviewRotationShifts(ListPreviewRotationShiftsPublisher.this.firstRequest);
            }
            return ListPreviewRotationShiftsPublisher.this.client.listPreviewRotationShifts((ListPreviewRotationShiftsRequest)((Object)ListPreviewRotationShiftsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

