/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmcontacts.model.RotationOverride;
import software.amazon.awssdk.services.ssmcontacts.model.RotationOverridesCopier;
import software.amazon.awssdk.services.ssmcontacts.model.SsmContactsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRotationOverridesResponse
extends SsmContactsResponse
implements ToCopyableBuilder<Builder, ListRotationOverridesResponse> {
    private static final SdkField<List<RotationOverride>> ROTATION_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RotationOverrides").getter(ListRotationOverridesResponse.getter(ListRotationOverridesResponse::rotationOverrides)).setter(ListRotationOverridesResponse.setter(Builder::rotationOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationOverrides").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RotationOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRotationOverridesResponse.getter(ListRotationOverridesResponse::nextToken)).setter(ListRotationOverridesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROTATION_OVERRIDES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RotationOverrides", ROTATION_OVERRIDES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<RotationOverride> rotationOverrides;
    private final String nextToken;

    private ListRotationOverridesResponse(BuilderImpl builder) {
        super(builder);
        this.rotationOverrides = builder.rotationOverrides;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRotationOverrides() {
        return this.rotationOverrides != null && !(this.rotationOverrides instanceof SdkAutoConstructList);
    }

    public final List<RotationOverride> rotationOverrides() {
        return this.rotationOverrides;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRotationOverrides() ? this.rotationOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRotationOverridesResponse)) {
            return false;
        }
        ListRotationOverridesResponse other = (ListRotationOverridesResponse)((Object)obj);
        return this.hasRotationOverrides() == other.hasRotationOverrides() && Objects.equals(this.rotationOverrides(), other.rotationOverrides()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRotationOverridesResponse").add("RotationOverrides", this.hasRotationOverrides() ? this.rotationOverrides() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RotationOverrides": {
                return Optional.ofNullable(clazz.cast(this.rotationOverrides()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListRotationOverridesResponse, T> g) {
        return obj -> g.apply((ListRotationOverridesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmContactsResponse.BuilderImpl
    implements Builder {
        private List<RotationOverride> rotationOverrides = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRotationOverridesResponse model) {
            super(model);
            this.rotationOverrides(model.rotationOverrides);
            this.nextToken(model.nextToken);
        }

        public final List<RotationOverride.Builder> getRotationOverrides() {
            List<RotationOverride.Builder> result = RotationOverridesCopier.copyToBuilder(this.rotationOverrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRotationOverrides(Collection<RotationOverride.BuilderImpl> rotationOverrides) {
            this.rotationOverrides = RotationOverridesCopier.copyFromBuilder(rotationOverrides);
        }

        @Override
        public final Builder rotationOverrides(Collection<RotationOverride> rotationOverrides) {
            this.rotationOverrides = RotationOverridesCopier.copy(rotationOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rotationOverrides(RotationOverride ... rotationOverrides) {
            this.rotationOverrides(Arrays.asList(rotationOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rotationOverrides(Consumer<RotationOverride.Builder> ... rotationOverrides) {
            this.rotationOverrides(Stream.of(rotationOverrides).map(c -> (RotationOverride)((RotationOverride.Builder)RotationOverride.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRotationOverridesResponse build() {
            return new ListRotationOverridesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmContactsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRotationOverridesResponse> {
        public Builder rotationOverrides(Collection<RotationOverride> var1);

        public Builder rotationOverrides(RotationOverride ... var1);

        public Builder rotationOverrides(Consumer<RotationOverride.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

