/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updating or deleting a resource causes an inconsistent state.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConflictException extends SsmContactsException implements
        ToCopyableBuilder<ConflictException.Builder, ConflictException> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(ConflictException::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ConflictException::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<List<DependentEntity>> DEPENDENT_ENTITIES_FIELD = SdkField
            .<List<DependentEntity>> builder(MarshallingType.LIST)
            .memberName("DependentEntities")
            .getter(getter(ConflictException::dependentEntities))
            .setter(setter(Builder::dependentEntities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DependentEntities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DependentEntity> builder(MarshallingType.SDK_POJO)
                                            .constructor(DependentEntity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            RESOURCE_TYPE_FIELD, DEPENDENT_ENTITIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceId;

    private final String resourceType;

    private final List<DependentEntity> dependentEntities;

    private ConflictException(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.dependentEntities = builder.dependentEntities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Identifier of the resource in use
     * 
     * @return Identifier of the resource in use
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * Type of the resource in use
     * 
     * @return Type of the resource in use
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the DependentEntities property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public boolean hasDependentEntities() {
        return dependentEntities != null && !(dependentEntities instanceof SdkAutoConstructList);
    }

    /**
     * List of dependent entities containing information on relation type and resourceArns linked to the resource in use
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDependentEntities} method.
     * </p>
     * 
     * @return List of dependent entities containing information on relation type and resourceArns linked to the
     *         resource in use
     */
    public List<DependentEntity> dependentEntities() {
        return dependentEntities;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("DependentEntities", DEPENDENT_ENTITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConflictException, T> g) {
        return obj -> g.apply((ConflictException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConflictException>, SsmContactsException.Builder {
        /**
         * Identifier of the resource in use
         * 
         * @param resourceId
         *        Identifier of the resource in use
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * Type of the resource in use
         * 
         * @param resourceType
         *        Type of the resource in use
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * List of dependent entities containing information on relation type and resourceArns linked to the resource in
         * use
         * 
         * @param dependentEntities
         *        List of dependent entities containing information on relation type and resourceArns linked to the
         *        resource in use
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependentEntities(Collection<DependentEntity> dependentEntities);

        /**
         * List of dependent entities containing information on relation type and resourceArns linked to the resource in
         * use
         * 
         * @param dependentEntities
         *        List of dependent entities containing information on relation type and resourceArns linked to the
         *        resource in use
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependentEntities(DependentEntity... dependentEntities);

        /**
         * List of dependent entities containing information on relation type and resourceArns linked to the resource in
         * use This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmcontacts.model.DependentEntity.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ssmcontacts.model.DependentEntity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmcontacts.model.DependentEntity.Builder#build()} is called
         * immediately and its result is passed to {@link #dependentEntities(List<DependentEntity>)}.
         * 
         * @param dependentEntities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmcontacts.model.DependentEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dependentEntities(java.util.Collection<DependentEntity>)
         */
        Builder dependentEntities(Consumer<DependentEntity.Builder>... dependentEntities);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends SsmContactsException.BuilderImpl implements Builder {
        private String resourceId;

        private String resourceType;

        private List<DependentEntity> dependentEntities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConflictException model) {
            super(model);
            resourceId(model.resourceId);
            resourceType(model.resourceType);
            dependentEntities(model.dependentEntities);
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final List<DependentEntity.Builder> getDependentEntities() {
            List<DependentEntity.Builder> result = DependentEntityListCopier.copyToBuilder(this.dependentEntities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDependentEntities(Collection<DependentEntity.BuilderImpl> dependentEntities) {
            this.dependentEntities = DependentEntityListCopier.copyFromBuilder(dependentEntities);
        }

        @Override
        public final Builder dependentEntities(Collection<DependentEntity> dependentEntities) {
            this.dependentEntities = DependentEntityListCopier.copy(dependentEntities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependentEntities(DependentEntity... dependentEntities) {
            dependentEntities(Arrays.asList(dependentEntities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependentEntities(Consumer<DependentEntity.Builder>... dependentEntities) {
            dependentEntities(Stream.of(dependentEntities).map(c -> DependentEntity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public ConflictException build() {
            return new ConflictException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
