/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A personal contact or escalation plan that Incident Manager engages during an incident.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Contact implements SdkPojo, Serializable, ToCopyableBuilder<Contact.Builder, Contact> {
    private static final SdkField<String> CONTACT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactArn").getter(getter(Contact::contactArn)).setter(setter(Builder::contactArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactArn").build()).build();

    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Alias")
            .getter(getter(Contact::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(Contact::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Contact::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ARN_FIELD,
            ALIAS_FIELD, DISPLAY_NAME_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String contactArn;

    private final String alias;

    private final String displayName;

    private final String type;

    private Contact(BuilderImpl builder) {
        this.contactArn = builder.contactArn;
        this.alias = builder.alias;
        this.displayName = builder.displayName;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the contact or escalation plan.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the contact or escalation plan.
     */
    public final String contactArn() {
        return contactArn;
    }

    /**
     * <p>
     * The unique and identifiable alias of the contact or escalation plan.
     * </p>
     * 
     * @return The unique and identifiable alias of the contact or escalation plan.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * The full name of the contact or escalation plan.
     * </p>
     * 
     * @return The full name of the contact or escalation plan.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * Refers to the type of contact. A single contact is type <code>PERSONAL</code> and an escalation plan is type
     * <code>ESCALATION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ContactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Refers to the type of contact. A single contact is type <code>PERSONAL</code> and an escalation plan is
     *         type <code>ESCALATION</code>.
     * @see ContactType
     */
    public final ContactType type() {
        return ContactType.fromValue(type);
    }

    /**
     * <p>
     * Refers to the type of contact. A single contact is type <code>PERSONAL</code> and an escalation plan is type
     * <code>ESCALATION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ContactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Refers to the type of contact. A single contact is type <code>PERSONAL</code> and an escalation plan is
     *         type <code>ESCALATION</code>.
     * @see ContactType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contactArn());
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Contact)) {
            return false;
        }
        Contact other = (Contact) obj;
        return Objects.equals(contactArn(), other.contactArn()) && Objects.equals(alias(), other.alias())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Contact").add("ContactArn", contactArn()).add("Alias", alias())
                .add("DisplayName", displayName()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactArn":
            return Optional.ofNullable(clazz.cast(contactArn()));
        case "Alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContactArn", CONTACT_ARN_FIELD);
        map.put("Alias", ALIAS_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Contact, T> g) {
        return obj -> g.apply((Contact) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Contact> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the contact or escalation plan.
         * </p>
         * 
         * @param contactArn
         *        The Amazon Resource Name (ARN) of the contact or escalation plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactArn(String contactArn);

        /**
         * <p>
         * The unique and identifiable alias of the contact or escalation plan.
         * </p>
         * 
         * @param alias
         *        The unique and identifiable alias of the contact or escalation plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * The full name of the contact or escalation plan.
         * </p>
         * 
         * @param displayName
         *        The full name of the contact or escalation plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * Refers to the type of contact. A single contact is type <code>PERSONAL</code> and an escalation plan is type
         * <code>ESCALATION</code>.
         * </p>
         * 
         * @param type
         *        Refers to the type of contact. A single contact is type <code>PERSONAL</code> and an escalation plan
         *        is type <code>ESCALATION</code>.
         * @see ContactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactType
         */
        Builder type(String type);

        /**
         * <p>
         * Refers to the type of contact. A single contact is type <code>PERSONAL</code> and an escalation plan is type
         * <code>ESCALATION</code>.
         * </p>
         * 
         * @param type
         *        Refers to the type of contact. A single contact is type <code>PERSONAL</code> and an escalation plan
         *        is type <code>ESCALATION</code>.
         * @see ContactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactType
         */
        Builder type(ContactType type);
    }

    static final class BuilderImpl implements Builder {
        private String contactArn;

        private String alias;

        private String displayName;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Contact model) {
            contactArn(model.contactArn);
            alias(model.alias);
            displayName(model.displayName);
            type(model.type);
        }

        public final String getContactArn() {
            return contactArn;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ContactType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Contact build() {
            return new Contact(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
