/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEngagementResponse extends SsmContactsResponse implements
        ToCopyableBuilder<DescribeEngagementResponse.Builder, DescribeEngagementResponse> {
    private static final SdkField<String> CONTACT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactArn").getter(getter(DescribeEngagementResponse::contactArn)).setter(setter(Builder::contactArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactArn").build()).build();

    private static final SdkField<String> ENGAGEMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngagementArn").getter(getter(DescribeEngagementResponse::engagementArn))
            .setter(setter(Builder::engagementArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementArn").build()).build();

    private static final SdkField<String> SENDER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Sender")
            .getter(getter(DescribeEngagementResponse::sender)).setter(setter(Builder::sender))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sender").build()).build();

    private static final SdkField<String> SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Subject")
            .getter(getter(DescribeEngagementResponse::subject)).setter(setter(Builder::subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(DescribeEngagementResponse::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<String> PUBLIC_SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicSubject").getter(getter(DescribeEngagementResponse::publicSubject))
            .setter(setter(Builder::publicSubject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicSubject").build()).build();

    private static final SdkField<String> PUBLIC_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicContent").getter(getter(DescribeEngagementResponse::publicContent))
            .setter(setter(Builder::publicContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicContent").build()).build();

    private static final SdkField<String> INCIDENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IncidentId").getter(getter(DescribeEngagementResponse::incidentId)).setter(setter(Builder::incidentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncidentId").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(DescribeEngagementResponse::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> STOP_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StopTime").getter(getter(DescribeEngagementResponse::stopTime)).setter(setter(Builder::stopTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ARN_FIELD,
            ENGAGEMENT_ARN_FIELD, SENDER_FIELD, SUBJECT_FIELD, CONTENT_FIELD, PUBLIC_SUBJECT_FIELD, PUBLIC_CONTENT_FIELD,
            INCIDENT_ID_FIELD, START_TIME_FIELD, STOP_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String contactArn;

    private final String engagementArn;

    private final String sender;

    private final String subject;

    private final String content;

    private final String publicSubject;

    private final String publicContent;

    private final String incidentId;

    private final Instant startTime;

    private final Instant stopTime;

    private DescribeEngagementResponse(BuilderImpl builder) {
        super(builder);
        this.contactArn = builder.contactArn;
        this.engagementArn = builder.engagementArn;
        this.sender = builder.sender;
        this.subject = builder.subject;
        this.content = builder.content;
        this.publicSubject = builder.publicSubject;
        this.publicContent = builder.publicContent;
        this.incidentId = builder.incidentId;
        this.startTime = builder.startTime;
        this.stopTime = builder.stopTime;
    }

    /**
     * <p>
     * The ARN of the escalation plan or contacts involved in the engagement.
     * </p>
     * 
     * @return The ARN of the escalation plan or contacts involved in the engagement.
     */
    public final String contactArn() {
        return contactArn;
    }

    /**
     * <p>
     * The ARN of the engagement.
     * </p>
     * 
     * @return The ARN of the engagement.
     */
    public final String engagementArn() {
        return engagementArn;
    }

    /**
     * <p>
     * The user that started the engagement.
     * </p>
     * 
     * @return The user that started the engagement.
     */
    public final String sender() {
        return sender;
    }

    /**
     * <p>
     * The secure subject of the message that was sent to the contact. Use this field for engagements to
     * <code>VOICE</code> and <code>EMAIL</code>.
     * </p>
     * 
     * @return The secure subject of the message that was sent to the contact. Use this field for engagements to
     *         <code>VOICE</code> and <code>EMAIL</code>.
     */
    public final String subject() {
        return subject;
    }

    /**
     * <p>
     * The secure content of the message that was sent to the contact. Use this field for engagements to
     * <code>VOICE</code> and <code>EMAIL</code>.
     * </p>
     * 
     * @return The secure content of the message that was sent to the contact. Use this field for engagements to
     *         <code>VOICE</code> and <code>EMAIL</code>.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * The insecure subject of the message that was sent to the contact. Use this field for engagements to
     * <code>SMS</code>.
     * </p>
     * 
     * @return The insecure subject of the message that was sent to the contact. Use this field for engagements to
     *         <code>SMS</code>.
     */
    public final String publicSubject() {
        return publicSubject;
    }

    /**
     * <p>
     * The insecure content of the message that was sent to the contact. Use this field for engagements to
     * <code>SMS</code>.
     * </p>
     * 
     * @return The insecure content of the message that was sent to the contact. Use this field for engagements to
     *         <code>SMS</code>.
     */
    public final String publicContent() {
        return publicContent;
    }

    /**
     * <p>
     * The ARN of the incident in which the engagement occurred.
     * </p>
     * 
     * @return The ARN of the incident in which the engagement occurred.
     */
    public final String incidentId() {
        return incidentId;
    }

    /**
     * <p>
     * The time that the engagement started.
     * </p>
     * 
     * @return The time that the engagement started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time that the engagement ended.
     * </p>
     * 
     * @return The time that the engagement ended.
     */
    public final Instant stopTime() {
        return stopTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contactArn());
        hashCode = 31 * hashCode + Objects.hashCode(engagementArn());
        hashCode = 31 * hashCode + Objects.hashCode(sender());
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(publicSubject());
        hashCode = 31 * hashCode + Objects.hashCode(publicContent());
        hashCode = 31 * hashCode + Objects.hashCode(incidentId());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(stopTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEngagementResponse)) {
            return false;
        }
        DescribeEngagementResponse other = (DescribeEngagementResponse) obj;
        return Objects.equals(contactArn(), other.contactArn()) && Objects.equals(engagementArn(), other.engagementArn())
                && Objects.equals(sender(), other.sender()) && Objects.equals(subject(), other.subject())
                && Objects.equals(content(), other.content()) && Objects.equals(publicSubject(), other.publicSubject())
                && Objects.equals(publicContent(), other.publicContent()) && Objects.equals(incidentId(), other.incidentId())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(stopTime(), other.stopTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEngagementResponse").add("ContactArn", contactArn())
                .add("EngagementArn", engagementArn()).add("Sender", sender()).add("Subject", subject())
                .add("Content", content()).add("PublicSubject", publicSubject()).add("PublicContent", publicContent())
                .add("IncidentId", incidentId()).add("StartTime", startTime()).add("StopTime", stopTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactArn":
            return Optional.ofNullable(clazz.cast(contactArn()));
        case "EngagementArn":
            return Optional.ofNullable(clazz.cast(engagementArn()));
        case "Sender":
            return Optional.ofNullable(clazz.cast(sender()));
        case "Subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "PublicSubject":
            return Optional.ofNullable(clazz.cast(publicSubject()));
        case "PublicContent":
            return Optional.ofNullable(clazz.cast(publicContent()));
        case "IncidentId":
            return Optional.ofNullable(clazz.cast(incidentId()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "StopTime":
            return Optional.ofNullable(clazz.cast(stopTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContactArn", CONTACT_ARN_FIELD);
        map.put("EngagementArn", ENGAGEMENT_ARN_FIELD);
        map.put("Sender", SENDER_FIELD);
        map.put("Subject", SUBJECT_FIELD);
        map.put("Content", CONTENT_FIELD);
        map.put("PublicSubject", PUBLIC_SUBJECT_FIELD);
        map.put("PublicContent", PUBLIC_CONTENT_FIELD);
        map.put("IncidentId", INCIDENT_ID_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("StopTime", STOP_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEngagementResponse, T> g) {
        return obj -> g.apply((DescribeEngagementResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmContactsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEngagementResponse> {
        /**
         * <p>
         * The ARN of the escalation plan or contacts involved in the engagement.
         * </p>
         * 
         * @param contactArn
         *        The ARN of the escalation plan or contacts involved in the engagement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactArn(String contactArn);

        /**
         * <p>
         * The ARN of the engagement.
         * </p>
         * 
         * @param engagementArn
         *        The ARN of the engagement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementArn(String engagementArn);

        /**
         * <p>
         * The user that started the engagement.
         * </p>
         * 
         * @param sender
         *        The user that started the engagement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sender(String sender);

        /**
         * <p>
         * The secure subject of the message that was sent to the contact. Use this field for engagements to
         * <code>VOICE</code> and <code>EMAIL</code>.
         * </p>
         * 
         * @param subject
         *        The secure subject of the message that was sent to the contact. Use this field for engagements to
         *        <code>VOICE</code> and <code>EMAIL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);

        /**
         * <p>
         * The secure content of the message that was sent to the contact. Use this field for engagements to
         * <code>VOICE</code> and <code>EMAIL</code>.
         * </p>
         * 
         * @param content
         *        The secure content of the message that was sent to the contact. Use this field for engagements to
         *        <code>VOICE</code> and <code>EMAIL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The insecure subject of the message that was sent to the contact. Use this field for engagements to
         * <code>SMS</code>.
         * </p>
         * 
         * @param publicSubject
         *        The insecure subject of the message that was sent to the contact. Use this field for engagements to
         *        <code>SMS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicSubject(String publicSubject);

        /**
         * <p>
         * The insecure content of the message that was sent to the contact. Use this field for engagements to
         * <code>SMS</code>.
         * </p>
         * 
         * @param publicContent
         *        The insecure content of the message that was sent to the contact. Use this field for engagements to
         *        <code>SMS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicContent(String publicContent);

        /**
         * <p>
         * The ARN of the incident in which the engagement occurred.
         * </p>
         * 
         * @param incidentId
         *        The ARN of the incident in which the engagement occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incidentId(String incidentId);

        /**
         * <p>
         * The time that the engagement started.
         * </p>
         * 
         * @param startTime
         *        The time that the engagement started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time that the engagement ended.
         * </p>
         * 
         * @param stopTime
         *        The time that the engagement ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopTime(Instant stopTime);
    }

    static final class BuilderImpl extends SsmContactsResponse.BuilderImpl implements Builder {
        private String contactArn;

        private String engagementArn;

        private String sender;

        private String subject;

        private String content;

        private String publicSubject;

        private String publicContent;

        private String incidentId;

        private Instant startTime;

        private Instant stopTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEngagementResponse model) {
            super(model);
            contactArn(model.contactArn);
            engagementArn(model.engagementArn);
            sender(model.sender);
            subject(model.subject);
            content(model.content);
            publicSubject(model.publicSubject);
            publicContent(model.publicContent);
            incidentId(model.incidentId);
            startTime(model.startTime);
            stopTime(model.stopTime);
        }

        public final String getContactArn() {
            return contactArn;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        public final String getEngagementArn() {
            return engagementArn;
        }

        public final void setEngagementArn(String engagementArn) {
            this.engagementArn = engagementArn;
        }

        @Override
        public final Builder engagementArn(String engagementArn) {
            this.engagementArn = engagementArn;
            return this;
        }

        public final String getSender() {
            return sender;
        }

        public final void setSender(String sender) {
            this.sender = sender;
        }

        @Override
        public final Builder sender(String sender) {
            this.sender = sender;
            return this;
        }

        public final String getSubject() {
            return subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getPublicSubject() {
            return publicSubject;
        }

        public final void setPublicSubject(String publicSubject) {
            this.publicSubject = publicSubject;
        }

        @Override
        public final Builder publicSubject(String publicSubject) {
            this.publicSubject = publicSubject;
            return this;
        }

        public final String getPublicContent() {
            return publicContent;
        }

        public final void setPublicContent(String publicContent) {
            this.publicContent = publicContent;
        }

        @Override
        public final Builder publicContent(String publicContent) {
            this.publicContent = publicContent;
            return this;
        }

        public final String getIncidentId() {
            return incidentId;
        }

        public final void setIncidentId(String incidentId) {
            this.incidentId = incidentId;
        }

        @Override
        public final Builder incidentId(String incidentId) {
            this.incidentId = incidentId;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getStopTime() {
            return stopTime;
        }

        public final void setStopTime(Instant stopTime) {
            this.stopTime = stopTime;
        }

        @Override
        public final Builder stopTime(Instant stopTime) {
            this.stopTime = stopTime;
            return this;
        }

        @Override
        public DescribeEngagementResponse build() {
            return new DescribeEngagementResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
