/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePageResponse extends SsmContactsResponse implements
        ToCopyableBuilder<DescribePageResponse.Builder, DescribePageResponse> {
    private static final SdkField<String> PAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PageArn").getter(getter(DescribePageResponse::pageArn)).setter(setter(Builder::pageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageArn").build()).build();

    private static final SdkField<String> ENGAGEMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngagementArn").getter(getter(DescribePageResponse::engagementArn))
            .setter(setter(Builder::engagementArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementArn").build()).build();

    private static final SdkField<String> CONTACT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactArn").getter(getter(DescribePageResponse::contactArn)).setter(setter(Builder::contactArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactArn").build()).build();

    private static final SdkField<String> SENDER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Sender")
            .getter(getter(DescribePageResponse::sender)).setter(setter(Builder::sender))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sender").build()).build();

    private static final SdkField<String> SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Subject")
            .getter(getter(DescribePageResponse::subject)).setter(setter(Builder::subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(DescribePageResponse::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<String> PUBLIC_SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicSubject").getter(getter(DescribePageResponse::publicSubject))
            .setter(setter(Builder::publicSubject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicSubject").build()).build();

    private static final SdkField<String> PUBLIC_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicContent").getter(getter(DescribePageResponse::publicContent))
            .setter(setter(Builder::publicContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicContent").build()).build();

    private static final SdkField<String> INCIDENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IncidentId").getter(getter(DescribePageResponse::incidentId)).setter(setter(Builder::incidentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncidentId").build()).build();

    private static final SdkField<Instant> SENT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SentTime").getter(getter(DescribePageResponse::sentTime)).setter(setter(Builder::sentTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SentTime").build()).build();

    private static final SdkField<Instant> READ_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ReadTime").getter(getter(DescribePageResponse::readTime)).setter(setter(Builder::readTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadTime").build()).build();

    private static final SdkField<Instant> DELIVERY_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeliveryTime").getter(getter(DescribePageResponse::deliveryTime)).setter(setter(Builder::deliveryTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAGE_ARN_FIELD,
            ENGAGEMENT_ARN_FIELD, CONTACT_ARN_FIELD, SENDER_FIELD, SUBJECT_FIELD, CONTENT_FIELD, PUBLIC_SUBJECT_FIELD,
            PUBLIC_CONTENT_FIELD, INCIDENT_ID_FIELD, SENT_TIME_FIELD, READ_TIME_FIELD, DELIVERY_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String pageArn;

    private final String engagementArn;

    private final String contactArn;

    private final String sender;

    private final String subject;

    private final String content;

    private final String publicSubject;

    private final String publicContent;

    private final String incidentId;

    private final Instant sentTime;

    private final Instant readTime;

    private final Instant deliveryTime;

    private DescribePageResponse(BuilderImpl builder) {
        super(builder);
        this.pageArn = builder.pageArn;
        this.engagementArn = builder.engagementArn;
        this.contactArn = builder.contactArn;
        this.sender = builder.sender;
        this.subject = builder.subject;
        this.content = builder.content;
        this.publicSubject = builder.publicSubject;
        this.publicContent = builder.publicContent;
        this.incidentId = builder.incidentId;
        this.sentTime = builder.sentTime;
        this.readTime = builder.readTime;
        this.deliveryTime = builder.deliveryTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the engagement to a contact channel.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the engagement to a contact channel.
     */
    public final String pageArn() {
        return pageArn;
    }

    /**
     * <p>
     * The ARN of the engagement that engaged the contact channel.
     * </p>
     * 
     * @return The ARN of the engagement that engaged the contact channel.
     */
    public final String engagementArn() {
        return engagementArn;
    }

    /**
     * <p>
     * The ARN of the contact that was engaged.
     * </p>
     * 
     * @return The ARN of the contact that was engaged.
     */
    public final String contactArn() {
        return contactArn;
    }

    /**
     * <p>
     * The user that started the engagement.
     * </p>
     * 
     * @return The user that started the engagement.
     */
    public final String sender() {
        return sender;
    }

    /**
     * <p>
     * The secure subject of the message that was sent to the contact. Use this field for engagements to
     * <code>VOICE</code> and <code>EMAIL</code>.
     * </p>
     * 
     * @return The secure subject of the message that was sent to the contact. Use this field for engagements to
     *         <code>VOICE</code> and <code>EMAIL</code>.
     */
    public final String subject() {
        return subject;
    }

    /**
     * <p>
     * The secure content of the message that was sent to the contact. Use this field for engagements to
     * <code>VOICE</code> and <code>EMAIL</code>.
     * </p>
     * 
     * @return The secure content of the message that was sent to the contact. Use this field for engagements to
     *         <code>VOICE</code> and <code>EMAIL</code>.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * The insecure subject of the message that was sent to the contact. Use this field for engagements to
     * <code>SMS</code>.
     * </p>
     * 
     * @return The insecure subject of the message that was sent to the contact. Use this field for engagements to
     *         <code>SMS</code>.
     */
    public final String publicSubject() {
        return publicSubject;
    }

    /**
     * <p>
     * The insecure content of the message that was sent to the contact. Use this field for engagements to
     * <code>SMS</code>.
     * </p>
     * 
     * @return The insecure content of the message that was sent to the contact. Use this field for engagements to
     *         <code>SMS</code>.
     */
    public final String publicContent() {
        return publicContent;
    }

    /**
     * <p>
     * The ARN of the incident that engaged the contact channel.
     * </p>
     * 
     * @return The ARN of the incident that engaged the contact channel.
     */
    public final String incidentId() {
        return incidentId;
    }

    /**
     * <p>
     * The time the engagement was sent to the contact channel.
     * </p>
     * 
     * @return The time the engagement was sent to the contact channel.
     */
    public final Instant sentTime() {
        return sentTime;
    }

    /**
     * <p>
     * The time that the contact channel acknowledged the engagement.
     * </p>
     * 
     * @return The time that the contact channel acknowledged the engagement.
     */
    public final Instant readTime() {
        return readTime;
    }

    /**
     * <p>
     * The time that the contact channel received the engagement.
     * </p>
     * 
     * @return The time that the contact channel received the engagement.
     */
    public final Instant deliveryTime() {
        return deliveryTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pageArn());
        hashCode = 31 * hashCode + Objects.hashCode(engagementArn());
        hashCode = 31 * hashCode + Objects.hashCode(contactArn());
        hashCode = 31 * hashCode + Objects.hashCode(sender());
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(publicSubject());
        hashCode = 31 * hashCode + Objects.hashCode(publicContent());
        hashCode = 31 * hashCode + Objects.hashCode(incidentId());
        hashCode = 31 * hashCode + Objects.hashCode(sentTime());
        hashCode = 31 * hashCode + Objects.hashCode(readTime());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePageResponse)) {
            return false;
        }
        DescribePageResponse other = (DescribePageResponse) obj;
        return Objects.equals(pageArn(), other.pageArn()) && Objects.equals(engagementArn(), other.engagementArn())
                && Objects.equals(contactArn(), other.contactArn()) && Objects.equals(sender(), other.sender())
                && Objects.equals(subject(), other.subject()) && Objects.equals(content(), other.content())
                && Objects.equals(publicSubject(), other.publicSubject())
                && Objects.equals(publicContent(), other.publicContent()) && Objects.equals(incidentId(), other.incidentId())
                && Objects.equals(sentTime(), other.sentTime()) && Objects.equals(readTime(), other.readTime())
                && Objects.equals(deliveryTime(), other.deliveryTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePageResponse").add("PageArn", pageArn()).add("EngagementArn", engagementArn())
                .add("ContactArn", contactArn()).add("Sender", sender()).add("Subject", subject()).add("Content", content())
                .add("PublicSubject", publicSubject()).add("PublicContent", publicContent()).add("IncidentId", incidentId())
                .add("SentTime", sentTime()).add("ReadTime", readTime()).add("DeliveryTime", deliveryTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PageArn":
            return Optional.ofNullable(clazz.cast(pageArn()));
        case "EngagementArn":
            return Optional.ofNullable(clazz.cast(engagementArn()));
        case "ContactArn":
            return Optional.ofNullable(clazz.cast(contactArn()));
        case "Sender":
            return Optional.ofNullable(clazz.cast(sender()));
        case "Subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "PublicSubject":
            return Optional.ofNullable(clazz.cast(publicSubject()));
        case "PublicContent":
            return Optional.ofNullable(clazz.cast(publicContent()));
        case "IncidentId":
            return Optional.ofNullable(clazz.cast(incidentId()));
        case "SentTime":
            return Optional.ofNullable(clazz.cast(sentTime()));
        case "ReadTime":
            return Optional.ofNullable(clazz.cast(readTime()));
        case "DeliveryTime":
            return Optional.ofNullable(clazz.cast(deliveryTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PageArn", PAGE_ARN_FIELD);
        map.put("EngagementArn", ENGAGEMENT_ARN_FIELD);
        map.put("ContactArn", CONTACT_ARN_FIELD);
        map.put("Sender", SENDER_FIELD);
        map.put("Subject", SUBJECT_FIELD);
        map.put("Content", CONTENT_FIELD);
        map.put("PublicSubject", PUBLIC_SUBJECT_FIELD);
        map.put("PublicContent", PUBLIC_CONTENT_FIELD);
        map.put("IncidentId", INCIDENT_ID_FIELD);
        map.put("SentTime", SENT_TIME_FIELD);
        map.put("ReadTime", READ_TIME_FIELD);
        map.put("DeliveryTime", DELIVERY_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribePageResponse, T> g) {
        return obj -> g.apply((DescribePageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmContactsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribePageResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the engagement to a contact channel.
         * </p>
         * 
         * @param pageArn
         *        The Amazon Resource Name (ARN) of the engagement to a contact channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageArn(String pageArn);

        /**
         * <p>
         * The ARN of the engagement that engaged the contact channel.
         * </p>
         * 
         * @param engagementArn
         *        The ARN of the engagement that engaged the contact channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementArn(String engagementArn);

        /**
         * <p>
         * The ARN of the contact that was engaged.
         * </p>
         * 
         * @param contactArn
         *        The ARN of the contact that was engaged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactArn(String contactArn);

        /**
         * <p>
         * The user that started the engagement.
         * </p>
         * 
         * @param sender
         *        The user that started the engagement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sender(String sender);

        /**
         * <p>
         * The secure subject of the message that was sent to the contact. Use this field for engagements to
         * <code>VOICE</code> and <code>EMAIL</code>.
         * </p>
         * 
         * @param subject
         *        The secure subject of the message that was sent to the contact. Use this field for engagements to
         *        <code>VOICE</code> and <code>EMAIL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);

        /**
         * <p>
         * The secure content of the message that was sent to the contact. Use this field for engagements to
         * <code>VOICE</code> and <code>EMAIL</code>.
         * </p>
         * 
         * @param content
         *        The secure content of the message that was sent to the contact. Use this field for engagements to
         *        <code>VOICE</code> and <code>EMAIL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The insecure subject of the message that was sent to the contact. Use this field for engagements to
         * <code>SMS</code>.
         * </p>
         * 
         * @param publicSubject
         *        The insecure subject of the message that was sent to the contact. Use this field for engagements to
         *        <code>SMS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicSubject(String publicSubject);

        /**
         * <p>
         * The insecure content of the message that was sent to the contact. Use this field for engagements to
         * <code>SMS</code>.
         * </p>
         * 
         * @param publicContent
         *        The insecure content of the message that was sent to the contact. Use this field for engagements to
         *        <code>SMS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicContent(String publicContent);

        /**
         * <p>
         * The ARN of the incident that engaged the contact channel.
         * </p>
         * 
         * @param incidentId
         *        The ARN of the incident that engaged the contact channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incidentId(String incidentId);

        /**
         * <p>
         * The time the engagement was sent to the contact channel.
         * </p>
         * 
         * @param sentTime
         *        The time the engagement was sent to the contact channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sentTime(Instant sentTime);

        /**
         * <p>
         * The time that the contact channel acknowledged the engagement.
         * </p>
         * 
         * @param readTime
         *        The time that the contact channel acknowledged the engagement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readTime(Instant readTime);

        /**
         * <p>
         * The time that the contact channel received the engagement.
         * </p>
         * 
         * @param deliveryTime
         *        The time that the contact channel received the engagement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryTime(Instant deliveryTime);
    }

    static final class BuilderImpl extends SsmContactsResponse.BuilderImpl implements Builder {
        private String pageArn;

        private String engagementArn;

        private String contactArn;

        private String sender;

        private String subject;

        private String content;

        private String publicSubject;

        private String publicContent;

        private String incidentId;

        private Instant sentTime;

        private Instant readTime;

        private Instant deliveryTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePageResponse model) {
            super(model);
            pageArn(model.pageArn);
            engagementArn(model.engagementArn);
            contactArn(model.contactArn);
            sender(model.sender);
            subject(model.subject);
            content(model.content);
            publicSubject(model.publicSubject);
            publicContent(model.publicContent);
            incidentId(model.incidentId);
            sentTime(model.sentTime);
            readTime(model.readTime);
            deliveryTime(model.deliveryTime);
        }

        public final String getPageArn() {
            return pageArn;
        }

        public final void setPageArn(String pageArn) {
            this.pageArn = pageArn;
        }

        @Override
        public final Builder pageArn(String pageArn) {
            this.pageArn = pageArn;
            return this;
        }

        public final String getEngagementArn() {
            return engagementArn;
        }

        public final void setEngagementArn(String engagementArn) {
            this.engagementArn = engagementArn;
        }

        @Override
        public final Builder engagementArn(String engagementArn) {
            this.engagementArn = engagementArn;
            return this;
        }

        public final String getContactArn() {
            return contactArn;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        public final String getSender() {
            return sender;
        }

        public final void setSender(String sender) {
            this.sender = sender;
        }

        @Override
        public final Builder sender(String sender) {
            this.sender = sender;
            return this;
        }

        public final String getSubject() {
            return subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getPublicSubject() {
            return publicSubject;
        }

        public final void setPublicSubject(String publicSubject) {
            this.publicSubject = publicSubject;
        }

        @Override
        public final Builder publicSubject(String publicSubject) {
            this.publicSubject = publicSubject;
            return this;
        }

        public final String getPublicContent() {
            return publicContent;
        }

        public final void setPublicContent(String publicContent) {
            this.publicContent = publicContent;
        }

        @Override
        public final Builder publicContent(String publicContent) {
            this.publicContent = publicContent;
            return this;
        }

        public final String getIncidentId() {
            return incidentId;
        }

        public final void setIncidentId(String incidentId) {
            this.incidentId = incidentId;
        }

        @Override
        public final Builder incidentId(String incidentId) {
            this.incidentId = incidentId;
            return this;
        }

        public final Instant getSentTime() {
            return sentTime;
        }

        public final void setSentTime(Instant sentTime) {
            this.sentTime = sentTime;
        }

        @Override
        public final Builder sentTime(Instant sentTime) {
            this.sentTime = sentTime;
            return this;
        }

        public final Instant getReadTime() {
            return readTime;
        }

        public final void setReadTime(Instant readTime) {
            this.readTime = readTime;
        }

        @Override
        public final Builder readTime(Instant readTime) {
            this.readTime = readTime;
            return this;
        }

        public final Instant getDeliveryTime() {
            return deliveryTime;
        }

        public final void setDeliveryTime(Instant deliveryTime) {
            this.deliveryTime = deliveryTime;
        }

        @Override
        public final Builder deliveryTime(Instant deliveryTime) {
            this.deliveryTime = deliveryTime;
            return this;
        }

        @Override
        public DescribePageResponse build() {
            return new DescribePageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
