/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetContactChannelResponse extends SsmContactsResponse implements
        ToCopyableBuilder<GetContactChannelResponse.Builder, GetContactChannelResponse> {
    private static final SdkField<String> CONTACT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactArn").getter(getter(GetContactChannelResponse::contactArn)).setter(setter(Builder::contactArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactArn").build()).build();

    private static final SdkField<String> CONTACT_CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactChannelArn").getter(getter(GetContactChannelResponse::contactChannelArn))
            .setter(setter(Builder::contactChannelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactChannelArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetContactChannelResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(GetContactChannelResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<ContactChannelAddress> DELIVERY_ADDRESS_FIELD = SdkField
            .<ContactChannelAddress> builder(MarshallingType.SDK_POJO).memberName("DeliveryAddress")
            .getter(getter(GetContactChannelResponse::deliveryAddress)).setter(setter(Builder::deliveryAddress))
            .constructor(ContactChannelAddress::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryAddress").build()).build();

    private static final SdkField<String> ACTIVATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActivationStatus").getter(getter(GetContactChannelResponse::activationStatusAsString))
            .setter(setter(Builder::activationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ARN_FIELD,
            CONTACT_CHANNEL_ARN_FIELD, NAME_FIELD, TYPE_FIELD, DELIVERY_ADDRESS_FIELD, ACTIVATION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String contactArn;

    private final String contactChannelArn;

    private final String name;

    private final String type;

    private final ContactChannelAddress deliveryAddress;

    private final String activationStatus;

    private GetContactChannelResponse(BuilderImpl builder) {
        super(builder);
        this.contactArn = builder.contactArn;
        this.contactChannelArn = builder.contactChannelArn;
        this.name = builder.name;
        this.type = builder.type;
        this.deliveryAddress = builder.deliveryAddress;
        this.activationStatus = builder.activationStatus;
    }

    /**
     * <p>
     * The ARN of the contact that the channel belongs to.
     * </p>
     * 
     * @return The ARN of the contact that the channel belongs to.
     */
    public final String contactArn() {
        return contactArn;
    }

    /**
     * <p>
     * The ARN of the contact channel.
     * </p>
     * 
     * @return The ARN of the contact channel.
     */
    public final String contactChannelArn() {
        return contactChannelArn;
    }

    /**
     * <p>
     * The name of the contact channel
     * </p>
     * 
     * @return The name of the contact channel
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of contact channel. The type is <code>SMS</code>, <code>VOICE</code>, or <code>EMAIL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of contact channel. The type is <code>SMS</code>, <code>VOICE</code>, or <code>EMAIL</code>.
     * @see ChannelType
     */
    public final ChannelType type() {
        return ChannelType.fromValue(type);
    }

    /**
     * <p>
     * The type of contact channel. The type is <code>SMS</code>, <code>VOICE</code>, or <code>EMAIL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of contact channel. The type is <code>SMS</code>, <code>VOICE</code>, or <code>EMAIL</code>.
     * @see ChannelType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The details that Incident Manager uses when trying to engage the contact channel.
     * </p>
     * 
     * @return The details that Incident Manager uses when trying to engage the contact channel.
     */
    public final ContactChannelAddress deliveryAddress() {
        return deliveryAddress;
    }

    /**
     * <p>
     * A Boolean value indicating if the contact channel has been activated or not.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #activationStatus}
     * will return {@link ActivationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #activationStatusAsString}.
     * </p>
     * 
     * @return A Boolean value indicating if the contact channel has been activated or not.
     * @see ActivationStatus
     */
    public final ActivationStatus activationStatus() {
        return ActivationStatus.fromValue(activationStatus);
    }

    /**
     * <p>
     * A Boolean value indicating if the contact channel has been activated or not.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #activationStatus}
     * will return {@link ActivationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #activationStatusAsString}.
     * </p>
     * 
     * @return A Boolean value indicating if the contact channel has been activated or not.
     * @see ActivationStatus
     */
    public final String activationStatusAsString() {
        return activationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contactArn());
        hashCode = 31 * hashCode + Objects.hashCode(contactChannelArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryAddress());
        hashCode = 31 * hashCode + Objects.hashCode(activationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContactChannelResponse)) {
            return false;
        }
        GetContactChannelResponse other = (GetContactChannelResponse) obj;
        return Objects.equals(contactArn(), other.contactArn()) && Objects.equals(contactChannelArn(), other.contactChannelArn())
                && Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(deliveryAddress(), other.deliveryAddress())
                && Objects.equals(activationStatusAsString(), other.activationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetContactChannelResponse").add("ContactArn", contactArn())
                .add("ContactChannelArn", contactChannelArn()).add("Name", name()).add("Type", typeAsString())
                .add("DeliveryAddress", deliveryAddress()).add("ActivationStatus", activationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactArn":
            return Optional.ofNullable(clazz.cast(contactArn()));
        case "ContactChannelArn":
            return Optional.ofNullable(clazz.cast(contactChannelArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "DeliveryAddress":
            return Optional.ofNullable(clazz.cast(deliveryAddress()));
        case "ActivationStatus":
            return Optional.ofNullable(clazz.cast(activationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContactArn", CONTACT_ARN_FIELD);
        map.put("ContactChannelArn", CONTACT_CHANNEL_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("DeliveryAddress", DELIVERY_ADDRESS_FIELD);
        map.put("ActivationStatus", ACTIVATION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetContactChannelResponse, T> g) {
        return obj -> g.apply((GetContactChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmContactsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetContactChannelResponse> {
        /**
         * <p>
         * The ARN of the contact that the channel belongs to.
         * </p>
         * 
         * @param contactArn
         *        The ARN of the contact that the channel belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactArn(String contactArn);

        /**
         * <p>
         * The ARN of the contact channel.
         * </p>
         * 
         * @param contactChannelArn
         *        The ARN of the contact channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactChannelArn(String contactChannelArn);

        /**
         * <p>
         * The name of the contact channel
         * </p>
         * 
         * @param name
         *        The name of the contact channel
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of contact channel. The type is <code>SMS</code>, <code>VOICE</code>, or <code>EMAIL</code>.
         * </p>
         * 
         * @param type
         *        The type of contact channel. The type is <code>SMS</code>, <code>VOICE</code>, or <code>EMAIL</code>.
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of contact channel. The type is <code>SMS</code>, <code>VOICE</code>, or <code>EMAIL</code>.
         * </p>
         * 
         * @param type
         *        The type of contact channel. The type is <code>SMS</code>, <code>VOICE</code>, or <code>EMAIL</code>.
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder type(ChannelType type);

        /**
         * <p>
         * The details that Incident Manager uses when trying to engage the contact channel.
         * </p>
         * 
         * @param deliveryAddress
         *        The details that Incident Manager uses when trying to engage the contact channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryAddress(ContactChannelAddress deliveryAddress);

        /**
         * <p>
         * The details that Incident Manager uses when trying to engage the contact channel.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContactChannelAddress.Builder} avoiding
         * the need to create one manually via {@link ContactChannelAddress#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContactChannelAddress.Builder#build()} is called immediately and
         * its result is passed to {@link #deliveryAddress(ContactChannelAddress)}.
         * 
         * @param deliveryAddress
         *        a consumer that will call methods on {@link ContactChannelAddress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deliveryAddress(ContactChannelAddress)
         */
        default Builder deliveryAddress(Consumer<ContactChannelAddress.Builder> deliveryAddress) {
            return deliveryAddress(ContactChannelAddress.builder().applyMutation(deliveryAddress).build());
        }

        /**
         * <p>
         * A Boolean value indicating if the contact channel has been activated or not.
         * </p>
         * 
         * @param activationStatus
         *        A Boolean value indicating if the contact channel has been activated or not.
         * @see ActivationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivationStatus
         */
        Builder activationStatus(String activationStatus);

        /**
         * <p>
         * A Boolean value indicating if the contact channel has been activated or not.
         * </p>
         * 
         * @param activationStatus
         *        A Boolean value indicating if the contact channel has been activated or not.
         * @see ActivationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivationStatus
         */
        Builder activationStatus(ActivationStatus activationStatus);
    }

    static final class BuilderImpl extends SsmContactsResponse.BuilderImpl implements Builder {
        private String contactArn;

        private String contactChannelArn;

        private String name;

        private String type;

        private ContactChannelAddress deliveryAddress;

        private String activationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetContactChannelResponse model) {
            super(model);
            contactArn(model.contactArn);
            contactChannelArn(model.contactChannelArn);
            name(model.name);
            type(model.type);
            deliveryAddress(model.deliveryAddress);
            activationStatus(model.activationStatus);
        }

        public final String getContactArn() {
            return contactArn;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        public final String getContactChannelArn() {
            return contactChannelArn;
        }

        public final void setContactChannelArn(String contactChannelArn) {
            this.contactChannelArn = contactChannelArn;
        }

        @Override
        public final Builder contactChannelArn(String contactChannelArn) {
            this.contactChannelArn = contactChannelArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChannelType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final ContactChannelAddress.Builder getDeliveryAddress() {
            return deliveryAddress != null ? deliveryAddress.toBuilder() : null;
        }

        public final void setDeliveryAddress(ContactChannelAddress.BuilderImpl deliveryAddress) {
            this.deliveryAddress = deliveryAddress != null ? deliveryAddress.build() : null;
        }

        @Override
        public final Builder deliveryAddress(ContactChannelAddress deliveryAddress) {
            this.deliveryAddress = deliveryAddress;
            return this;
        }

        public final String getActivationStatus() {
            return activationStatus;
        }

        public final void setActivationStatus(String activationStatus) {
            this.activationStatus = activationStatus;
        }

        @Override
        public final Builder activationStatus(String activationStatus) {
            this.activationStatus = activationStatus;
            return this;
        }

        @Override
        public final Builder activationStatus(ActivationStatus activationStatus) {
            this.activationStatus(activationStatus == null ? null : activationStatus.toString());
            return this;
        }

        @Override
        public GetContactChannelResponse build() {
            return new GetContactChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
