/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRotationOverrideResponse extends SsmContactsResponse implements
        ToCopyableBuilder<GetRotationOverrideResponse.Builder, GetRotationOverrideResponse> {
    private static final SdkField<String> ROTATION_OVERRIDE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RotationOverrideId").getter(getter(GetRotationOverrideResponse::rotationOverrideId))
            .setter(setter(Builder::rotationOverrideId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationOverrideId").build())
            .build();

    private static final SdkField<String> ROTATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RotationArn").getter(getter(GetRotationOverrideResponse::rotationArn))
            .setter(setter(Builder::rotationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationArn").build()).build();

    private static final SdkField<List<String>> NEW_CONTACT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NewContactIds")
            .getter(getter(GetRotationOverrideResponse::newContactIds))
            .setter(setter(Builder::newContactIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewContactIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(GetRotationOverrideResponse::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(GetRotationOverrideResponse::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime").getter(getter(GetRotationOverrideResponse::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROTATION_OVERRIDE_ID_FIELD,
            ROTATION_ARN_FIELD, NEW_CONTACT_IDS_FIELD, START_TIME_FIELD, END_TIME_FIELD, CREATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String rotationOverrideId;

    private final String rotationArn;

    private final List<String> newContactIds;

    private final Instant startTime;

    private final Instant endTime;

    private final Instant createTime;

    private GetRotationOverrideResponse(BuilderImpl builder) {
        super(builder);
        this.rotationOverrideId = builder.rotationOverrideId;
        this.rotationArn = builder.rotationArn;
        this.newContactIds = builder.newContactIds;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.createTime = builder.createTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the override to an on-call rotation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the override to an on-call rotation.
     */
    public final String rotationOverrideId() {
        return rotationOverrideId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the on-call rotation that was overridden.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the on-call rotation that was overridden.
     */
    public final String rotationArn() {
        return rotationArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the NewContactIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNewContactIds() {
        return newContactIds != null && !(newContactIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of the contacts assigned to the override of the on-call rotation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNewContactIds} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of the contacts assigned to the override of the on-call rotation.
     */
    public final List<String> newContactIds() {
        return newContactIds;
    }

    /**
     * <p>
     * The date and time when the override goes into effect.
     * </p>
     * 
     * @return The date and time when the override goes into effect.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The date and time when the override ends.
     * </p>
     * 
     * @return The date and time when the override ends.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The date and time when the override was created.
     * </p>
     * 
     * @return The date and time when the override was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(rotationOverrideId());
        hashCode = 31 * hashCode + Objects.hashCode(rotationArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasNewContactIds() ? newContactIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRotationOverrideResponse)) {
            return false;
        }
        GetRotationOverrideResponse other = (GetRotationOverrideResponse) obj;
        return Objects.equals(rotationOverrideId(), other.rotationOverrideId())
                && Objects.equals(rotationArn(), other.rotationArn()) && hasNewContactIds() == other.hasNewContactIds()
                && Objects.equals(newContactIds(), other.newContactIds()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(createTime(), other.createTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRotationOverrideResponse").add("RotationOverrideId", rotationOverrideId())
                .add("RotationArn", rotationArn()).add("NewContactIds", hasNewContactIds() ? newContactIds() : null)
                .add("StartTime", startTime()).add("EndTime", endTime()).add("CreateTime", createTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RotationOverrideId":
            return Optional.ofNullable(clazz.cast(rotationOverrideId()));
        case "RotationArn":
            return Optional.ofNullable(clazz.cast(rotationArn()));
        case "NewContactIds":
            return Optional.ofNullable(clazz.cast(newContactIds()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RotationOverrideId", ROTATION_OVERRIDE_ID_FIELD);
        map.put("RotationArn", ROTATION_ARN_FIELD);
        map.put("NewContactIds", NEW_CONTACT_IDS_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRotationOverrideResponse, T> g) {
        return obj -> g.apply((GetRotationOverrideResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmContactsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRotationOverrideResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the override to an on-call rotation.
         * </p>
         * 
         * @param rotationOverrideId
         *        The Amazon Resource Name (ARN) of the override to an on-call rotation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationOverrideId(String rotationOverrideId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the on-call rotation that was overridden.
         * </p>
         * 
         * @param rotationArn
         *        The Amazon Resource Name (ARN) of the on-call rotation that was overridden.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationArn(String rotationArn);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the contacts assigned to the override of the on-call rotation.
         * </p>
         * 
         * @param newContactIds
         *        The Amazon Resource Names (ARNs) of the contacts assigned to the override of the on-call rotation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newContactIds(Collection<String> newContactIds);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the contacts assigned to the override of the on-call rotation.
         * </p>
         * 
         * @param newContactIds
         *        The Amazon Resource Names (ARNs) of the contacts assigned to the override of the on-call rotation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newContactIds(String... newContactIds);

        /**
         * <p>
         * The date and time when the override goes into effect.
         * </p>
         * 
         * @param startTime
         *        The date and time when the override goes into effect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The date and time when the override ends.
         * </p>
         * 
         * @param endTime
         *        The date and time when the override ends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The date and time when the override was created.
         * </p>
         * 
         * @param createTime
         *        The date and time when the override was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);
    }

    static final class BuilderImpl extends SsmContactsResponse.BuilderImpl implements Builder {
        private String rotationOverrideId;

        private String rotationArn;

        private List<String> newContactIds = DefaultSdkAutoConstructList.getInstance();

        private Instant startTime;

        private Instant endTime;

        private Instant createTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRotationOverrideResponse model) {
            super(model);
            rotationOverrideId(model.rotationOverrideId);
            rotationArn(model.rotationArn);
            newContactIds(model.newContactIds);
            startTime(model.startTime);
            endTime(model.endTime);
            createTime(model.createTime);
        }

        public final String getRotationOverrideId() {
            return rotationOverrideId;
        }

        public final void setRotationOverrideId(String rotationOverrideId) {
            this.rotationOverrideId = rotationOverrideId;
        }

        @Override
        public final Builder rotationOverrideId(String rotationOverrideId) {
            this.rotationOverrideId = rotationOverrideId;
            return this;
        }

        public final String getRotationArn() {
            return rotationArn;
        }

        public final void setRotationArn(String rotationArn) {
            this.rotationArn = rotationArn;
        }

        @Override
        public final Builder rotationArn(String rotationArn) {
            this.rotationArn = rotationArn;
            return this;
        }

        public final Collection<String> getNewContactIds() {
            if (newContactIds instanceof SdkAutoConstructList) {
                return null;
            }
            return newContactIds;
        }

        public final void setNewContactIds(Collection<String> newContactIds) {
            this.newContactIds = SsmContactsArnListCopier.copy(newContactIds);
        }

        @Override
        public final Builder newContactIds(Collection<String> newContactIds) {
            this.newContactIds = SsmContactsArnListCopier.copy(newContactIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder newContactIds(String... newContactIds) {
            newContactIds(Arrays.asList(newContactIds));
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        @Override
        public GetRotationOverrideResponse build() {
            return new GetRotationOverrideResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
